/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFAverage;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCorrelation;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVariance;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class GenericUDAFBinarySetFunctions
extends AbstractGenericUDAFResolver {
    private static void checkArgumentTypes(TypeInfo[] parameters) throws UDFArgumentTypeException {
        if (parameters.length != 2) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly two arguments are expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        if (parameters[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "Only primitive type arguments are accepted but " + parameters[1].getTypeName() + " is passed.");
        }
        if (!GenericUDAFBinarySetFunctions.acceptedPrimitiveCategory(((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory())) {
            throw new UDFArgumentTypeException(0, "Only numeric type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        if (!GenericUDAFBinarySetFunctions.acceptedPrimitiveCategory(((PrimitiveTypeInfo)parameters[1]).getPrimitiveCategory())) {
            throw new UDFArgumentTypeException(1, "Only numeric type arguments are accepted but " + parameters[1].getTypeName() + " is passed.");
        }
    }

    private static boolean acceptedPrimitiveCategory(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        switch (primitiveCategory) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case TIMESTAMP: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    @Description(name="regr_intercept", value="_FUNC_(y,x) - returns the y-intercept of the regression line.", extended="The function takes as arguments any pair of numeric types and returns a double.\nAny pair with a NULL is ignored.\nIf applied to an empty set: NULL is returned.\nIf N*SUM(x*x) = SUM(x)*SUM(x): NULL is returned.\nOtherwise, it computes the following:\n   ( SUM(y)*SUM(x*x)-SUM(X)*SUM(x*y) )  /  ( N*SUM(x*x)-SUM(x)*SUM(x) )")
    public static class RegrIntercept
    extends AbstractGenericUDAFResolver {
        @Override
        public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
            GenericUDAFBinarySetFunctions.checkArgumentTypes(parameters);
            return new Evaluator();
        }

        private static class Evaluator
        extends GenericUDAFCorrelation.GenericUDAFCorrelationEvaluator {
            private Evaluator() {
            }

            @Override
            public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
                GenericUDAFCorrelation.GenericUDAFCorrelationEvaluator.StdAgg myagg = (GenericUDAFCorrelation.GenericUDAFCorrelationEvaluator.StdAgg)agg;
                if (myagg.count == 0L || myagg.xvar == 0.0) {
                    return null;
                }
                DoubleWritable result = this.getResult();
                double slope = myagg.covar / myagg.xvar;
                result.set(myagg.yavg - slope * myagg.xavg);
                return result;
            }
        }
    }

    @Description(name="regr_sxy", value="_FUNC_(y,x) - return a value that can be used to evaluate the statistical validity of a regression model.", extended="The function takes as arguments any pair of numeric types and returns a double.\nAny pair with a NULL is ignored.\nIf applied to an empty set: NULL is returned.\nIf N*SUM(x*x) = SUM(x)*SUM(x): NULL is returned.\nOtherwise, it computes the following:\n   SUM(x*y)-SUM(x)*SUM(y)/N")
    public static class RegrSXY
    extends AbstractGenericUDAFResolver {
        @Override
        public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
            GenericUDAFBinarySetFunctions.checkArgumentTypes(parameters);
            return new Evaluator();
        }

        private static class Evaluator
        extends GenericUDAFCorrelation.GenericUDAFCorrelationEvaluator {
            private Evaluator() {
            }

            @Override
            public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
                GenericUDAFCorrelation.GenericUDAFCorrelationEvaluator.StdAgg myagg = (GenericUDAFCorrelation.GenericUDAFCorrelationEvaluator.StdAgg)agg;
                if (myagg.count == 0L) {
                    return null;
                }
                DoubleWritable result = this.getResult();
                result.set(myagg.covar);
                return result;
            }
        }
    }

    @Description(name="regr_r2", value="_FUNC_(y,x) - returns the coefficient of determination (also called R-squared or goodness of fit) for the regression line.", extended="The function takes as arguments any pair of numeric types and returns a double.\nAny pair with a NULL is ignored.\nIf applied to an empty set: NULL is returned.\nIf N*SUM(x*x) = SUM(x)*SUM(x): NULL is returned.\nIf N*SUM(y*y) = SUM(y)*SUM(y): 1 is returned.\nOtherwise, it computes the following:\n   POWER( N*SUM(x*y)-SUM(x)*SUM(y) ,2)  /  ( (N*SUM(x*x)-SUM(x)*SUM(x)) * (N*SUM(y*y)-SUM(y)*SUM(y)) )")
    public static class RegrR2
    extends AbstractGenericUDAFResolver {
        @Override
        public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
            GenericUDAFBinarySetFunctions.checkArgumentTypes(parameters);
            return new Evaluator();
        }

        private static class Evaluator
        extends GenericUDAFCorrelation.GenericUDAFCorrelationEvaluator {
            private Evaluator() {
            }

            @Override
            public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
                GenericUDAFCorrelation.GenericUDAFCorrelationEvaluator.StdAgg myagg = (GenericUDAFCorrelation.GenericUDAFCorrelationEvaluator.StdAgg)agg;
                if (myagg.count < 2L || myagg.xvar == 0.0) {
                    return null;
                }
                DoubleWritable result = this.getResult();
                if (myagg.yvar == 0.0) {
                    result.set(1.0);
                } else {
                    result.set(myagg.covar * myagg.covar / myagg.xvar / myagg.yvar);
                }
                return result;
            }
        }
    }

    @Description(name="regr_slope", value="_FUNC_(y,x) - returns the slope of the linear regression line", extended="The function takes as arguments any pair of numeric types and returns a double.\nAny pair with a NULL is ignored.\nIf applied to an empty set: NULL is returned.\nIf N*SUM(x*x) = SUM(x)*SUM(x): NULL is returned (the fit would be a vertical).\nOtherwise, it computes the following:\n   (N*SUM(x*y)-SUM(x)*SUM(y)) / (N*SUM(x*x)-SUM(x)*SUM(x))")
    public static class RegrSlope
    extends AbstractGenericUDAFResolver {
        @Override
        public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
            GenericUDAFBinarySetFunctions.checkArgumentTypes(parameters);
            return new Evaluator();
        }

        private static class Evaluator
        extends GenericUDAFCorrelation.GenericUDAFCorrelationEvaluator {
            private Evaluator() {
            }

            @Override
            public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
                GenericUDAFCorrelation.GenericUDAFCorrelationEvaluator.StdAgg myagg = (GenericUDAFCorrelation.GenericUDAFCorrelationEvaluator.StdAgg)agg;
                if (myagg.count < 2L || myagg.xvar == 0.0) {
                    return null;
                }
                this.getResult().set(myagg.covar / myagg.xvar);
                return this.getResult();
            }
        }
    }

    @Description(name="regr_avgy", value="_FUNC_(y,x) - evaluates the average of the dependent variable", extended="The function takes as arguments any pair of numeric types and returns a double.\nAny pair with a NULL is ignored.\nIf applied to an empty set: NULL is returned.\nOtherwise, it computes the following:\n   AVG(Y)")
    public static class RegrAvgY
    extends AbstractGenericUDAFResolver {
        @Override
        public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
            GenericUDAFBinarySetFunctions.checkArgumentTypes(parameters);
            if (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.DECIMAL) {
                return new EvaluatorDecimal();
            }
            return new EvaluatorDouble();
        }

        private static class EvaluatorDecimal
        extends GenericUDAFAverage.GenericUDAFAverageEvaluatorDecimal {
            private EvaluatorDecimal() {
            }

            @Override
            public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
                switch (m) {
                    case COMPLETE: 
                    case PARTIAL1: {
                        return super.init(m, new ObjectInspector[]{parameters[0]});
                    }
                }
                return super.init(m, parameters);
            }

            @Override
            public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
                if (parameters[0] == null || parameters[1] == null) {
                    return;
                }
                super.iterate(agg, new Object[]{parameters[0]});
            }
        }

        private static class EvaluatorDouble
        extends GenericUDAFAverage.GenericUDAFAverageEvaluatorDouble {
            private EvaluatorDouble() {
            }

            @Override
            public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
                switch (m) {
                    case COMPLETE: 
                    case PARTIAL1: {
                        return super.init(m, new ObjectInspector[]{parameters[0]});
                    }
                }
                return super.init(m, parameters);
            }

            @Override
            public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
                if (parameters[0] == null || parameters[1] == null) {
                    return;
                }
                super.iterate(agg, new Object[]{parameters[0]});
            }
        }
    }

    @Description(name="regr_avgx", value="_FUNC_(y,x) - evaluates the average of the independent variable", extended="The function takes as arguments any pair of numeric types and returns a double.\nAny pair with a NULL is ignored.\nIf applied to an empty set: NULL is returned.\nOtherwise, it computes the following:\n   AVG(X)")
    public static class RegrAvgX
    extends AbstractGenericUDAFResolver {
        @Override
        public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
            GenericUDAFBinarySetFunctions.checkArgumentTypes(parameters);
            if (((PrimitiveTypeInfo)parameters[1]).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.DECIMAL) {
                return new EvaluatorDecimal();
            }
            return new EvaluatorDouble();
        }

        private static class EvaluatorDecimal
        extends GenericUDAFAverage.GenericUDAFAverageEvaluatorDecimal {
            private EvaluatorDecimal() {
            }

            @Override
            public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
                switch (m) {
                    case COMPLETE: 
                    case PARTIAL1: {
                        return super.init(m, new ObjectInspector[]{parameters[1]});
                    }
                }
                return super.init(m, parameters);
            }

            @Override
            public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
                if (parameters[0] == null || parameters[1] == null) {
                    return;
                }
                super.iterate(agg, new Object[]{parameters[1]});
            }
        }

        private static class EvaluatorDouble
        extends GenericUDAFAverage.GenericUDAFAverageEvaluatorDouble {
            private EvaluatorDouble() {
            }

            @Override
            public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
                switch (m) {
                    case COMPLETE: 
                    case PARTIAL1: {
                        return super.init(m, new ObjectInspector[]{parameters[1]});
                    }
                }
                return super.init(m, parameters);
            }

            @Override
            public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
                if (parameters[0] == null || parameters[1] == null) {
                    return;
                }
                super.iterate(agg, new Object[]{parameters[1]});
            }
        }
    }

    @Description(name="regr_syy", value="_FUNC_(y,x) - auxiliary analytic function", extended="The function takes as arguments any pair of numeric types and returns a double.\nAny pair with a NULL is ignored.\nIf applied to an empty set: NULL is returned.\nOtherwise, it computes the following:\n   SUM(y*y)-SUM(y)*SUM(y)/N\n")
    public static class RegrSYY
    extends AbstractGenericUDAFResolver {
        @Override
        public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
            GenericUDAFBinarySetFunctions.checkArgumentTypes(parameters);
            return new Evaluator();
        }

        private static class Evaluator
        extends GenericUDAFVariance.GenericUDAFVarianceEvaluator {
            private Evaluator() {
            }

            @Override
            public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
                switch (m) {
                    case COMPLETE: 
                    case PARTIAL1: {
                        return super.init(m, new ObjectInspector[]{parameters[0]});
                    }
                }
                return super.init(m, parameters);
            }

            @Override
            public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
                if (parameters[0] == null || parameters[1] == null) {
                    return;
                }
                super.iterate(agg, new Object[]{parameters[0]});
            }

            @Override
            public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
                GenericUDAFVariance.GenericUDAFVarianceEvaluator.StdAgg myagg = (GenericUDAFVariance.GenericUDAFVarianceEvaluator.StdAgg)agg;
                if (myagg.count == 0L) {
                    return null;
                }
                DoubleWritable result = this.getResult();
                result.set(myagg.variance);
                return result;
            }
        }
    }

    @Description(name="regr_sxx", value="_FUNC_(y,x) - auxiliary analytic function", extended="The function takes as arguments any pair of numeric types and returns a double.\nAny pair with a NULL is ignored.\nIf applied to an empty set: NULL is returned.\nOtherwise, it computes the following:\n   SUM(x*x)-SUM(x)*SUM(x)/N\n")
    public static class RegrSXX
    extends AbstractGenericUDAFResolver {
        @Override
        public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
            GenericUDAFBinarySetFunctions.checkArgumentTypes(parameters);
            return new Evaluator();
        }

        private static class Evaluator
        extends GenericUDAFVariance.GenericUDAFVarianceEvaluator {
            private Evaluator() {
            }

            @Override
            public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
                switch (m) {
                    case COMPLETE: 
                    case PARTIAL1: {
                        return super.init(m, new ObjectInspector[]{parameters[1]});
                    }
                }
                return super.init(m, parameters);
            }

            @Override
            public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
                if (parameters[0] == null || parameters[1] == null) {
                    return;
                }
                super.iterate(agg, new Object[]{parameters[1]});
            }

            @Override
            public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
                GenericUDAFVariance.GenericUDAFVarianceEvaluator.StdAgg myagg = (GenericUDAFVariance.GenericUDAFVarianceEvaluator.StdAgg)agg;
                if (myagg.count == 0L) {
                    return null;
                }
                DoubleWritable result = this.getResult();
                result.set(myagg.variance);
                return result;
            }
        }
    }

    @Description(name="regr_count", value="_FUNC_(y,x) - returns the number of non-null pairs", extended="The function takes as arguments any pair of numeric types and returns a long.\nAny pair with a NULL is ignored.")
    public static class RegrCount
    extends AbstractGenericUDAFResolver {
        @Override
        public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
            GenericUDAFBinarySetFunctions.checkArgumentTypes(parameters);
            return new Evaluator();
        }

        private static class Evaluator
        extends GenericUDAFCount.GenericUDAFCountEvaluator {
            private Evaluator() {
            }

            @Override
            public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
                switch (m) {
                    case COMPLETE: 
                    case PARTIAL1: {
                        return super.init(m, new ObjectInspector[]{parameters[0]});
                    }
                }
                return super.init(m, parameters);
            }

            @Override
            public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
                if (parameters[0] == null || parameters[1] == null) {
                    return;
                }
                super.iterate(agg, new Object[]{parameters[0]});
            }
        }
    }
}

