/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;

@Description(name="replicate_rows", value="_FUNC_(n, cols...) - turns 1 row into n rows")
public class GenericUDTFReplicateRows
extends GenericUDTF {
    private transient List<ObjectInspector> argOIs = new ArrayList<ObjectInspector>();

    @Override
    public void close() throws HiveException {
    }

    @Override
    public StructObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        if (args.length < 2) {
            throw new UDFArgumentException("UDTFReplicateRows() expects at least two arguments.");
        }
        if (!(args[0] instanceof LongObjectInspector)) {
            throw new UDFArgumentException("The first argument to UDTFReplicateRows() must be a long (got " + args[0].getTypeName() + " instead).");
        }
        ArrayList<CallSite> fieldNames = new ArrayList<CallSite>();
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>();
        for (int index = 0; index < args.length; ++index) {
            fieldNames.add((CallSite)((Object)("col" + index)));
            fieldOIs.add(args[index]);
        }
        this.argOIs = fieldOIs;
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    @Override
    public void process(Object[] args) throws HiveException, UDFArgumentException {
        long numRows = ((LongObjectInspector)this.argOIs.get(0)).get(args[0]);
        for (long n = 0L; n < numRows; ++n) {
            this.forward(args);
        }
    }

    public String toString() {
        return "UDTFReplicateRows";
    }
}

