/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformer;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;

class HiveCharTransformerAdapter
extends AbstractTransformerAdapter {
    final HiveCharObjectInspector columnType;
    final HiveCharWritable writable;

    public HiveCharTransformerAdapter(HiveCharObjectInspector columnType, AbstractTransformer transformer) {
        this(columnType, transformer, new HiveCharWritable());
    }

    public HiveCharTransformerAdapter(HiveCharObjectInspector columnType, AbstractTransformer transformer, HiveCharWritable writable) {
        super(transformer);
        this.columnType = columnType;
        this.writable = writable;
    }

    @Override
    public Object getTransformedWritable(GenericUDF.DeferredObject object) throws HiveException {
        String transformedValue;
        HiveChar value = this.columnType.getPrimitiveJavaObject(object.get());
        if (value != null && (transformedValue = this.transformer.transform(value.getValue())) != null) {
            this.writable.set(transformedValue);
            return this.writable;
        }
        return null;
    }
}

