/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.Clipper;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.OperatorInternalRelationUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.PointInPolygonHelper;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.RasterizedGeometry2D;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentBuffer;
import com.esri.core.geometry.SimpleGeometryCursor;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.TopologicalOperations;
import com.esri.core.geometry.VertexDescription;

class OperatorIntersectionCursor
extends GeometryCursor {
    GeometryCursor m_inputGeoms;
    GeometryCursor m_smallCursor;
    ProgressTracker m_progress_tracker;
    SpatialReference m_spatial_reference;
    Geometry m_geomIntersector;
    Geometry m_geomIntersectorEmptyGeom;
    int m_geomIntersectorType;
    int m_currentGeomType;
    int m_index;
    int m_dimensionMask;
    boolean m_bEmpty;

    OperatorIntersectionCursor(GeometryCursor inputGeoms, GeometryCursor geomIntersector, SpatialReference sr, ProgressTracker progress_tracker, int dimensionMask) {
        this.m_bEmpty = geomIntersector == null;
        this.m_index = -1;
        this.m_inputGeoms = inputGeoms;
        this.m_spatial_reference = sr;
        this.m_geomIntersector = geomIntersector.next();
        this.m_geomIntersectorType = this.m_geomIntersector.getType().value();
        this.m_currentGeomType = Geometry.Type.Unknown.value();
        this.m_progress_tracker = progress_tracker;
        this.m_dimensionMask = dimensionMask;
        if (this.m_dimensionMask != -1 && (this.m_dimensionMask <= 0 || this.m_dimensionMask > 7)) {
            throw new IllegalArgumentException("bad dimension mask");
        }
    }

    @Override
    public Geometry next() {
        Geometry geom;
        if (this.m_bEmpty) {
            return null;
        }
        if (this.m_smallCursor != null) {
            geom = this.m_smallCursor.next();
            if (geom != null) {
                return geom;
            }
            this.m_smallCursor = null;
        }
        if ((geom = this.m_inputGeoms.next()) != null) {
            this.m_index = this.m_inputGeoms.getGeometryID();
            if (this.m_dimensionMask == -1) {
                Geometry resGeom = this.intersect(geom);
                assert (resGeom != null);
                return resGeom;
            }
            this.m_smallCursor = this.intersectEx(geom);
            Geometry resGeom = this.m_smallCursor.next();
            assert (resGeom != null);
            return resGeom;
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    Geometry intersect(Geometry input_geom) {
        Geometry dst_geom = this.tryNativeImplementation_(input_geom);
        if (dst_geom != null) {
            return dst_geom;
        }
        Envelope2D commonExtent = InternalUtils.getMergedExtent(this.m_geomIntersector, input_geom);
        double t = InternalUtils.calculateToleranceFromGeometry(this.m_spatial_reference, commonExtent, true);
        Envelope2D env = new Envelope2D();
        this.m_geomIntersector.queryEnvelope2D(env);
        Envelope2D env1 = new Envelope2D();
        input_geom.queryEnvelope2D(env1);
        env.inflate(2.0 * t, 2.0 * t);
        env.intersect(env1);
        assert (!env.isEmpty());
        env.inflate(100.0 * t, 100.0 * t);
        double tol = 0.0;
        Geometry clippedIntersector = Clipper.clip(this.m_geomIntersector, env, tol, 0.0);
        Geometry clippedInputGeom = Clipper.clip(input_geom, env, tol, 0.0);
        return TopologicalOperations.intersection(clippedInputGeom, clippedIntersector, this.m_spatial_reference, this.m_progress_tracker);
    }

    GeometryCursor prepareVector_(VertexDescription descr, int dimensionMask, Geometry[] res_vec) {
        int i;
        int inext = 0;
        if ((dimensionMask & 1) != 0) {
            if (res_vec[0] == null) {
                res_vec[0] = new MultiPoint(descr);
            }
            ++inext;
        } else {
            i = 0;
            while (i < res_vec.length - 1) {
                res_vec[i] = res_vec[i + 1];
                ++i;
            }
        }
        if ((dimensionMask & 2) != 0) {
            if (res_vec[inext] == null) {
                res_vec[inext] = new Polyline(descr);
            }
            ++inext;
        } else {
            i = inext;
            while (i < res_vec.length - 1) {
                res_vec[i] = res_vec[i + 1];
                ++i;
            }
        }
        if ((dimensionMask & 4) != 0) {
            if (res_vec[inext] == null) {
                res_vec[inext] = new Polygon(descr);
            }
            ++inext;
        } else {
            i = inext;
            while (i < res_vec.length - 1) {
                res_vec[i] = res_vec[i + 1];
                ++i;
            }
        }
        if (inext != 3) {
            Geometry[] r = new Geometry[inext];
            int i2 = 0;
            while (i2 < inext) {
                r[i2] = res_vec[i2];
                ++i2;
            }
            return new SimpleGeometryCursor(r);
        }
        return new SimpleGeometryCursor(res_vec);
    }

    GeometryCursor intersectEx(Geometry input_geom) {
        assert (this.m_dimensionMask != -1);
        Geometry dst_geom = this.tryNativeImplementation_(input_geom);
        if (dst_geom != null) {
            Geometry[] res_vec = new Geometry[3];
            res_vec[dst_geom.getDimension()] = dst_geom;
            return this.prepareVector_(input_geom.getDescription(), this.m_dimensionMask, res_vec);
        }
        Envelope2D commonExtent = InternalUtils.getMergedExtent(this.m_geomIntersector, input_geom);
        double t = InternalUtils.calculateToleranceFromGeometry(this.m_spatial_reference, commonExtent, true);
        Envelope2D env = new Envelope2D();
        this.m_geomIntersector.queryEnvelope2D(env);
        env.inflate(2.0 * t, 2.0 * t);
        Envelope2D env1 = new Envelope2D();
        input_geom.queryEnvelope2D(env1);
        env.intersect(env1);
        assert (!env.isEmpty());
        env.inflate(100.0 * t, 100.0 * t);
        double tol = 0.0;
        Geometry clippedIntersector = Clipper.clip(this.m_geomIntersector, env, tol, 0.0);
        Geometry clippedInputGeom = Clipper.clip(input_geom, env, tol, 0.0);
        Geometry[] res_vec = TopologicalOperations.intersectionEx(clippedInputGeom, clippedIntersector, this.m_spatial_reference, this.m_progress_tracker);
        return this.prepareVector_(input_geom.getDescription(), this.m_dimensionMask, res_vec);
    }

    Geometry tryNativeImplementation_(Geometry input_geom) {
        boolean bResultIsEmpty;
        Envelope2D mergedExtent = InternalUtils.getMergedExtent(input_geom, this.m_geomIntersector);
        double tolerance = InternalUtils.calculateToleranceFromGeometry(this.m_spatial_reference, mergedExtent, false);
        int gtInput = input_geom.getType().value();
        boolean bInputEmpty = input_geom.isEmpty();
        boolean bGeomIntersectorEmpty = this.m_geomIntersector.isEmpty();
        boolean bl = bResultIsEmpty = bInputEmpty || bGeomIntersectorEmpty;
        if (!bResultIsEmpty) {
            Envelope2D env2D1 = new Envelope2D();
            input_geom.queryEnvelope2D(env2D1);
            Envelope2D env2D2 = new Envelope2D();
            this.m_geomIntersector.queryEnvelope2D(env2D2);
            env2D2.inflate(2.0 * tolerance, 2.0 * tolerance);
            boolean bl2 = bResultIsEmpty = !env2D1.isIntersecting(env2D2);
        }
        if (!bResultIsEmpty) {
            int res = OperatorInternalRelationUtils.quickTest2D_Accelerated_DisjointOrContains(this.m_geomIntersector, input_geom, tolerance);
            if (res == 4) {
                bResultIsEmpty = true;
            } else {
                if ((res & 2) != 0) {
                    return this.m_geomIntersector;
                }
                if ((res & 1) != 0) {
                    return input_geom;
                }
            }
        }
        if (bResultIsEmpty) {
            int dim2;
            int dim1 = Geometry.getDimensionFromType(gtInput);
            if (dim1 < (dim2 = Geometry.getDimensionFromType(this.m_geomIntersectorType))) {
                return OperatorIntersectionCursor.returnEmpty_(input_geom, bInputEmpty);
            }
            if (dim1 > dim2) {
                return this.returnEmptyIntersector_();
            }
            if (dim1 == 0) {
                if (gtInput == 550 && this.m_geomIntersectorType == 33) {
                    return this.returnEmptyIntersector_();
                }
                return OperatorIntersectionCursor.returnEmpty_(input_geom, bInputEmpty);
            }
            return OperatorIntersectionCursor.returnEmpty_(input_geom, bInputEmpty);
        }
        if ((this.m_dimensionMask == -1 || this.m_dimensionMask == 4) && gtInput == 197 && this.m_geomIntersectorType == 197) {
            Envelope env1 = (Envelope)input_geom;
            Envelope env2 = (Envelope)this.m_geomIntersector;
            Envelope2D env2D_1 = new Envelope2D();
            env1.queryEnvelope2D(env2D_1);
            Envelope2D env2D_2 = new Envelope2D();
            env2.queryEnvelope2D(env2D_2);
            env2D_1.intersect(env2D_2);
            Envelope result_env = new Envelope();
            env1.copyTo(result_env);
            result_env.setEnvelope2D(env2D_1);
            return result_env;
        }
        if (gtInput == 197 && Geometry.getDimensionFromType(this.m_geomIntersectorType) == 0 || this.m_geomIntersectorType == 197 && Geometry.getDimensionFromType(gtInput) == 0) {
            Envelope env = gtInput == 197 ? (Envelope)input_geom : (Envelope)this.m_geomIntersector;
            Geometry other = gtInput == 197 ? this.m_geomIntersector : input_geom;
            Envelope2D env_2D = new Envelope2D();
            env.queryEnvelope2D(env_2D);
            return Clipper.clip(other, env_2D, tolerance, 0.0);
        }
        if (Geometry.getDimensionFromType(gtInput) == 0 && Geometry.getDimensionFromType(this.m_geomIntersectorType) > 0 || Geometry.getDimensionFromType(gtInput) > 0 && Geometry.getDimensionFromType(this.m_geomIntersectorType) == 0) {
            double tolerance1 = InternalUtils.calculateToleranceFromGeometry(this.m_spatial_reference, input_geom, false);
            if (gtInput == 550) {
                return TopologicalOperations.intersection((MultiPoint)input_geom, this.m_geomIntersector, tolerance1);
            }
            if (gtInput == 33) {
                return TopologicalOperations.intersection((Point)input_geom, this.m_geomIntersector, tolerance1);
            }
            if (this.m_geomIntersectorType == 550) {
                return TopologicalOperations.intersection((MultiPoint)this.m_geomIntersector, input_geom, tolerance1);
            }
            if (this.m_geomIntersectorType == 33) {
                return TopologicalOperations.intersection((Point)this.m_geomIntersector, input_geom, tolerance1);
            }
            throw GeometryException.GeometryInternalError();
        }
        if ((this.m_dimensionMask == -1 || this.m_dimensionMask == 2) && gtInput == 1607 && this.m_geomIntersectorType == 1736) {
            return this.tryFastIntersectPolylinePolygon_((Polyline)input_geom, (Polygon)this.m_geomIntersector);
        }
        if ((this.m_dimensionMask == -1 || this.m_dimensionMask == 2) && gtInput == 1736 && this.m_geomIntersectorType == 1607) {
            return this.tryFastIntersectPolylinePolygon_((Polyline)this.m_geomIntersector, (Polygon)input_geom);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    Geometry tryFastIntersectPolylinePolygon_(Polyline polyline, Polygon polygon) {
        block60: {
            polylineImpl = (MultiPathImpl)polyline._getImpl();
            polygonImpl = (MultiPathImpl)polygon._getImpl();
            tolerance = InternalUtils.calculateToleranceFromGeometry(this.m_spatial_reference, polygon, false);
            clipEnvelope = new Envelope2D();
            polygonImpl.queryEnvelope2D(clipEnvelope);
            env1 = new Envelope2D();
            polylineImpl.queryEnvelope2D(env1);
            env1.inflate(2.0 * tolerance, 2.0 * tolerance);
            clipEnvelope.intersect(env1);
            if (!OperatorIntersectionCursor.$assertionsDisabled && clipEnvelope.isEmpty()) {
                throw new AssertionError();
            }
            clipEnvelope.inflate(10.0 * tolerance, 10.0 * tolerance);
            tol = 0.0;
            clippedPolyline = Clipper.clip(polyline, clipEnvelope, tol, 0.0);
            polyline = (Polyline)clippedPolyline;
            polylineImpl = (MultiPathImpl)polyline._getImpl();
            clipResult = new AttributeStreamOfInt32(0);
            unresolvedSegments = -1;
            accel = polygonImpl._getAccelerators();
            if (accel == null || (rgeom = accel.getRasterizedGeometry()) == null) break block60;
            unresolvedSegments = 0;
            clipResult.reserve(polylineImpl.getPointCount() + polylineImpl.getPathCount());
            seg_env = new Envelope2D();
            iter = polylineImpl.querySegmentIterator();
            ** GOTO lbl40
            {
                seg = iter.nextSegment();
                seg.queryEnvelope2D(seg_env);
                hit = rgeom.queryEnvelopeInGeometry(seg_env);
                if (hit == RasterizedGeometry2D.HitType.Inside) {
                    clipResult.add(1);
                } else if (hit == RasterizedGeometry2D.HitType.Outside) {
                    clipResult.add(0);
                } else {
                    clipResult.add(-1);
                    ++unresolvedSegments;
                }
                do {
                    if (iter.hasNextSegment()) continue block4;
lbl40:
                    // 2 sources

                } while (iter.nextPath());
            }
        }
        if (polygon.getPointCount() > 5) {
            tol = 0.0;
            clippedPolygon = Clipper.clip(polygon, clipEnvelope, tol, 0.0);
            polygon = (Polygon)clippedPolygon;
            polygonImpl = (MultiPathImpl)polygon._getImpl();
            accel = polygonImpl._getAccelerators();
        }
        if (unresolvedSegments < 0) {
            unresolvedSegments = polylineImpl.getSegmentCount();
        }
        totalPoints = polylineImpl.getPointCount() + polygonImpl.getPointCount();
        thisAlgorithmComplexity = (double)unresolvedSegments * (double)polygonImpl.getPointCount();
        if (thisAlgorithmComplexity > (planesweepComplexity = Math.log(totalPoints) * totalPoints) * (empiricConstantFactorPlaneSweep = 4.0)) {
            return null;
        }
        polygonQuadTree = null;
        polygonIter = polygonImpl.querySegmentIterator();
        if (accel != null && accel.getQuadTree() != null) {
            polygonQuadTree = accel.getQuadTree();
        }
        if (polygonQuadTree == null && polygonImpl.getPointCount() > 20) {
            polygonQuadTree = InternalUtils.buildQuadTree(polygonImpl);
        }
        result_polyline = (Polyline)polyline.createInstance();
        resultPolylineImpl = (MultiPathImpl)result_polyline._getImpl();
        qIter = null;
        polylineIter = polylineImpl.querySegmentIterator();
        params = new double[9];
        intersections = new AttributeStreamOfDbl(0);
        segmentBuffer = new SegmentBuffer();
        start_index = -1;
        inCount = 0;
        segIndex = 0;
        bOptimized = clipResult.size() > 0;
        polylinePathIndex = -1;
        while (polylineIter.nextPath()) {
            polylinePathIndex = polylineIter.getPathIndex();
            stateNewPath = 0;
            stateAddSegment = 1;
            stateManySegments = 2;
            stateManySegmentsContinuePath = 2;
            stateManySegmentsNewPath = 3;
            state = stateNewPath;
            start_index = -1;
            inCount = 0;
            while (polylineIter.hasNextSegment()) {
                block61: {
                    block63: {
                        block62: {
                            clipStatus = bOptimized != false ? clipResult.get(segIndex) : -1;
                            ++segIndex;
                            polylineSeg = polylineIter.nextSegment();
                            if (clipStatus >= 0) break block61;
                            if (!OperatorIntersectionCursor.$assertionsDisabled && clipStatus != -1) {
                                throw new AssertionError();
                            }
                            if (polygonQuadTree == null) break block62;
                            if (qIter == null) {
                                qIter = polygonQuadTree.getIterator(polylineSeg, tolerance);
                            } else {
                                qIter.resetIterator(polylineSeg, tolerance);
                            }
                            path_index = -1;
                            ind = qIter.next();
                            while (ind != -1) {
                                polygonIter.resetToVertex(polygonQuadTree.getElement(ind));
                                path_index = polygonIter.getPathIndex();
                                polygonSeg = polygonIter.nextSegment();
                                count = polylineSeg.intersect(polygonSeg, null, params, null, tolerance);
                                i = 0;
                                while (i < count) {
                                    intersections.add(params[i]);
                                    ++i;
                                }
                                ind = qIter.next();
                            }
                            break block63;
                        }
                        polygonIter.resetToFirstPath();
                        ** GOTO lbl121
                        {
                            polygonSeg = polygonIter.nextSegment();
                            count = polylineSeg.intersect(polygonSeg, null, params, null, tolerance);
                            i = 0;
                            while (i < count) {
                                intersections.add(params[i]);
                                ++i;
                            }
                            do {
                                if (polygonIter.hasNextSegment()) continue block10;
lbl121:
                                // 2 sources

                            } while (polygonIter.nextPath());
                        }
                    }
                    if (intersections.size() > 0) {
                        intersections.sort(0, intersections.size());
                        t0 = 0.0;
                        intersections.add(1.0);
                        status = -1;
                        i = 0;
                        n = intersections.size();
                        while (i < n) {
                            t = intersections.get(i);
                            if (t != t0) {
                                bWholeSegment = false;
                                if (t0 != 0.0 || t != 1.0) {
                                    polylineSeg.cut(t0, t, segmentBuffer);
                                    resSeg = segmentBuffer.get();
                                } else {
                                    resSeg = polylineSeg;
                                    bWholeSegment = true;
                                }
                                if (state >= stateManySegments) {
                                    resultPolylineImpl.addSegmentsFromPath(polylineImpl, polylinePathIndex, start_index, inCount, state == stateManySegmentsNewPath);
                                    if (this.analyseClipSegment_(polygon, resSeg.getStartXY(), tolerance) != 1 && this.analyseClipSegment_(polygon, resSeg, tolerance) != 1) {
                                        return null;
                                    }
                                    resultPolylineImpl.addSegment(resSeg, false);
                                    state = stateAddSegment;
                                    inCount = 0;
                                } else {
                                    status = this.analyseClipSegment_(polygon, resSeg, tolerance);
                                    switch (status) {
                                        case 1: {
                                            if (!bWholeSegment) {
                                                resultPolylineImpl.addSegment(resSeg, state == stateNewPath);
                                                state = stateAddSegment;
                                                break;
                                            }
                                            if (state < stateManySegments) {
                                                start_index = polylineIter.getStartPointIndex() - polylineImpl.getPathStart(polylinePathIndex);
                                                inCount = 1;
                                                if (state == stateNewPath) {
                                                    state = stateManySegmentsNewPath;
                                                    break;
                                                }
                                                if (!OperatorIntersectionCursor.$assertionsDisabled && state != stateAddSegment) {
                                                    throw new AssertionError();
                                                }
                                                state = stateManySegmentsContinuePath;
                                                break;
                                            }
                                            ++inCount;
                                            break;
                                        }
                                        case 0: {
                                            state = stateNewPath;
                                            start_index = -1;
                                            inCount = 0;
                                            break;
                                        }
                                        default: {
                                            return null;
                                        }
                                    }
                                }
                                t0 = t;
                            }
                            ++i;
                        }
                    } else {
                        clipStatus = this.analyseClipSegment_(polygon, polylineSeg.getStartXY(), tolerance);
                        if (clipStatus < 0) {
                            if (!OperatorIntersectionCursor.$assertionsDisabled && clipStatus < 0) {
                                throw new AssertionError();
                            }
                            return null;
                        }
                        if (!OperatorIntersectionCursor.$assertionsDisabled && this.analyseClipSegment_(polygon, polylineSeg.getEndXY(), tolerance) != clipStatus) {
                            throw new AssertionError();
                        }
                        if (clipStatus == 1) {
                            if (state < stateManySegments) {
                                if (!OperatorIntersectionCursor.$assertionsDisabled && inCount != 0) {
                                    throw new AssertionError();
                                }
                                start_index = polylineIter.getStartPointIndex() - polylineImpl.getPathStart(polylinePathIndex);
                                if (state == stateNewPath) {
                                    state = stateManySegmentsNewPath;
                                } else {
                                    if (!OperatorIntersectionCursor.$assertionsDisabled && state != stateAddSegment) {
                                        throw new AssertionError();
                                    }
                                    state = stateManySegmentsContinuePath;
                                }
                            }
                            ++inCount;
                        } else {
                            if (!OperatorIntersectionCursor.$assertionsDisabled && state >= stateManySegments) {
                                throw new AssertionError();
                            }
                            start_index = -1;
                            inCount = 0;
                        }
                    }
                    intersections.clear(false);
                    continue;
                }
                if (clipStatus == 0) {
                    if (!OperatorIntersectionCursor.$assertionsDisabled && this.analyseClipSegment_(polygon, polylineSeg, tolerance) != 0) {
                        throw new AssertionError();
                    }
                    if (!OperatorIntersectionCursor.$assertionsDisabled && start_index >= 0) {
                        throw new AssertionError();
                    }
                    if (!OperatorIntersectionCursor.$assertionsDisabled && inCount != 0) {
                        throw new AssertionError();
                    }
                    continue;
                }
                if (clipStatus != 1) continue;
                if (!OperatorIntersectionCursor.$assertionsDisabled && this.analyseClipSegment_(polygon, polylineSeg, tolerance) != 1) {
                    throw new AssertionError();
                }
                if (state == stateNewPath) {
                    state = stateManySegmentsNewPath;
                    start_index = polylineIter.getStartPointIndex() - polylineImpl.getPathStart(polylinePathIndex);
                } else if (state == stateAddSegment) {
                    state = stateManySegmentsContinuePath;
                    start_index = polylineIter.getStartPointIndex() - polylineImpl.getPathStart(polylinePathIndex);
                } else if (!OperatorIntersectionCursor.$assertionsDisabled && state < stateManySegments) {
                    throw new AssertionError();
                }
                ++inCount;
            }
            if (state < stateManySegments) continue;
            resultPolylineImpl.addSegmentsFromPath(polylineImpl, polylinePathIndex, start_index, inCount, state == stateManySegmentsNewPath);
            start_index = -1;
        }
        return result_polyline;
    }

    int analyseClipSegment_(Polygon polygon, Point2D pt, double tol) {
        int v = PointInPolygonHelper.isPointInPolygon(polygon, pt, tol);
        return v;
    }

    int analyseClipSegment_(Polygon polygon, Segment seg, double tol) {
        Point2D pt_1 = seg.getStartXY();
        Point2D pt_2 = seg.getEndXY();
        int v_1 = PointInPolygonHelper.isPointInPolygon(polygon, pt_1, tol);
        int v_2 = PointInPolygonHelper.isPointInPolygon(polygon, pt_2, tol);
        if (v_1 == 1 && v_2 == 0 || v_1 == 0 && v_2 == 1) {
            assert (false);
            return -1;
        }
        if (v_1 == 0 || v_2 == 0) {
            return 0;
        }
        if (v_1 == 1 || v_2 == 1) {
            return 1;
        }
        Point2D midPt = new Point2D();
        midPt.add(pt_1, pt_2);
        midPt.scale(0.5);
        int v = PointInPolygonHelper.isPointInPolygon(polygon, midPt, tol);
        if (v == 0) {
            return 0;
        }
        if (v == 1) {
            return 1;
        }
        return -1;
    }

    Geometry normalizeIntersectionOutput(Geometry geom, int GT_1, int GT_2) {
        if (GT_1 == 33 || GT_2 == 33) assert (geom.getType().value() == 33);
        if (GT_1 == 550 && geom.getType().value() == 33) {
            MultiPoint mp = new MultiPoint(geom.getDescription());
            if (!geom.isEmpty()) {
                mp.add((Point)geom);
            }
            return mp;
        }
        return geom;
    }

    static Geometry returnEmpty_(Geometry geom, boolean bEmpty) {
        return bEmpty ? geom : geom.createInstance();
    }

    Geometry returnEmptyIntersector_() {
        if (this.m_geomIntersectorEmptyGeom == null) {
            this.m_geomIntersectorEmptyGeom = this.m_geomIntersector.createInstance();
        }
        return this.m_geomIntersectorEmptyGeom;
    }
}

