/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.impl.LlapManagementProtocolClientImpl;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorInfo;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.llap.registry.impl.LlapZookeeperRegistryImpl;
import org.apache.hadoop.hive.llap.tezplugins.metrics.LlapManagementProtocolClientImplFactory;
import org.apache.hadoop.hive.llap.tezplugins.metrics.LlapMetricsCollector;
import org.apache.hadoop.hive.llap.tezplugins.metrics.LlapMetricsListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlacklistingLlapMetricsListener
implements LlapMetricsListener {
    private static final Logger LOG = LoggerFactory.getLogger(BlacklistingLlapMetricsListener.class);
    private LlapRegistryService registry;
    private LlapManagementProtocolClientImplFactory clientFactory;
    private int minServedTasksNumber;
    private int maxBlacklistedNodes;
    private long minConfigChangeDelayMs;
    private float timeThreshold;
    private float emptyExecutorsThreshold;
    @VisibleForTesting
    long nextCheckTime = Long.MIN_VALUE;

    @VisibleForTesting
    void init(Configuration conf, LlapRegistryService registry, LlapManagementProtocolClientImplFactory clientFactory) {
        this.registry = registry;
        this.clientFactory = clientFactory;
        this.minServedTasksNumber = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_NODEHEALTHCHECKS_MINTASKS);
        this.minConfigChangeDelayMs = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_NODEHEALTHCHECKS_MININTERVALDURATION, (TimeUnit)TimeUnit.MILLISECONDS);
        this.timeThreshold = HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_NODEHEALTHCHECKS_TASKTIMERATIO);
        this.emptyExecutorsThreshold = HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_NODEHEALTHCHECKS_EXECUTORRATIO);
        this.maxBlacklistedNodes = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_NODEHEALTHCHECKS_MAXNODES);
        Preconditions.checkArgument((this.minServedTasksNumber > 0 ? 1 : 0) != 0, (Object)"Minimum served tasks should be greater than 0");
        Preconditions.checkArgument((this.minConfigChangeDelayMs > 0L ? 1 : 0) != 0, (Object)"Minimum config change delay should be greater than 0");
        Preconditions.checkArgument((this.timeThreshold > 1.0f ? 1 : 0) != 0, (Object)"The time threshold should be greater than 1");
        Preconditions.checkArgument((this.maxBlacklistedNodes > 0 ? 1 : 0) != 0, (Object)"The maximum number of blacklisted node should be greater than 1");
        Preconditions.checkNotNull((Object)registry, (Object)"Registry should not be null");
        Preconditions.checkNotNull((Object)clientFactory, (Object)"ClientFactory should not be null");
        LOG.info("BlacklistingLlapMetricsListener initialized with minServedTasksNumber={}, minConfigChangeDelayMs={}, timeThreshold={}, emptyExecutorsThreshold={}, maxBlacklistedNodes={}", new Object[]{this.minServedTasksNumber, this.minConfigChangeDelayMs, Float.valueOf(this.timeThreshold), Float.valueOf(this.emptyExecutorsThreshold), this.maxBlacklistedNodes});
    }

    @Override
    public void init(Configuration conf, LlapRegistryService registry) {
        this.init(conf, registry, LlapManagementProtocolClientImplFactory.basicInstance(conf));
    }

    @Override
    public void newDaemonMetrics(String workerIdentity, LlapMetricsCollector.LlapMetrics newMetrics) {
    }

    @Override
    public void newClusterMetrics(Map<String, LlapMetricsCollector.LlapMetrics> newMetrics) {
        long emptyExecutorsWithoutSlowest;
        long sumAverageTime = 0L;
        long sumEmptyExecutors = 0L;
        long maxAverageTime = 0L;
        long maxAverageTimeEmptyExecutors = 0L;
        long maxAverageTimeMaxExecutors = 0L;
        long workerNum = 0L;
        int blacklistedNodes = 0;
        String maxAverageTimeIdentity = null;
        for (String workerIdentity : newMetrics.keySet()) {
            Map<String, Long> metrics = newMetrics.get(workerIdentity).getMetrics();
            long requestHandled = metrics.get(LlapDaemonExecutorInfo.ExecutorTotalRequestsHandled.name());
            long averageTime = metrics.get(LlapDaemonExecutorInfo.AverageResponseTime.name());
            long emptyExecutor = metrics.get(LlapDaemonExecutorInfo.ExecutorNumExecutorsAvailableAverage.name());
            long maxExecutors = metrics.get(LlapDaemonExecutorInfo.ExecutorNumExecutors.name());
            LOG.debug("Checking node {} with data: requestHandled={}, averageTime={}, emptyExecutors={}, maxExecutors={}", new Object[]{workerIdentity, requestHandled, averageTime, emptyExecutor, maxExecutors});
            if (maxExecutors == 0L) {
                if (++blacklistedNodes < this.maxBlacklistedNodes) continue;
                LOG.info("Already enough blacklisted nodes {}. Skipping.", (Object)blacklistedNodes);
                return;
            }
            if (requestHandled <= (long)this.minServedTasksNumber) continue;
            ++workerNum;
            sumAverageTime += averageTime;
            if (averageTime > maxAverageTime) {
                maxAverageTime = averageTime;
                maxAverageTimeEmptyExecutors = emptyExecutor;
                maxAverageTimeMaxExecutors = maxExecutors;
                maxAverageTimeIdentity = workerIdentity;
            }
            sumEmptyExecutors += emptyExecutor;
        }
        if (workerNum < 2L) {
            return;
        }
        LOG.debug("Found slowest node {} with data: sumAverageTime={}, sumEmptyExecutors={}, maxAverageTime={}, maxAverageTimeEmptyExecutors={}, maxAverageTimeMaxExecutors={}, workerNum={}, maxAverageTimeIdentity={}, blacklistedNodes={}", new Object[]{sumAverageTime, sumEmptyExecutors, maxAverageTime, maxAverageTimeEmptyExecutors, maxAverageTimeMaxExecutors, workerNum, maxAverageTimeIdentity, blacklistedNodes});
        double averageTimeWithoutSlowest = (double)(sumAverageTime - maxAverageTime) / (double)(workerNum - 1L);
        if (averageTimeWithoutSlowest * (double)this.timeThreshold < (double)maxAverageTime && (float)(emptyExecutorsWithoutSlowest = sumEmptyExecutors - maxAverageTimeEmptyExecutors) > (float)maxAverageTimeMaxExecutors * this.emptyExecutorsThreshold) {
            try {
                LOG.debug("Trying to blacklist node: " + maxAverageTimeIdentity);
                this.setCapacity(maxAverageTimeIdentity, 0, 0);
            }
            catch (Throwable t) {
                LOG.debug("Can not blacklist node: " + maxAverageTimeIdentity, t);
            }
        }
    }

    protected void setCapacity(String workerIdentity, int newExecutorNum, int newWaitQueueSize) throws IOException, ServiceException {
        long currentTime = System.currentTimeMillis();
        if (currentTime > this.nextCheckTime) {
            LlapZookeeperRegistryImpl.ConfigChangeLockResult lockResult = this.registry.lockForConfigChange(currentTime, currentTime + this.minConfigChangeDelayMs);
            LOG.debug("Got result for lock check: {}", (Object)lockResult);
            if (lockResult.isSuccess()) {
                LOG.info("Setting capacity for workerIdentity={} to newExecutorNum={}, newWaitQueueSize={}", new Object[]{workerIdentity, newExecutorNum, newWaitQueueSize});
                LlapServiceInstance serviceInstance = (LlapServiceInstance)this.registry.getInstances().getInstance(workerIdentity);
                LlapManagementProtocolClientImpl client = this.clientFactory.create(serviceInstance);
                client.setCapacity(null, LlapDaemonProtocolProtos.SetCapacityRequestProto.newBuilder().setExecutorNum(newExecutorNum).setQueueSize(newWaitQueueSize).build());
            }
            if (lockResult.getNextConfigChangeTime() > -1L) {
                this.nextCheckTime = lockResult.getNextConfigChangeTime();
            }
        } else {
            LOG.debug("Skipping check. Current time {} and we are waiting for {}.", (Object)currentTime, (Object)this.nextCheckTime);
        }
    }
}

