/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class AppendPartitionsRequest
implements TBase<AppendPartitionsRequest, _Fields>,
Serializable,
Cloneable,
Comparable<AppendPartitionsRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("AppendPartitionsRequest");
    private static final TField CATALOG_NAME_FIELD_DESC = new TField("catalogName", 11, 1);
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 2);
    private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 3);
    private static final TField NAME_FIELD_DESC = new TField("name", 11, 4);
    private static final TField PART_VALS_FIELD_DESC = new TField("partVals", 15, 5);
    private static final TField ENVIRONMENT_CONTEXT_FIELD_DESC = new TField("environmentContext", 12, 6);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new AppendPartitionsRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new AppendPartitionsRequestTupleSchemeFactory();
    @Nullable
    private String catalogName;
    @Nullable
    private String dbName;
    @Nullable
    private String tableName;
    @Nullable
    private String name;
    @Nullable
    private List<String> partVals;
    @Nullable
    private EnvironmentContext environmentContext;
    private static final _Fields[] optionals = new _Fields[]{_Fields.CATALOG_NAME, _Fields.NAME, _Fields.PART_VALS, _Fields.ENVIRONMENT_CONTEXT};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public AppendPartitionsRequest() {
    }

    public AppendPartitionsRequest(String dbName, String tableName) {
        this();
        this.dbName = dbName;
        this.tableName = tableName;
    }

    public AppendPartitionsRequest(AppendPartitionsRequest other) {
        if (other.isSetCatalogName()) {
            this.catalogName = other.catalogName;
        }
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetTableName()) {
            this.tableName = other.tableName;
        }
        if (other.isSetName()) {
            this.name = other.name;
        }
        if (other.isSetPartVals()) {
            ArrayList<String> __this__partVals = new ArrayList<String>(other.partVals);
            this.partVals = __this__partVals;
        }
        if (other.isSetEnvironmentContext()) {
            this.environmentContext = new EnvironmentContext(other.environmentContext);
        }
    }

    public AppendPartitionsRequest deepCopy() {
        return new AppendPartitionsRequest(this);
    }

    public void clear() {
        this.catalogName = null;
        this.dbName = null;
        this.tableName = null;
        this.name = null;
        this.partVals = null;
        this.environmentContext = null;
    }

    @Nullable
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(@Nullable String catalogName) {
        this.catalogName = catalogName;
    }

    public void unsetCatalogName() {
        this.catalogName = null;
    }

    public boolean isSetCatalogName() {
        return this.catalogName != null;
    }

    public void setCatalogNameIsSet(boolean value) {
        if (!value) {
            this.catalogName = null;
        }
    }

    @Nullable
    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(@Nullable String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public void setDbNameIsSet(boolean value) {
        if (!value) {
            this.dbName = null;
        }
    }

    @Nullable
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(@Nullable String tableName) {
        this.tableName = tableName;
    }

    public void unsetTableName() {
        this.tableName = null;
    }

    public boolean isSetTableName() {
        return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
        if (!value) {
            this.tableName = null;
        }
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public void setNameIsSet(boolean value) {
        if (!value) {
            this.name = null;
        }
    }

    public int getPartValsSize() {
        return this.partVals == null ? 0 : this.partVals.size();
    }

    @Nullable
    public Iterator<String> getPartValsIterator() {
        return this.partVals == null ? null : this.partVals.iterator();
    }

    public void addToPartVals(String elem) {
        if (this.partVals == null) {
            this.partVals = new ArrayList<String>();
        }
        this.partVals.add(elem);
    }

    @Nullable
    public List<String> getPartVals() {
        return this.partVals;
    }

    public void setPartVals(@Nullable List<String> partVals) {
        this.partVals = partVals;
    }

    public void unsetPartVals() {
        this.partVals = null;
    }

    public boolean isSetPartVals() {
        return this.partVals != null;
    }

    public void setPartValsIsSet(boolean value) {
        if (!value) {
            this.partVals = null;
        }
    }

    @Nullable
    public EnvironmentContext getEnvironmentContext() {
        return this.environmentContext;
    }

    public void setEnvironmentContext(@Nullable EnvironmentContext environmentContext) {
        this.environmentContext = environmentContext;
    }

    public void unsetEnvironmentContext() {
        this.environmentContext = null;
    }

    public boolean isSetEnvironmentContext() {
        return this.environmentContext != null;
    }

    public void setEnvironmentContextIsSet(boolean value) {
        if (!value) {
            this.environmentContext = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field.ordinal()) {
            case 0: {
                if (value == null) {
                    this.unsetCatalogName();
                    break;
                }
                this.setCatalogName((String)value);
                break;
            }
            case 1: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetTableName();
                    break;
                }
                this.setTableName((String)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetName();
                    break;
                }
                this.setName((String)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetPartVals();
                    break;
                }
                this.setPartVals((List)value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetEnvironmentContext();
                    break;
                }
                this.setEnvironmentContext((EnvironmentContext)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field.ordinal()) {
            case 0: {
                return this.getCatalogName();
            }
            case 1: {
                return this.getDbName();
            }
            case 2: {
                return this.getTableName();
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                return this.getPartVals();
            }
            case 5: {
                return this.getEnvironmentContext();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field.ordinal()) {
            case 0: {
                return this.isSetCatalogName();
            }
            case 1: {
                return this.isSetDbName();
            }
            case 2: {
                return this.isSetTableName();
            }
            case 3: {
                return this.isSetName();
            }
            case 4: {
                return this.isSetPartVals();
            }
            case 5: {
                return this.isSetEnvironmentContext();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof AppendPartitionsRequest) {
            return this.equals((AppendPartitionsRequest)that);
        }
        return false;
    }

    public boolean equals(AppendPartitionsRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_catalogName = this.isSetCatalogName();
        boolean that_present_catalogName = that.isSetCatalogName();
        if (this_present_catalogName || that_present_catalogName) {
            if (!this_present_catalogName || !that_present_catalogName) {
                return false;
            }
            if (!this.catalogName.equals(that.catalogName)) {
                return false;
            }
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_tableName = this.isSetTableName();
        boolean that_present_tableName = that.isSetTableName();
        if (this_present_tableName || that_present_tableName) {
            if (!this_present_tableName || !that_present_tableName) {
                return false;
            }
            if (!this.tableName.equals(that.tableName)) {
                return false;
            }
        }
        boolean this_present_name = this.isSetName();
        boolean that_present_name = that.isSetName();
        if (this_present_name || that_present_name) {
            if (!this_present_name || !that_present_name) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
        }
        boolean this_present_partVals = this.isSetPartVals();
        boolean that_present_partVals = that.isSetPartVals();
        if (this_present_partVals || that_present_partVals) {
            if (!this_present_partVals || !that_present_partVals) {
                return false;
            }
            if (!this.partVals.equals(that.partVals)) {
                return false;
            }
        }
        boolean this_present_environmentContext = this.isSetEnvironmentContext();
        boolean that_present_environmentContext = that.isSetEnvironmentContext();
        if (this_present_environmentContext || that_present_environmentContext) {
            if (!this_present_environmentContext || !that_present_environmentContext) {
                return false;
            }
            if (!this.environmentContext.equals(that.environmentContext)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetCatalogName() ? 131071 : 524287);
        if (this.isSetCatalogName()) {
            hashCode = hashCode * 8191 + this.catalogName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDbName() ? 131071 : 524287);
        if (this.isSetDbName()) {
            hashCode = hashCode * 8191 + this.dbName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTableName() ? 131071 : 524287);
        if (this.isSetTableName()) {
            hashCode = hashCode * 8191 + this.tableName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetName() ? 131071 : 524287);
        if (this.isSetName()) {
            hashCode = hashCode * 8191 + this.name.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPartVals() ? 131071 : 524287);
        if (this.isSetPartVals()) {
            hashCode = hashCode * 8191 + this.partVals.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetEnvironmentContext() ? 131071 : 524287);
        if (this.isSetEnvironmentContext()) {
            hashCode = hashCode * 8191 + this.environmentContext.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(AppendPartitionsRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetCatalogName(), other.isSetCatalogName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCatalogName() && (lastComparison = TBaseHelper.compareTo((String)this.catalogName, (String)other.catalogName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDbName(), other.isSetDbName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbName() && (lastComparison = TBaseHelper.compareTo((String)this.dbName, (String)other.dbName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTableName(), other.isSetTableName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo((String)this.tableName, (String)other.tableName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetName(), other.isSetName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetName() && (lastComparison = TBaseHelper.compareTo((String)this.name, (String)other.name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPartVals(), other.isSetPartVals());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartVals() && (lastComparison = TBaseHelper.compareTo(this.partVals, other.partVals)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetEnvironmentContext(), other.isSetEnvironmentContext());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEnvironmentContext() && (lastComparison = TBaseHelper.compareTo((Comparable)this.environmentContext, (Comparable)other.environmentContext)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        AppendPartitionsRequest.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        AppendPartitionsRequest.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AppendPartitionsRequest(");
        boolean first = true;
        if (this.isSetCatalogName()) {
            sb.append("catalogName:");
            if (this.catalogName == null) {
                sb.append("null");
            } else {
                sb.append(this.catalogName);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tableName:");
        if (this.tableName == null) {
            sb.append("null");
        } else {
            sb.append(this.tableName);
        }
        first = false;
        if (this.isSetName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("name:");
            if (this.name == null) {
                sb.append("null");
            } else {
                sb.append(this.name);
            }
            first = false;
        }
        if (this.isSetPartVals()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("partVals:");
            if (this.partVals == null) {
                sb.append("null");
            } else {
                sb.append(this.partVals);
            }
            first = false;
        }
        if (this.isSetEnvironmentContext()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("environmentContext:");
            if (this.environmentContext == null) {
                sb.append("null");
            } else {
                sb.append(this.environmentContext);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetDbName()) {
            throw new TProtocolException("Required field 'dbName' is unset! Struct:" + this.toString());
        }
        if (!this.isSetTableName()) {
            throw new TProtocolException("Required field 'tableName' is unset! Struct:" + this.toString());
        }
        if (this.environmentContext != null) {
            this.environmentContext.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.CATALOG_NAME, new FieldMetaData("catalogName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DB_NAME, new FieldMetaData("dbName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.NAME, new FieldMetaData("name", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PART_VALS, new FieldMetaData("partVals", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.ENVIRONMENT_CONTEXT, new FieldMetaData("environmentContext", 2, (FieldValueMetaData)new StructMetaData(12, EnvironmentContext.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(AppendPartitionsRequest.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        CATALOG_NAME(1, "catalogName"),
        DB_NAME(2, "dbName"),
        TABLE_NAME(3, "tableName"),
        NAME(4, "name"),
        PART_VALS(5, "partVals"),
        ENVIRONMENT_CONTEXT(6, "environmentContext");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return CATALOG_NAME;
                }
                case 2: {
                    return DB_NAME;
                }
                case 3: {
                    return TABLE_NAME;
                }
                case 4: {
                    return NAME;
                }
                case 5: {
                    return PART_VALS;
                }
                case 6: {
                    return ENVIRONMENT_CONTEXT;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class AppendPartitionsRequestStandardSchemeFactory
    implements SchemeFactory {
        private AppendPartitionsRequestStandardSchemeFactory() {
        }

        public AppendPartitionsRequestStandardScheme getScheme() {
            return new AppendPartitionsRequestStandardScheme();
        }
    }

    private static class AppendPartitionsRequestTupleSchemeFactory
    implements SchemeFactory {
        private AppendPartitionsRequestTupleSchemeFactory() {
        }

        public AppendPartitionsRequestTupleScheme getScheme() {
            return new AppendPartitionsRequestTupleScheme();
        }
    }

    private static class AppendPartitionsRequestTupleScheme
    extends TupleScheme<AppendPartitionsRequest> {
        private AppendPartitionsRequestTupleScheme() {
        }

        public void write(TProtocol prot, AppendPartitionsRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.dbName);
            oprot.writeString(struct.tableName);
            BitSet optionals = new BitSet();
            if (struct.isSetCatalogName()) {
                optionals.set(0);
            }
            if (struct.isSetName()) {
                optionals.set(1);
            }
            if (struct.isSetPartVals()) {
                optionals.set(2);
            }
            if (struct.isSetEnvironmentContext()) {
                optionals.set(3);
            }
            oprot.writeBitSet(optionals, 4);
            if (struct.isSetCatalogName()) {
                oprot.writeString(struct.catalogName);
            }
            if (struct.isSetName()) {
                oprot.writeString(struct.name);
            }
            if (struct.isSetPartVals()) {
                oprot.writeI32(struct.partVals.size());
                for (String _iter1462 : struct.partVals) {
                    oprot.writeString(_iter1462);
                }
            }
            if (struct.isSetEnvironmentContext()) {
                struct.environmentContext.write((TProtocol)oprot);
            }
        }

        public void read(TProtocol prot, AppendPartitionsRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.dbName = iprot.readString();
            struct.setDbNameIsSet(true);
            struct.tableName = iprot.readString();
            struct.setTableNameIsSet(true);
            BitSet incoming = iprot.readBitSet(4);
            if (incoming.get(0)) {
                struct.catalogName = iprot.readString();
                struct.setCatalogNameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.name = iprot.readString();
                struct.setNameIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list1463 = iprot.readListBegin((byte)11);
                struct.partVals = new ArrayList<String>(_list1463.size);
                for (int _i1465 = 0; _i1465 < _list1463.size; ++_i1465) {
                    String _elem1464 = iprot.readString();
                    struct.partVals.add(_elem1464);
                }
                struct.setPartValsIsSet(true);
            }
            if (incoming.get(3)) {
                struct.environmentContext = new EnvironmentContext();
                struct.environmentContext.read((TProtocol)iprot);
                struct.setEnvironmentContextIsSet(true);
            }
        }
    }

    private static class AppendPartitionsRequestStandardScheme
    extends StandardScheme<AppendPartitionsRequest> {
        private AppendPartitionsRequestStandardScheme() {
        }

        public void read(TProtocol iprot, AppendPartitionsRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.catalogName = iprot.readString();
                            struct.setCatalogNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.dbName = iprot.readString();
                            struct.setDbNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.tableName = iprot.readString();
                            struct.setTableNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.name = iprot.readString();
                            struct.setNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list1458 = iprot.readListBegin();
                            struct.partVals = new ArrayList<String>(_list1458.size);
                            for (int _i1460 = 0; _i1460 < _list1458.size; ++_i1460) {
                                String _elem1459 = iprot.readString();
                                struct.partVals.add(_elem1459);
                            }
                            iprot.readListEnd();
                            struct.setPartValsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 12) {
                            struct.environmentContext = new EnvironmentContext();
                            struct.environmentContext.read(iprot);
                            struct.setEnvironmentContextIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, AppendPartitionsRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.catalogName != null && struct.isSetCatalogName()) {
                oprot.writeFieldBegin(CATALOG_NAME_FIELD_DESC);
                oprot.writeString(struct.catalogName);
                oprot.writeFieldEnd();
            }
            if (struct.dbName != null) {
                oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
                oprot.writeString(struct.dbName);
                oprot.writeFieldEnd();
            }
            if (struct.tableName != null) {
                oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
                oprot.writeString(struct.tableName);
                oprot.writeFieldEnd();
            }
            if (struct.name != null && struct.isSetName()) {
                oprot.writeFieldBegin(NAME_FIELD_DESC);
                oprot.writeString(struct.name);
                oprot.writeFieldEnd();
            }
            if (struct.partVals != null && struct.isSetPartVals()) {
                oprot.writeFieldBegin(PART_VALS_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.partVals.size()));
                for (String _iter1461 : struct.partVals) {
                    oprot.writeString(_iter1461);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.environmentContext != null && struct.isSetEnvironmentContext()) {
                oprot.writeFieldBegin(ENVIRONMENT_CONTEXT_FIELD_DESC);
                struct.environmentContext.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

