/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.hadoop.hive.metastore.properties.Digester;
import org.apache.hadoop.hive.metastore.properties.PropertyType;
import org.apache.hadoop.hive.metastore.properties.SerializationProxy;

public class PropertySchema
implements Serializable {
    private static final long serialVersionUID = 202212301459L;
    private final transient String name;
    private final transient AtomicInteger versionNumber;
    protected volatile transient UUID digest;
    protected final transient Map<String, PropertyType<?>> properties;
    protected transient Map<String, Object> values;
    public static final PropertySchema NONE = new PropertySchema("", 1, Collections.emptyMap()){

        @Override
        public PropertyType<?> getPropertyType(String name) {
            return PropertyType.STRING;
        }

        @Override
        public boolean declareProperty(String name, PropertyType<?> type) {
            throw new UnsupportedOperationException("schema is readonly");
        }

        @Override
        public boolean removeProperty(String name) {
            throw new UnsupportedOperationException("schema is readonly");
        }
    };

    PropertySchema(String schemaName) {
        this(schemaName, 1, null);
    }

    public PropertySchema(DataInput input) throws IOException {
        String name;
        long serial = input.readLong();
        if (serial != 202212301459L) {
            throw new InvalidObjectException("serial mismatch");
        }
        this.name = input.readUTF();
        this.versionNumber = new AtomicInteger(input.readInt());
        int size = input.readInt();
        this.properties = new TreeMap();
        for (int p = 0; p < size; ++p) {
            name = input.readUTF();
            String typeName = input.readUTF();
            PropertyType<?> type = PropertyType.get(typeName);
            this.properties.put(name, Objects.requireNonNull(type));
        }
        size = input.readInt();
        this.values = size == 0 ? null : new TreeMap();
        for (int v = 0; v < size; ++v) {
            name = input.readUTF();
            PropertyType<?> type = this.properties.get(name);
            String strValue = input.readUTF();
            Object value = type.parse(strValue);
            this.values.put(name, value);
        }
    }

    public void write(DataOutput output) throws IOException {
        output.writeLong(202212301459L);
        output.writeUTF(this.name);
        output.writeInt(this.versionNumber.get());
        if (this.properties != null) {
            output.writeInt(this.properties.size());
            for (Map.Entry<String, PropertyType<?>> entry : this.properties.entrySet()) {
                output.writeUTF(entry.getKey());
                output.writeUTF(entry.getValue().getName());
            }
        } else {
            output.writeInt(0);
        }
        if (this.values != null && this.properties != null) {
            output.writeInt(this.values.size());
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                String name = entry.getKey();
                PropertyType<?> type = this.properties.get(name);
                output.writeUTF(name);
                output.writeUTF(type.format(entry.getValue()));
            }
        } else {
            output.writeInt(0);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy<PropertySchema>(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("proxy required");
    }

    PropertySchema(String schemaName, int version, Map<String, PropertyType<?>> map) {
        this.name = schemaName;
        this.versionNumber = new AtomicInteger(version);
        this.properties = map == null ? new TreeMap() : map;
        this.values = null;
    }

    public String getName() {
        return this.name;
    }

    public int getVersionNumber() {
        return this.versionNumber.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertySchema that = (PropertySchema)o;
        if (!Objects.equals(this.getDigest(), that.getDigest())) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int result = this.getDigest().hashCode();
        result = 31 * result + Objects.hashCode(this.name);
        return result;
    }

    public String toString() {
        return "schema{" + this.name + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getDigest() {
        UUID uuid = this.digest;
        if (uuid == null) {
            PropertySchema propertySchema = this;
            synchronized (propertySchema) {
                uuid = this.digest;
                if (uuid == null) {
                    Digester digester = new Digester();
                    this.properties.forEach((? super K k, ? super V v) -> {
                        digester.digest((String)k);
                        digester.digest(v.getName());
                    });
                    if (this.values != null) {
                        this.values.forEach((? super K k, ? super V v) -> {
                            digester.digest((String)k);
                            digester.digest(v);
                        });
                    }
                    uuid = this.digest = digester.getUUID();
                }
            }
        }
        return uuid;
    }

    public void forEach(BiConsumer<String, PropertyType<?>> action) {
        this.properties.forEach(action);
    }

    public PropertyType<?> getPropertyType(String name) {
        return this.properties.get(name);
    }

    public Object getDefaultValue(String name) {
        return this.values != null ? this.values.get(name) : null;
    }

    public void setDefaultValue(String name, Object value) {
        Object tvalue;
        PropertyType<?> type = this.getPropertyType(name);
        if (type != null && (tvalue = type.cast(value)) != null) {
            this.values.put(name, tvalue);
        }
    }

    public boolean declareProperty(String name, PropertyType<?> type) {
        return this.declareProperty(name, type, null);
    }

    public boolean declareProperty(String name, PropertyType<?> type, Object defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        PropertyType<?> ptype = this.properties.putIfAbsent(name, type);
        if (ptype != null) {
            if (ptype.equals(type)) {
                return false;
            }
            throw new IllegalArgumentException("property " + name + " is already declared");
        }
        Object value = type.cast(defaultValue);
        if (value != null) {
            if (this.values == null) {
                this.values = new TreeMap<String, Object>();
            }
            this.values.put(name, value);
        }
        this.versionNumber.incrementAndGet();
        this.digest = null;
        return true;
    }

    public boolean removeProperty(String name) {
        if (this.properties.remove(name) != null) {
            if (this.values != null) {
                this.values.remove(name);
            }
            this.versionNumber.incrementAndGet();
            this.digest = null;
            return true;
        }
        return false;
    }
}

