/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.systemview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.cluster.management.NodeAttributesProvider;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologyEventListener;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.lang.InternalTuple;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.BinaryTupleSchema;
import org.apache.ignite3.internal.systemview.api.NodeSystemView;
import org.apache.ignite3.internal.systemview.api.SystemView;
import org.apache.ignite3.internal.systemview.api.SystemViewColumn;
import org.apache.ignite3.internal.systemview.api.SystemViewManager;
import org.apache.ignite3.internal.systemview.api.SystemViewProvider;
import org.apache.ignite3.internal.systemview.utils.SystemViewUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.subscription.TransformingPublisher;
import org.apache.ignite3.lang.ErrorGroups;

public class SystemViewManagerImpl
implements SystemViewManager,
NodeAttributesProvider,
LogicalTopologyEventListener {
    public static final String NODE_ATTRIBUTES_KEY = "sql-system-views";
    public static final String NODE_ATTRIBUTES_LIST_SEPARATOR = ",";
    private final String localNodeName;
    private final CatalogManager catalogManager;
    private final FailureProcessor failureProcessor;
    private final Map<String, String> nodeAttributes = new HashMap<String, String>();
    private final Map<String, SystemView<?>> views = new LinkedHashMap();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean startGuard = new AtomicBoolean();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final CompletableFuture<Void> viewsRegistrationFuture = new CompletableFuture();
    private volatile Map<String, ScannableView<?>> scannableViews = Map.of();
    private volatile Map<String, List<String>> owningNodesByViewName = Map.of();

    public SystemViewManagerImpl(String localNodeName, CatalogManager catalogManager, FailureProcessor failureProcessor) {
        this.localNodeName = localNodeName;
        this.catalogManager = catalogManager;
        this.failureProcessor = failureProcessor;
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        IgniteUtils.inBusyLock(this.busyLock, () -> {
            if (!this.startGuard.compareAndSet(false, true)) {
                throw new IllegalStateException("System view manager cannot be started twice");
            }
            if (this.views.isEmpty()) {
                this.viewsRegistrationFuture.complete(null);
                return;
            }
            this.scannableViews = SystemViewManagerImpl.toScannableViews(this.localNodeName, this.views);
            List commands = this.views.values().stream().map(SystemViewUtils::toSystemViewCreateCommand).collect(Collectors.toList());
            ((CompletableFuture)this.catalogManager.catalogReadyFuture(1).thenCompose(x -> this.catalogManager.execute(commands))).whenComplete((r, t) -> {
                this.viewsRegistrationFuture.complete(null);
                if (t != null && !ExceptionUtils.hasCause(t, NodeStoppingException.class)) {
                    this.failureProcessor.process(new FailureContext((Throwable)t, "Failed to register system views."));
                }
            });
            this.nodeAttributes.put(NODE_ATTRIBUTES_KEY, String.join((CharSequence)NODE_ATTRIBUTES_LIST_SEPARATOR, this.views.keySet()));
        });
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.viewsRegistrationFuture.completeExceptionally(new NodeStoppingException());
        this.busyLock.block();
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public List<String> owningNodes(String name) {
        return IgniteUtils.inBusyLock(this.busyLock, () -> this.owningNodesByViewName.getOrDefault(name, List.of()));
    }

    @Override
    public Flow.Publisher<InternalTuple> scanView(String name) {
        ScannableView<?> scannableView = this.scannableViews.get(name);
        if (scannableView == null) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, IgniteStringFormatter.format("View with name '{}' not found on node '{}'", name, this.localNodeName));
        }
        return scannableView.scan();
    }

    @Override
    public void register(SystemViewProvider viewProvider) {
        List<SystemView<?>> views = viewProvider.systemViews();
        views.forEach(this::registerView);
    }

    @Override
    public Map<String, String> nodeAttributes() {
        return this.nodeAttributes;
    }

    @Override
    public void onNodeJoined(LogicalNode joinedNode, LogicalTopologySnapshot newTopology) {
        this.processNewTopology(newTopology);
    }

    @Override
    public void onNodeLeft(LogicalNode leftNode, LogicalTopologySnapshot newTopology) {
        this.processNewTopology(newTopology);
    }

    @Override
    public void onTopologyLeap(LogicalTopologySnapshot newTopology) {
        this.processNewTopology(newTopology);
    }

    public CompletableFuture<Void> completeRegistration() {
        return this.viewsRegistrationFuture;
    }

    private void registerView(SystemView<?> view) {
        if (this.views.containsKey(view.name())) {
            throw new IllegalArgumentException(IgniteStringFormatter.format("The view with name '{}' already registered", view.name()));
        }
        IgniteUtils.inBusyLock(this.busyLock, () -> {
            if (this.startGuard.get()) {
                throw new IllegalStateException(IgniteStringFormatter.format("Unable to register view '{}', manager already started", view.name()));
            }
            this.views.put(view.name(), view);
        });
    }

    private void processNewTopology(LogicalTopologySnapshot topology) {
        HashMap<String, List> owningNodesByViewName = new HashMap<String, List>();
        for (LogicalNode logicalNode : topology.nodes()) {
            String systemViewsNames = logicalNode.systemAttributes().get(NODE_ATTRIBUTES_KEY);
            if (systemViewsNames == null) continue;
            Arrays.stream(systemViewsNames.split(NODE_ATTRIBUTES_LIST_SEPARATOR)).map(String::trim).forEach(viewName -> owningNodesByViewName.computeIfAbsent((String)viewName, key -> new ArrayList()).add(logicalNode.name()));
        }
        for (String viewName2 : owningNodesByViewName.keySet()) {
            owningNodesByViewName.compute(viewName2, (key, value) -> {
                assert (value != null);
                return List.copyOf(value);
            });
        }
        this.owningNodesByViewName = Map.copyOf(owningNodesByViewName);
    }

    private static Map<String, ScannableView<?>> toScannableViews(String localNodeName, Map<String, SystemView<?>> views) {
        HashMap scannableViews = new HashMap();
        for (SystemView<?> view : views.values()) {
            scannableViews.put(view.name(), new ScannableView(localNodeName, view));
        }
        return Map.copyOf(scannableViews);
    }

    private static class ScannableView<T> {
        private final Flow.Publisher<InternalTuple> publisher;

        private ScannableView(String localNodeName, SystemView<T> view) {
            BinaryTupleSchema schema = SystemViewUtils.tupleSchemaForView(view);
            this.publisher = new TransformingPublisher<Object, InternalTuple>(view.dataProvider(), object -> {
                BinaryTupleBuilder builder = new BinaryTupleBuilder(schema.elementCount());
                int offset = 0;
                if (view instanceof NodeSystemView) {
                    builder.appendString(localNodeName);
                    ++offset;
                }
                for (int i = 0; i < view.columns().size(); ++i) {
                    SystemViewColumn column = view.columns().get(i);
                    schema.appendValue(builder, i + offset, column.value().apply(object));
                }
                return new BinaryTuple(schema.elementCount(), builder.build());
            });
        }

        Flow.Publisher<InternalTuple> scan() {
            return this.publisher;
        }
    }
}

