/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheGroupIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;

public class GridDhtPartitionDemandLegacyMessage
extends GridCacheGroupIdMessage {
    private static final long serialVersionUID = 0L;
    private long updateSeq;
    @GridDirectCollection(value=int.class)
    private Collection<Integer> parts;
    @GridDirectCollection(value=int.class)
    private Collection<Integer> historicalParts;
    @GridDirectMap(keyType=int.class, valueType=long.class)
    private Map<Integer, Long> partsCntrs;
    @GridDirectTransient
    private Object topic;
    private byte[] topicBytes;
    private long timeout;
    private int workerId = -1;
    private AffinityTopologyVersion topVer;

    GridDhtPartitionDemandLegacyMessage(long updateSeq, @NotNull AffinityTopologyVersion topVer, int grpId) {
        this.grpId = grpId;
        this.updateSeq = updateSeq;
        this.topVer = topVer;
    }

    GridDhtPartitionDemandLegacyMessage(GridDhtPartitionDemandLegacyMessage cp, Collection<Integer> parts, Map<Integer, Long> partsCntrs) {
        this.grpId = cp.grpId;
        this.updateSeq = cp.updateSeq;
        this.topic = cp.topic;
        this.timeout = cp.timeout;
        this.workerId = cp.workerId;
        this.topVer = cp.topVer;
        this.parts = new HashSet<Integer>(parts);
        this.partsCntrs = partsCntrs;
        if (cp.historicalParts != null) {
            this.historicalParts = new HashSet<Integer>(cp.historicalParts);
        }
    }

    GridDhtPartitionDemandLegacyMessage(GridDhtPartitionDemandMessage cp) {
        this.grpId = cp.groupId();
        this.updateSeq = cp.rebalanceId() < 0L ? -1L : cp.rebalanceId();
        this.topic = cp.topic();
        this.timeout = cp.timeout();
        this.workerId = cp.workerId();
        this.topVer = cp.topologyVersion();
        if (!cp.partitions().isEmpty()) {
            this.parts = new HashSet<Integer>(cp.partitions().size());
            this.parts.addAll(cp.partitions().fullSet());
            CachePartitionPartialCountersMap histMap = cp.partitions().historicalMap();
            if (!histMap.isEmpty()) {
                this.historicalParts = new HashSet<Integer>(histMap.size());
                for (int i = 0; i < histMap.size(); ++i) {
                    int p = histMap.partitionAt(i);
                    this.parts.add(p);
                    this.historicalParts.add(p);
                    this.partsCntrs.put(p, histMap.updateCounterAt(i));
                }
            }
        }
    }

    public GridDhtPartitionDemandLegacyMessage() {
    }

    void addPartition(int p, boolean historical) {
        if (this.parts == null) {
            this.parts = new HashSet<Integer>();
        }
        this.parts.add(p);
        if (historical) {
            if (this.historicalParts == null) {
                this.historicalParts = new HashSet<Integer>();
            }
            this.historicalParts.add(p);
        }
    }

    Collection<Integer> partitions() {
        return this.parts;
    }

    boolean isHistorical(int p) {
        if (this.historicalParts == null) {
            return false;
        }
        return this.historicalParts.contains(p);
    }

    void updateSequence(long updateSeq) {
        this.updateSeq = updateSeq;
    }

    long updateSequence() {
        return this.updateSeq;
    }

    long timeout() {
        return this.timeout;
    }

    void timeout(long timeout) {
        this.timeout = timeout;
    }

    Object topic() {
        return this.topic;
    }

    void topic(Object topic) {
        this.topic = topic;
    }

    int workerId() {
        return this.workerId;
    }

    void workerId(int workerId) {
        this.workerId = workerId;
    }

    Long partitionCounter(int part) {
        return this.partsCntrs == null ? null : this.partsCntrs.get(part);
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.topic != null && this.topicBytes == null) {
            this.topicBytes = U.marshal(ctx, this.topic);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.topicBytes != null && this.topic == null) {
            this.topic = U.unmarshal(ctx, this.topicBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 4: {
                if (!writer.writeCollection("historicalParts", this.historicalParts, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeCollection("parts", this.parts, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeMap("partsCntrs", this.partsCntrs, MessageCollectionItemType.INT, MessageCollectionItemType.LONG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeLong("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeByteArray("topicBytes", this.topicBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeLong("updateSeq", this.updateSeq)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeInt("workerId", this.workerId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 4: {
                this.historicalParts = reader.readCollection("historicalParts", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.parts = reader.readCollection("parts", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.partsCntrs = reader.readMap("partsCntrs", MessageCollectionItemType.INT, MessageCollectionItemType.LONG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.timeout = reader.readLong("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.topicBytes = reader.readByteArray("topicBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.updateSeq = reader.readLong("updateSeq");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.workerId = reader.readInt("workerId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtPartitionDemandLegacyMessage.class);
    }

    @Override
    public short directType() {
        return 44;
    }

    @Override
    public byte fieldsCount() {
        return 12;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtPartitionDemandLegacyMessage.class, this, "partCnt", (Object)(this.parts != null ? this.parts.size() : 0), "super", (Object)super.toString());
    }
}

