/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.odbc.escape;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcUtils;
import org.apache.ignite.internal.processors.odbc.odbc.escape.OdbcEscapeParseResult;
import org.apache.ignite.internal.processors.odbc.odbc.escape.OdbcEscapeToken;
import org.apache.ignite.internal.processors.odbc.odbc.escape.OdbcEscapeType;

public class OdbcEscapeUtils {
    private static final Pattern DATE_PATTERN = Pattern.compile("^'\\d{4}-\\d{2}-\\d{2}'$");
    private static final Pattern TIME_PATTERN = Pattern.compile("^'\\d{2}:\\d{2}:\\d{2}'$");
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("^'\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}(\\.\\d+)?'$");
    private static final Pattern GUID_PATTERN = Pattern.compile("^'\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}'$");
    private static final Pattern CONVERT_TYPE_PATTERN = Pattern.compile(",\\s*(SQL_[\\w_]+)\\s*(?:\\(\\s*\\d+\\s*(?:,\\s*\\d+\\s*)?\\))?\\s*\\)\\s*$", 66);

    public static String parse(String text) {
        if (text == null) {
            throw new IgniteException("Text cannot be null.");
        }
        return OdbcEscapeUtils.parse0(text.trim(), 0, false).result();
    }

    private static OdbcEscapeParseResult parse0(String text, int startPos, boolean earlyExit) {
        int curPos;
        StringBuilder res = new StringBuilder();
        int plainPos = startPos;
        int openPos = -1;
        boolean insideLiteral = false;
        LinkedList<OdbcEscapeParseResult> nested = null;
        for (curPos = startPos; curPos < text.length(); ++curPos) {
            String parseRes;
            char curChar = text.charAt(curPos);
            if (curChar == '\'') {
                insideLiteral = !insideLiteral;
                continue;
            }
            if (insideLiteral) continue;
            if (curChar == '{') {
                if (openPos == -1) {
                    res.append(text, plainPos, curPos);
                    openPos = curPos;
                    continue;
                }
                OdbcEscapeParseResult nestedRes = OdbcEscapeUtils.parse0(text, curPos, true);
                if (nested == null) {
                    nested = new LinkedList<OdbcEscapeParseResult>();
                }
                nested.add(nestedRes);
                plainPos = (curPos += nestedRes.originalLength() - 1) + 1;
                continue;
            }
            if (curChar != '}') continue;
            if (openPos == -1) {
                throw new IgniteException("Malformed escape sequence (closing curly brace without opening curly brace): " + text);
            }
            if (nested == null) {
                parseRes = OdbcEscapeUtils.parseEscapeSequence(text, openPos, curPos + 1 - openPos);
            } else {
                String res0 = OdbcEscapeUtils.appendNested(text, openPos, curPos + 1, nested);
                nested = null;
                parseRes = OdbcEscapeUtils.parseEscapeSequence(res0, 0, res0.length());
            }
            if (earlyExit) {
                return new OdbcEscapeParseResult(startPos, curPos + 1 - startPos, parseRes);
            }
            res.append(parseRes);
            openPos = -1;
            plainPos = curPos + 1;
        }
        if (openPos != -1) {
            throw new IgniteException("Malformed escape sequence (closing curly brace missing): " + text);
        }
        if (insideLiteral) {
            throw new IgniteException("Malformed literal expression (closing quote missing): " + text);
        }
        if (curPos > plainPos) {
            res.append(text, plainPos, curPos);
        }
        return new OdbcEscapeParseResult(startPos, curPos - startPos + 1, res.toString());
    }

    private static String parseEscapeSequence(String text, int startPos, int len) {
        assert (OdbcEscapeUtils.validSubstring(text, startPos, len));
        char firstChar = text.charAt(startPos);
        if (firstChar == '{') {
            char lastChar = text.charAt(startPos + len - 1);
            if (lastChar != '}') {
                throw new IgniteException("Failed to parse escape sequence because it is not enclosed: " + OdbcEscapeUtils.substring(text, startPos, len));
            }
            OdbcEscapeToken token = OdbcEscapeUtils.parseToken(text, startPos, len);
            return OdbcEscapeUtils.parseEscapeSequence(text, startPos, len, token);
        }
        if (startPos == 0 || text.length() == len) {
            return text;
        }
        return OdbcEscapeUtils.substring(text, startPos, len);
    }

    private static OdbcEscapeToken parseToken(String text, int startPos, int len) {
        assert (OdbcEscapeUtils.validSubstring(text, startPos, len));
        assert (text.charAt(startPos) == '{');
        int pos = startPos + 1;
        while (Character.isWhitespace(text.charAt(pos))) {
            ++pos;
        }
        OdbcEscapeType curTyp = null;
        boolean empty = false;
        for (OdbcEscapeType typ : OdbcEscapeType.sortedValues()) {
            char charAfter;
            if (!text.startsWith(typ.body(), pos)) continue;
            if (typ.standard()) {
                pos += typ.body().length();
            }
            boolean bl = empty = startPos + len == pos + 1;
            if (!empty && typ.standard() && !Character.isWhitespace(charAfter = text.charAt(pos))) {
                throw new IgniteException("Unexpected escape sequence token: " + OdbcEscapeUtils.substring(text, startPos, len));
            }
            curTyp = typ;
            break;
        }
        if (curTyp == null) {
            throw new IgniteException("Unsupported escape sequence: " + OdbcEscapeUtils.substring(text, startPos, len));
        }
        if (empty && !curTyp.allowEmpty()) {
            throw new IgniteException("Escape sequence cannot be empty: " + OdbcEscapeUtils.substring(text, startPos, len));
        }
        return new OdbcEscapeToken(curTyp, pos - (startPos + 1));
    }

    private static String parseEscapeSequence(String text, int startPos, int len, OdbcEscapeToken token) {
        assert (OdbcEscapeUtils.validSubstring(text, startPos, len));
        int startPos0 = startPos + 1 + token.length();
        int len0 = len - 1 - token.length() - 1;
        switch (token.type()) {
            case SCALAR_FUNCTION: {
                return OdbcEscapeUtils.parseScalarFunctionExpression(text, startPos0, len0);
            }
            case GUID: {
                String res = OdbcEscapeUtils.parseExpression(text, startPos0, len0, token.type(), GUID_PATTERN);
                return "CAST(" + res + " AS UUID)";
            }
            case DATE: {
                return OdbcEscapeUtils.parseExpression(text, startPos0, len0, token.type(), DATE_PATTERN);
            }
            case TIME: {
                return OdbcEscapeUtils.parseExpression(text, startPos0, len0, token.type(), TIME_PATTERN);
            }
            case TIMESTAMP: {
                return OdbcEscapeUtils.parseExpression(text, startPos0, len0, token.type(), TIMESTAMP_PATTERN);
            }
            case OUTER_JOIN: {
                return OdbcEscapeUtils.parseExpression(text, startPos0, len0);
            }
            case CALL: {
                String val = OdbcEscapeUtils.parseExpression(text, startPos0, len0);
                return "CALL " + val;
            }
            case ESCAPE: 
            case ESCAPE_WO_TOKEN: {
                return OdbcEscapeUtils.parseLikeEscCharacterExpression(text, startPos0, len0);
            }
        }
        throw new IgniteException("Unsupported escape sequence token [text=" + OdbcEscapeUtils.substring(text, startPos, len) + ", token=" + token.type().body() + ']');
    }

    private static String parseExpression(String text, int startPos, int len) {
        return OdbcEscapeUtils.substring(text, startPos, len).trim();
    }

    private static String parseLikeEscCharacterExpression(String text, int startPos, int len) {
        return "ESCAPE " + OdbcEscapeUtils.substring(text, startPos, len).trim();
    }

    private static String parseExpression(String text, int startPos, int len, OdbcEscapeType type, Pattern pattern) {
        String val = OdbcEscapeUtils.parseExpression(text, startPos, len);
        if (!pattern.matcher(val).matches()) {
            throw new IgniteException("Invalid " + (Object)((Object)type) + " escape sequence: " + OdbcEscapeUtils.substring(text, startPos, len));
        }
        return val;
    }

    private static String parseScalarFunctionExpression(String text, int startPos, int len) {
        int pos = startPos;
        int endPos = startPos + len;
        String errPrefix = "Malformed scalar function escape sequence.";
        while (++pos < endPos && Character.isWhitespace(text.charAt(pos))) {
        }
        if (pos == endPos) {
            throw new IgniteException("Malformed scalar function escape sequence. Expected function name.");
        }
        int funcNamePos = pos;
        while (++pos < endPos && Character.isAlphabetic(text.charAt(pos))) {
        }
        if (pos == endPos) {
            throw new IgniteException("Malformed scalar function escape sequence. Expected function parameter list: " + OdbcEscapeUtils.substring(text, startPos, len));
        }
        String funcName = text.substring(funcNamePos, pos);
        switch (funcName.toUpperCase()) {
            case "CONVERT": {
                Matcher matcher = CONVERT_TYPE_PATTERN.matcher(text.substring(startPos, endPos));
                if (!matcher.find()) {
                    throw new IgniteException("Malformed scalar function escape sequence. Invalid arguments :" + OdbcEscapeUtils.substring(text, startPos, len));
                }
                return (text.substring(startPos, startPos + matcher.start(1)) + OdbcUtils.getIgniteTypeFromOdbcType(matcher.group(1)) + text.substring(startPos + matcher.end(1), startPos + len)).trim();
            }
        }
        return OdbcEscapeUtils.substring(text, startPos, len).trim();
    }

    private static String appendNested(String text, int startPos, int endPos, LinkedList<OdbcEscapeParseResult> nestedRess) {
        StringBuilder res = new StringBuilder();
        int curPos = startPos;
        for (OdbcEscapeParseResult nestedRes : nestedRess) {
            res.append(text, curPos, nestedRes.originalStart());
            res.append(nestedRes.result());
            curPos = nestedRes.originalStart() + nestedRes.originalLength();
        }
        res.append(text, curPos, endPos);
        return res.toString();
    }

    private static String substring(String text, int startPos, int len) {
        assert (OdbcEscapeUtils.validSubstring(text, startPos, len));
        return text.substring(startPos, startPos + len);
    }

    private static boolean validSubstring(String text, int startPos, int len) {
        return text != null && startPos + len <= text.length();
    }

    private OdbcEscapeUtils() {
    }
}

