/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.DirectBufferCleaner;
import org.apache.ignite.internal.util.GridUnsafe;
import sun.misc.Unsafe;

public class UnsafeDirectBufferCleaner
implements DirectBufferCleaner {
    private final Method cleanerMtd;

    public UnsafeDirectBufferCleaner() {
        try {
            this.cleanerMtd = Unsafe.class.getMethod("invokeCleaner", ByteBuffer.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Reflection failure: no sun.misc.Unsafe.invokeCleaner() method found", e);
        }
    }

    @Override
    public void clean(ByteBuffer buf) {
        GridUnsafe.invoke(this.cleanerMtd, buf);
    }
}

