/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.formats.iceberg;

import java.util.Map;
import org.apache.amoro.FormatCatalog;
import org.apache.amoro.FormatCatalogFactory;
import org.apache.amoro.TableFormat;
import org.apache.amoro.formats.iceberg.IcebergCatalog;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.utils.MixedCatalogUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.catalog.Catalog;

public class IcebergCatalogFactory
implements FormatCatalogFactory {
    @Override
    public FormatCatalog create(String name, String metastoreType, Map<String, String> properties, TableMetaStore metaStore) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)metastoreType), (Object)"metastore type is blank");
        properties = MixedCatalogUtil.withIcebergCatalogInitializeProperties(name, metastoreType, properties);
        Catalog icebergCatalog = CatalogUtil.buildIcebergCatalog((String)name, properties, (Object)metaStore.getConfiguration());
        return new IcebergCatalog(icebergCatalog, properties, metaStore);
    }

    @Override
    public TableFormat format() {
        return TableFormat.ICEBERG;
    }

    @Override
    public Map<String, String> convertCatalogProperties(String catalogName, String metastoreType, Map<String, String> unifiedCatalogProperties) {
        return MixedCatalogUtil.withIcebergCatalogInitializeProperties(catalogName, metastoreType, unifiedCatalogProperties);
    }
}

