/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io;

import java.util.Map;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.AuthenticatedFileIOAdapter;
import org.apache.amoro.io.AuthenticatedHadoopFileIO;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.utils.MixedCatalogUtil;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;

public class AuthenticatedFileIOs {
    public static final boolean CLOSE_TRASH = true;

    public static AuthenticatedHadoopFileIO buildRecoverableHadoopFileIO(TableIdentifier tableIdentifier, String tableLocation, Map<String, String> tableProperties, TableMetaStore tableMetaStore, Map<String, String> catalogProperties) {
        tableProperties = MixedCatalogUtil.mergeCatalogPropertiesToTable(tableProperties, catalogProperties);
        return new AuthenticatedHadoopFileIO(tableMetaStore);
    }

    public static AuthenticatedHadoopFileIO buildHadoopFileIO(TableMetaStore tableMetaStore) {
        return new AuthenticatedHadoopFileIO(tableMetaStore);
    }

    public static AuthenticatedFileIO buildAdaptIcebergFileIO(TableMetaStore tableMetaStore, FileIO io) {
        if (io instanceof HadoopFileIO) {
            return AuthenticatedFileIOs.buildHadoopFileIO(tableMetaStore);
        }
        return new AuthenticatedFileIOAdapter(io);
    }
}

