/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.writer;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.amoro.data.DataFileType;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.data.PrimaryKeyData;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.writer.OutputFileFactory;
import org.apache.amoro.io.writer.TaskWriterKey;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.util.Tasks;

public abstract class BaseTaskWriter<T>
implements TaskWriter<T> {
    private final long mask;
    private final PartitionKey partitionKey;
    private final PrimaryKeyData primaryKey;
    private final AuthenticatedFileIO io;
    private final WriterHolder<T> writerHolder;

    protected BaseTaskWriter(FileFormat format, FileAppenderFactory<T> appenderFactory, OutputFileFactory outputFileFactory, AuthenticatedFileIO io, long targetFileSize, long mask, Schema schema, PartitionSpec spec, PrimaryKeySpec primaryKeySpec, boolean orderedWriter) {
        this.writerHolder = orderedWriter ? new OrderedWriterHolder<T>(format, appenderFactory, outputFileFactory, io, targetFileSize) : new FanoutWriterHolder<T>(format, appenderFactory, outputFileFactory, io, targetFileSize);
        this.io = io;
        this.mask = mask;
        this.partitionKey = new PartitionKey(spec, schema);
        this.primaryKey = primaryKeySpec == null ? null : new PrimaryKeyData(primaryKeySpec, schema);
    }

    public void write(T row) throws IOException {
        DataWriterKey writerKey = this.buildWriterKey(row);
        TaskDataWriter<T> writer = this.writerHolder.get(writerKey);
        this.write(writer, row);
    }

    protected void write(TaskDataWriter<T> writer, T row) throws IOException {
        writer.write(row);
    }

    protected DataWriterKey buildWriterKey(T row) {
        DataTreeNode node;
        StructLike structLike = this.asStructLike(row);
        this.partitionKey.partition(structLike);
        if (this.primaryKey != null) {
            this.primaryKey.primaryKey(structLike);
            node = this.primaryKey.treeNode(this.mask);
        } else {
            node = DataTreeNode.ROOT;
        }
        return new DataWriterKey(this.partitionKey, node, DataFileType.BASE_FILE);
    }

    public void abort() throws IOException {
        this.writerHolder.close();
        List<DataFile> completedFiles = this.writerHolder.completedFiles();
        Tasks.foreach(completedFiles).throwFailureWhenFinished().noRetry().run(file -> this.io.deleteFile(file.path().toString()));
    }

    public WriteResult complete() throws IOException {
        this.writerHolder.close();
        List<DataFile> files = this.writerHolder.completedFiles();
        return WriteResult.builder().addDataFiles(files.toArray(new DataFile[0])).build();
    }

    public void close() throws IOException {
        this.writerHolder.close();
    }

    protected PrimaryKeyData getPrimaryKey() {
        return this.primaryKey;
    }

    protected abstract StructLike asStructLike(T var1);

    protected static class TaskDataWriter<T> {
        private final DataWriter<T> dataWriter;
        private long currentRows = 0L;
        private final AuthenticatedFileIO io;

        protected TaskDataWriter(DataWriter<T> dataWriter, AuthenticatedFileIO io) {
            this.dataWriter = dataWriter;
            this.io = io;
        }

        protected void write(T record) {
            this.dataWriter.write(record);
            ++this.currentRows;
        }

        protected void close() {
            this.io.doAs(() -> {
                this.dataWriter.close();
                return null;
            });
            if (this.currentRows <= 0L) {
                try {
                    this.io.deleteFile(this.dataWriter.toDataFile().path().toString());
                }
                catch (UncheckedIOException uncheckedIOException) {
                    // empty catch block
                }
            }
        }

        protected DataFile toDataFile() {
            if (this.currentRows > 0L) {
                return this.dataWriter.toDataFile();
            }
            return null;
        }

        protected long length() {
            return this.dataWriter.length();
        }
    }

    protected static class OrderedWriterHolder<T>
    extends WriterHolder<T> {
        private TaskDataWriter<T> currentWriter;
        private DataWriterKey currentKey;
        private final Set<DataWriterKey> completedKeys = Sets.newHashSet();

        public OrderedWriterHolder(FileFormat format, FileAppenderFactory<T> appenderFactory, OutputFileFactory outputFileFactory, AuthenticatedFileIO io, long targetFileSize) {
            super(format, appenderFactory, outputFileFactory, io, targetFileSize);
        }

        @Override
        public TaskDataWriter<T> getDataWriter(DataWriterKey writerKey) throws IOException {
            if (!writerKey.equals(this.currentKey)) {
                if (this.currentKey != null) {
                    this.closeCurrentWriter();
                    this.completedKeys.add(this.currentKey);
                }
                if (this.completedKeys.contains(writerKey)) {
                    throw new IllegalStateException("The write key " + writerKey + " has already been completed");
                }
                this.currentKey = writerKey.copy();
                this.currentWriter = this.newWriter(this.currentKey);
            } else if (this.shouldRollToNewFile(this.currentWriter)) {
                this.closeCurrentWriter();
                this.currentWriter = this.newWriter(writerKey);
            }
            return this.currentWriter;
        }

        private void closeCurrentWriter() throws IOException {
            if (this.currentWriter != null) {
                this.currentWriter.close();
                DataFile dataFile = this.currentWriter.toDataFile();
                if (dataFile != null) {
                    this.completedFiles.add(this.currentWriter.toDataFile());
                }
                this.currentWriter = null;
            }
        }

        @Override
        public void doClose() throws IOException {
            this.closeCurrentWriter();
        }
    }

    protected static class FanoutWriterHolder<T>
    extends WriterHolder<T> {
        private final Map<DataWriterKey, TaskDataWriter<T>> dataWriterMap = Maps.newHashMap();

        public FanoutWriterHolder(FileFormat format, FileAppenderFactory<T> appenderFactory, OutputFileFactory outputFileFactory, AuthenticatedFileIO io, long targetFileSize) {
            super(format, appenderFactory, outputFileFactory, io, targetFileSize);
        }

        @Override
        public TaskDataWriter<T> getDataWriter(DataWriterKey writerKey) throws IOException {
            TaskDataWriter<T> writer = this.dataWriterMap.get(writerKey);
            if (writer != null && this.shouldRollToNewFile(writer)) {
                writer.close();
                this.completedFiles.add(writer.toDataFile());
                this.dataWriterMap.remove(writerKey);
            }
            if (!this.dataWriterMap.containsKey(writerKey)) {
                DataWriterKey copiedWriterKey = writerKey.copy();
                writer = this.newWriter(copiedWriterKey);
                this.dataWriterMap.put(copiedWriterKey, writer);
            } else {
                writer = this.dataWriterMap.get(writerKey);
            }
            return writer;
        }

        @Override
        public void doClose() throws IOException {
            for (TaskDataWriter<T> dataWriter : this.dataWriterMap.values()) {
                dataWriter.close();
                DataFile dataFile = dataWriter.toDataFile();
                if (dataFile == null) continue;
                this.completedFiles.add(dataWriter.toDataFile());
            }
            this.dataWriterMap.clear();
        }
    }

    protected static abstract class WriterHolder<T> {
        protected final FileFormat format;
        protected final FileAppenderFactory<T> appenderFactory;
        protected final OutputFileFactory outputFileFactory;
        protected final AuthenticatedFileIO io;
        protected final long targetFileSize;
        protected final List<DataFile> completedFiles = Lists.newArrayList();
        private boolean closed = false;

        public WriterHolder(FileFormat format, FileAppenderFactory<T> appenderFactory, OutputFileFactory outputFileFactory, AuthenticatedFileIO io, long targetFileSize) {
            this.format = format;
            this.appenderFactory = appenderFactory;
            this.outputFileFactory = outputFileFactory;
            this.io = io;
            this.targetFileSize = targetFileSize;
        }

        protected abstract TaskDataWriter<T> getDataWriter(DataWriterKey var1) throws IOException;

        public TaskDataWriter<T> get(DataWriterKey writerKey) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("The task writer has already been closed.");
            }
            return this.getDataWriter(writerKey);
        }

        public void close() throws IOException {
            this.closed = true;
            this.doClose();
        }

        protected abstract void doClose() throws IOException;

        public List<DataFile> completedFiles() {
            return Lists.newArrayList(this.completedFiles);
        }

        protected boolean shouldRollToNewFile(TaskDataWriter<T> dataWriter) {
            return dataWriter.length() >= this.targetFileSize;
        }

        protected TaskDataWriter<T> newWriter(TaskWriterKey writerKey) {
            DataWriter dataWriter = this.io.doAs(() -> this.appenderFactory.newDataWriter(this.outputFileFactory.newOutputFile(writerKey), this.format, writerKey.getPartitionKey()));
            return new TaskDataWriter(dataWriter, this.io);
        }
    }

    protected static class DataWriterKey
    extends TaskWriterKey {
        final PartitionKey partitionKey;

        public DataWriterKey(PartitionKey partitionKey, DataTreeNode treeNode, DataFileType fileType) {
            super((StructLike)partitionKey, treeNode, fileType);
            this.partitionKey = partitionKey;
        }

        public DataWriterKey copy() {
            return new DataWriterKey(this.partitionKey.copy(), this.getTreeNode(), this.getFileType());
        }

        public PartitionKey getPartitionKey() {
            return this.partitionKey;
        }

        public String toString() {
            return "[" + this.partitionKey.toString() + " " + this.getTreeNode().toString() + "]";
        }
    }
}

