/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.util.Map;
import org.apache.iceberg.util.PropertyUtil;

public class CompatiblePropertyUtil {
    private CompatiblePropertyUtil() {
    }

    public static boolean propertyAsBoolean(Map<String, String> properties, String property, boolean defaultValue) {
        return PropertyUtil.propertyAsBoolean(properties, (String)CompatiblePropertyUtil.getCompatibleProperty(properties, property), (boolean)defaultValue);
    }

    public static double propertyAsDouble(Map<String, String> properties, String property, double defaultValue) {
        return PropertyUtil.propertyAsDouble(properties, (String)CompatiblePropertyUtil.getCompatibleProperty(properties, property), (double)defaultValue);
    }

    public static int propertyAsInt(Map<String, String> properties, String property, int defaultValue) {
        return PropertyUtil.propertyAsInt(properties, (String)CompatiblePropertyUtil.getCompatibleProperty(properties, property), (int)defaultValue);
    }

    public static long propertyAsLong(Map<String, String> properties, String property, long defaultValue) {
        return PropertyUtil.propertyAsLong(properties, (String)CompatiblePropertyUtil.getCompatibleProperty(properties, property), (long)defaultValue);
    }

    public static String propertyAsString(Map<String, String> properties, String property, String defaultValue) {
        return PropertyUtil.propertyAsString(properties, (String)CompatiblePropertyUtil.getCompatibleProperty(properties, property), (String)defaultValue);
    }

    private static String getCompatibleProperty(Map<String, String> properties, String property) {
        String legacyProperty = CompatiblePropertyUtil.getLegacyProperty(property);
        if (legacyProperty != null && properties.containsKey(legacyProperty) && !properties.containsKey(property)) {
            return legacyProperty;
        }
        return property;
    }

    private static String getLegacyProperty(String property) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "self-optimizing.enabled": {
                return "optimize.enable";
            }
            case "self-optimizing.group": {
                return "optimize.group";
            }
            case "self-optimizing.quota": {
                return "optimize.quota";
            }
            case "self-optimizing.execute.num-retries": {
                return "optimize.num-retries";
            }
            case "self-optimizing.max-file-count": {
                return "optimize.max-file-count";
            }
            case "self-optimizing.minor.trigger.file-count": {
                return "optimize.minor.trigger.delete-file-count";
            }
            case "self-optimizing.minor.trigger.interval": {
                return "optimize.minor.trigger.max-interval";
            }
            case "self-optimizing.full.trigger.interval": {
                return "optimize.full.trigger.max-interval";
            }
            case "table-expire.enabled": {
                return "table-expire.enable";
            }
            case "clean-orphan-file.enabled": {
                return "clean-orphan-file.enable";
            }
            case "log-store.enabled": {
                return "log-store.enable";
            }
        }
        return null;
    }
}

