/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.flink.configuration.Configuration;

public class DynamicPropertiesUtil {
    static final Option DYNAMIC_PROPERTIES = Option.builder((String)"D").argName("property=value").numberOfArgs(2).valueSeparator('=').desc("Allows specifying multiple generic configuration options. The available options can be found at https://nightlies.apache.org/flink/flink-docs-stable/ops/config.html").build();

    public static void encodeDynamicProperties(CommandLine commandLine, Configuration effectiveConfiguration) {
        Properties properties = commandLine.getOptionProperties(DYNAMIC_PROPERTIES.getOpt());
        properties.stringPropertyNames().forEach(key -> {
            String value = properties.getProperty((String)key);
            if (value != null) {
                effectiveConfiguration.setString(key, value);
            } else {
                effectiveConfiguration.setString(key, "true");
            }
        });
    }
}

