/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.expressions.Bound;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.types.Type;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.common.type.HiveDecimal;
import org.apache.orc.storage.ql.io.sarg.PredicateLeaf;
import org.apache.orc.storage.ql.io.sarg.SearchArgument;
import org.apache.orc.storage.ql.io.sarg.SearchArgumentFactory;
import org.apache.orc.storage.serde2.io.HiveDecimalWritable;

class ExpressionToSearchArgument
extends ExpressionVisitors.BoundVisitor<Action> {
    private static final Set<Type.TypeID> UNSUPPORTED_TYPES = ImmutableSet.of((Object)Type.TypeID.BINARY, (Object)Type.TypeID.FIXED, (Object)Type.TypeID.UUID, (Object)Type.TypeID.STRUCT, (Object)Type.TypeID.MAP, (Object)Type.TypeID.LIST, (Object[])new Type.TypeID[0]);
    private SearchArgument.Builder builder;
    private Map<Integer, String> idToColumnName;

    static SearchArgument convert(Expression expr, TypeDescription readSchema) {
        Map<Integer, String> idToColumnName = ORCSchemaUtil.idToOrcName(ORCSchemaUtil.convert(readSchema));
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        ((Action)ExpressionVisitors.visit((Expression)expr, (ExpressionVisitors.ExpressionVisitor)new ExpressionToSearchArgument(builder, idToColumnName))).invoke();
        return builder.build();
    }

    private ExpressionToSearchArgument(SearchArgument.Builder builder, Map<Integer, String> idToColumnName) {
        this.builder = builder;
        this.idToColumnName = idToColumnName;
    }

    public Action alwaysTrue() {
        return () -> this.builder.literal(SearchArgument.TruthValue.YES);
    }

    public Action alwaysFalse() {
        return () -> this.builder.literal(SearchArgument.TruthValue.NO);
    }

    public Action not(Action child) {
        return () -> {
            this.builder.startNot();
            child.invoke();
            this.builder.end();
        };
    }

    public Action and(Action leftChild, Action rightChild) {
        return () -> {
            this.builder.startAnd();
            leftChild.invoke();
            rightChild.invoke();
            this.builder.end();
        };
    }

    public Action or(Action leftChild, Action rightChild) {
        return () -> {
            this.builder.startOr();
            leftChild.invoke();
            rightChild.invoke();
            this.builder.end();
        };
    }

    public <T> Action isNull(Bound<T> expr) {
        return () -> this.builder.isNull(this.idToColumnName.get(expr.ref().fieldId()), this.type(expr.ref().type()));
    }

    public <T> Action notNull(Bound<T> expr) {
        return () -> this.builder.startNot().isNull(this.idToColumnName.get(expr.ref().fieldId()), this.type(expr.ref().type())).end();
    }

    public <T> Action isNaN(Bound<T> expr) {
        return () -> this.builder.equals(this.idToColumnName.get(expr.ref().fieldId()), this.type(expr.ref().type()), this.literal(expr.ref().type(), this.getNaNForType(expr.ref().type())));
    }

    private Object getNaNForType(Type type) {
        switch (type.typeId()) {
            case FLOAT: {
                return Float.valueOf(Float.NaN);
            }
            case DOUBLE: {
                return Double.NaN;
            }
        }
        throw new IllegalArgumentException("Cannot get NaN value for type " + type.typeId());
    }

    public <T> Action notNaN(Bound<T> expr) {
        return () -> {
            this.builder.startOr();
            this.isNull(expr).invoke();
            this.builder.startNot();
            this.isNaN(expr).invoke();
            this.builder.end();
            this.builder.end();
        };
    }

    public <T> Action lt(Bound<T> expr, Literal<T> lit) {
        return () -> this.builder.lessThan(this.idToColumnName.get(expr.ref().fieldId()), this.type(expr.ref().type()), this.literal(expr.ref().type(), lit.value()));
    }

    public <T> Action ltEq(Bound<T> expr, Literal<T> lit) {
        return () -> this.builder.lessThanEquals(this.idToColumnName.get(expr.ref().fieldId()), this.type(expr.ref().type()), this.literal(expr.ref().type(), lit.value()));
    }

    public <T> Action gt(Bound<T> expr, Literal<T> lit) {
        return () -> this.builder.startNot().lessThanEquals(this.idToColumnName.get(expr.ref().fieldId()), this.type(expr.ref().type()), this.literal(expr.ref().type(), lit.value())).end();
    }

    public <T> Action gtEq(Bound<T> expr, Literal<T> lit) {
        return () -> this.builder.startNot().lessThan(this.idToColumnName.get(expr.ref().fieldId()), this.type(expr.ref().type()), this.literal(expr.ref().type(), lit.value())).end();
    }

    public <T> Action eq(Bound<T> expr, Literal<T> lit) {
        return () -> this.builder.equals(this.idToColumnName.get(expr.ref().fieldId()), this.type(expr.ref().type()), this.literal(expr.ref().type(), lit.value()));
    }

    public <T> Action notEq(Bound<T> expr, Literal<T> lit) {
        return () -> {
            this.builder.startOr();
            this.isNull(expr).invoke();
            this.builder.startNot();
            this.eq(expr, lit).invoke();
            this.builder.end();
            this.builder.end();
        };
    }

    public <T> Action in(Bound<T> expr, Set<T> literalSet) {
        return () -> this.builder.in(this.idToColumnName.get(expr.ref().fieldId()), this.type(expr.ref().type()), (Object[])literalSet.stream().map(lit -> this.literal(expr.ref().type(), lit)).toArray(Object[]::new));
    }

    public <T> Action notIn(Bound<T> expr, Set<T> literalSet) {
        return () -> {
            this.builder.startOr();
            this.isNull(expr).invoke();
            this.builder.startNot();
            this.in(expr, literalSet).invoke();
            this.builder.end();
            this.builder.end();
        };
    }

    public <T> Action startsWith(Bound<T> expr, Literal<T> lit) {
        return () -> this.builder.literal(SearchArgument.TruthValue.YES_NO_NULL);
    }

    public <T> Action notStartsWith(Bound<T> expr, Literal<T> lit) {
        return () -> this.builder.literal(SearchArgument.TruthValue.YES_NO_NULL);
    }

    public <T> Action predicate(BoundPredicate<T> pred) {
        if (UNSUPPORTED_TYPES.contains(pred.ref().type().typeId()) || !(pred.term() instanceof BoundReference)) {
            return () -> this.builder.literal(SearchArgument.TruthValue.YES_NO_NULL);
        }
        return (Action)super.predicate(pred);
    }

    private PredicateLeaf.Type type(Type icebergType) {
        switch (icebergType.typeId()) {
            case BOOLEAN: {
                return PredicateLeaf.Type.BOOLEAN;
            }
            case INTEGER: 
            case LONG: 
            case TIME: {
                return PredicateLeaf.Type.LONG;
            }
            case FLOAT: 
            case DOUBLE: {
                return PredicateLeaf.Type.FLOAT;
            }
            case DATE: {
                return PredicateLeaf.Type.DATE;
            }
            case TIMESTAMP: {
                return PredicateLeaf.Type.TIMESTAMP;
            }
            case STRING: {
                return PredicateLeaf.Type.STRING;
            }
            case DECIMAL: {
                return PredicateLeaf.Type.DECIMAL;
            }
        }
        throw new UnsupportedOperationException("Type " + icebergType + " not supported in ORC SearchArguments");
    }

    private <T> Object literal(Type icebergType, T icebergLiteral) {
        switch (icebergType.typeId()) {
            case DOUBLE: 
            case BOOLEAN: 
            case LONG: 
            case TIME: {
                return icebergLiteral;
            }
            case INTEGER: {
                return ((Integer)icebergLiteral).longValue();
            }
            case FLOAT: {
                return ((Float)icebergLiteral).doubleValue();
            }
            case STRING: {
                return icebergLiteral.toString();
            }
            case DATE: {
                return Date.valueOf(LocalDate.ofEpochDay(((Integer)icebergLiteral).intValue()));
            }
            case TIMESTAMP: {
                long microsFromEpoch = (Long)icebergLiteral;
                return Timestamp.from(Instant.ofEpochSecond(Math.floorDiv(microsFromEpoch, 1000000L), Math.floorMod(microsFromEpoch, 1000000L) * 1000L));
            }
            case DECIMAL: {
                return new HiveDecimalWritable(HiveDecimal.create((BigDecimal)((BigDecimal)icebergLiteral), (boolean)false));
            }
        }
        throw new UnsupportedOperationException("Type " + icebergType + " not supported in ORC SearchArguments");
    }

    @FunctionalInterface
    static interface Action {
        public void invoke();
    }
}

