/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.api.config;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.amoro.api.config.ConfigHelpers;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Objects;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.utils.CompatiblePropertyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DataExpirationConfig {
    private boolean enabled;
    private String expirationField;
    @JsonProperty(defaultValue="partition")
    private ExpireLevel expirationLevel;
    private long retentionTime;
    @JsonProperty(defaultValue="yyyy-MM-dd")
    private String dateTimePattern;
    @JsonProperty(defaultValue="TIMESTAMP_MS")
    private String numberDateFormat;
    @JsonProperty(defaultValue="LAST_COMMIT_TIME")
    private BaseOnRule baseOnRule;
    public static final Set<Type.TypeID> FIELD_TYPES = Sets.newHashSet((Object[])new Type.TypeID[]{Type.TypeID.TIMESTAMP, Type.TypeID.STRING, Type.TypeID.LONG});
    private static final Logger LOG = LoggerFactory.getLogger(DataExpirationConfig.class);

    public DataExpirationConfig() {
    }

    public DataExpirationConfig(boolean enabled, String expirationField, ExpireLevel expirationLevel, long retentionTime, String dateTimePattern, String numberDateFormat, BaseOnRule baseOnRule) {
        this.enabled = enabled;
        this.expirationField = expirationField;
        this.expirationLevel = expirationLevel;
        this.retentionTime = retentionTime;
        this.dateTimePattern = dateTimePattern;
        this.numberDateFormat = numberDateFormat;
        this.baseOnRule = baseOnRule;
    }

    public DataExpirationConfig(MixedTable table) {
        Map properties = table.properties();
        this.expirationField = CompatiblePropertyUtil.propertyAsString((Map)properties, (String)"data-expire.field", null);
        Types.NestedField field = table.schema().findField(this.expirationField);
        Preconditions.checkArgument((StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.expirationField}) && null != field ? 1 : 0) != 0, (Object)String.format("Field(%s) used to determine data expiration is illegal for table(%s)", this.expirationField, table.name()));
        Type.TypeID typeID = field.type().typeId();
        Preconditions.checkArgument((boolean)FIELD_TYPES.contains(typeID), (Object)String.format("The type(%s) of filed(%s) is incompatible for table(%s)", typeID.name(), this.expirationField, table.name()));
        this.expirationLevel = ExpireLevel.fromString(CompatiblePropertyUtil.propertyAsString((Map)properties, (String)"data-expire.level", (String)"partition"));
        String retention = CompatiblePropertyUtil.propertyAsString((Map)properties, (String)"data-expire.retention-time", null);
        if (StringUtils.isNotBlank((CharSequence)retention)) {
            this.retentionTime = ConfigHelpers.TimeUtils.parseDuration(retention).toMillis();
        }
        this.dateTimePattern = CompatiblePropertyUtil.propertyAsString((Map)properties, (String)"data-expire.datetime-string-pattern", (String)"yyyy-MM-dd");
        this.numberDateFormat = CompatiblePropertyUtil.propertyAsString((Map)properties, (String)"data-expire.datetime-number-format", (String)"TIMESTAMP_MS");
        this.baseOnRule = BaseOnRule.fromString(CompatiblePropertyUtil.propertyAsString((Map)properties, (String)"data-expire.base-on-rule", (String)"LAST_COMMIT_TIME"));
    }

    public static DataExpirationConfig parse(Map<String, String> properties) {
        boolean gcEnabled = CompatiblePropertyUtil.propertyAsBoolean(properties, (String)"gc.enabled", (boolean)true);
        DataExpirationConfig config = new DataExpirationConfig().setEnabled(gcEnabled && CompatiblePropertyUtil.propertyAsBoolean(properties, (String)"data-expire.enabled", (boolean)false)).setExpirationLevel(ExpireLevel.fromString(CompatiblePropertyUtil.propertyAsString(properties, (String)"data-expire.level", (String)"partition"))).setExpirationField(CompatiblePropertyUtil.propertyAsString(properties, (String)"data-expire.field", null)).setDateTimePattern(CompatiblePropertyUtil.propertyAsString(properties, (String)"data-expire.datetime-string-pattern", (String)"yyyy-MM-dd")).setNumberDateFormat(CompatiblePropertyUtil.propertyAsString(properties, (String)"data-expire.datetime-number-format", (String)"TIMESTAMP_MS")).setBaseOnRule(BaseOnRule.fromString(CompatiblePropertyUtil.propertyAsString(properties, (String)"data-expire.base-on-rule", (String)"LAST_COMMIT_TIME")));
        String retention = CompatiblePropertyUtil.propertyAsString(properties, (String)"data-expire.retention-time", null);
        if (StringUtils.isNotBlank((CharSequence)retention)) {
            config.setRetentionTime(ConfigHelpers.TimeUtils.parseDuration(retention).toMillis());
        }
        return config;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DataExpirationConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getExpirationField() {
        return this.expirationField;
    }

    public DataExpirationConfig setExpirationField(String expirationField) {
        this.expirationField = expirationField;
        return this;
    }

    public ExpireLevel getExpirationLevel() {
        return this.expirationLevel;
    }

    public DataExpirationConfig setExpirationLevel(ExpireLevel expirationLevel) {
        this.expirationLevel = expirationLevel;
        return this;
    }

    public long getRetentionTime() {
        return this.retentionTime;
    }

    public DataExpirationConfig setRetentionTime(long retentionTime) {
        this.retentionTime = retentionTime;
        return this;
    }

    public String getDateTimePattern() {
        return this.dateTimePattern;
    }

    public DataExpirationConfig setDateTimePattern(String dateTimePattern) {
        this.dateTimePattern = dateTimePattern;
        return this;
    }

    public String getNumberDateFormat() {
        return this.numberDateFormat;
    }

    public DataExpirationConfig setNumberDateFormat(String numberDateFormat) {
        this.numberDateFormat = numberDateFormat;
        return this;
    }

    public BaseOnRule getBaseOnRule() {
        return this.baseOnRule;
    }

    public DataExpirationConfig setBaseOnRule(BaseOnRule baseOnRule) {
        this.baseOnRule = baseOnRule;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataExpirationConfig)) {
            return false;
        }
        DataExpirationConfig config = (DataExpirationConfig)o;
        return this.enabled == config.enabled && this.retentionTime == config.retentionTime && Objects.equal((Object)this.expirationField, (Object)config.expirationField) && this.expirationLevel == config.expirationLevel && Objects.equal((Object)this.dateTimePattern, (Object)config.dateTimePattern) && Objects.equal((Object)this.numberDateFormat, (Object)config.numberDateFormat) && this.baseOnRule == config.baseOnRule;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.enabled, this.expirationField, this.expirationLevel, this.retentionTime, this.dateTimePattern, this.numberDateFormat, this.baseOnRule});
    }

    public boolean isValid(Types.NestedField field, String name) {
        return this.isEnabled() && this.getRetentionTime() > 0L && this.validateExpirationField(field, name, this.getExpirationField());
    }

    private boolean validateExpirationField(Types.NestedField field, String name, String expirationField) {
        if (StringUtils.isBlank((CharSequence)expirationField) || null == field) {
            LOG.warn(String.format("Field(%s) used to determine data expiration is illegal for table(%s)", expirationField, name));
            return false;
        }
        Type.TypeID typeID = field.type().typeId();
        if (!FIELD_TYPES.contains(typeID)) {
            LOG.warn(String.format("Table(%s) field(%s) type(%s) is not supported for data expiration, please use the following types: %s", name, expirationField, typeID.name(), StringUtils.join(FIELD_TYPES, (String)", ")));
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public static enum BaseOnRule {
        LAST_COMMIT_TIME,
        CURRENT_TIME;


        public static BaseOnRule fromString(String since) {
            Preconditions.checkArgument((null != since ? 1 : 0) != 0, (Object)"data-expire.base-on-rule is invalid: null");
            try {
                return BaseOnRule.valueOf(since.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Unable to expire data since: %s", since), e);
            }
        }
    }

    @VisibleForTesting
    public static enum ExpireLevel {
        PARTITION,
        FILE;


        public static ExpireLevel fromString(String level) {
            Preconditions.checkArgument((null != level ? 1 : 0) != 0, (Object)"Invalid level type: null");
            try {
                return ExpireLevel.valueOf(level.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid level type: %s", level), e);
            }
        }
    }
}

