/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.apache.spark.sql.execution.streaming.MetadataVersionUtil$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=d\u0001\u0002\u0014(\u0001QB\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"Aq\f\u0001B\u0002B\u0003-\u0001\rC\u0003g\u0001\u0011\u0005q\rC\u0004n\u0001\t\u0007I1\u00028\t\u000f\u0005=\u0001\u0001)A\u0005_\"I\u0011\u0011\u0003\u0001C\u0002\u0013-\u00111\u0003\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\u0016!I\u0011Q\u0004\u0001C\u0002\u0013\u0005\u0011q\u0004\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002\"!I\u00111\u0007\u0001C\u0002\u0013E\u0011Q\u0007\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u00028!I\u0011q\b\u0001C\u0002\u0013E\u0011\u0011\t\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002D!9\u0011q\f\u0001\u0005\u0012\u0005\u0005\u0004bBA7\u0001\u0011E\u0011q\u000e\u0005\b\u0003g\u0002A\u0011CA;\u0011\u001d\ty\b\u0001C\t\u0003\u0003Cq!!(\u0001\t#\ty\nC\u0004\u0002,\u0002!\t%!,\t\u000f\u0005M\u0006\u0001\"\u0011\u00026\"9\u0011q\u0018\u0001\u0005\u0002\u0005\u0005\u0007bBAq\u0001\u0011\u0005\u00111\u001d\u0005\b\u0003g\u0003A\u0011IAw\u0011\u001d\u0011)\u0001\u0001C\u0001\u0005\u000fAqA!\u0003\u0001\t\u0003\u0012Y\u0001C\u0004\u0003\u0010\u0001!\tA!\u0005\t\u0013\tm\u0001\u00011A\u0005\n\tu\u0001\"\u0003B\u0010\u0001\u0001\u0007I\u0011\u0002B\u0011\u0011!\u00119\u0003\u0001Q!\n\u0005\u001d\u0004b\u0002B\u0015\u0001\u0011\u0005#1\u0006\u0005\b\u0005c\u0001A\u0011\u0001B\u001a\u0011!\u00119\u0004\u0001C\u0001W\tera\u0002B%O!\u0005!1\n\u0004\u0007M\u001dB\tA!\u0014\t\r\u0019\u001cC\u0011\u0001B(\u0011\u001d\u0011\tf\tC\u0001\u0005'\u0012q\u0002\u0013#G'6+G/\u00193bi\u0006dun\u001a\u0006\u0003Q%\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005)Z\u0013!C3yK\u000e,H/[8o\u0015\taS&A\u0002tc2T!AL\u0018\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\n\u0014AB1qC\u000eDWMC\u00013\u0003\ry'oZ\u0002\u0001+\t)$i\u0005\u0003\u0001mqB\u0005CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$AB!osJ+g\rE\u0002>}\u0001k\u0011aJ\u0005\u0003\u007f\u001d\u00121\"T3uC\u0012\fG/\u0019'pOB\u0011\u0011I\u0011\u0007\u0001\t\u0015\u0019\u0005A1\u0001E\u0005\u0005!\u0016CA#7!\t9d)\u0003\u0002Hq\t9aj\u001c;iS:<\u0007CA%M\u001b\u0005Q%BA&.\u0003!Ig\u000e^3s]\u0006d\u0017BA'K\u0005\u001daunZ4j]\u001e\fAb\u001d9be.\u001cVm]:j_:\u0004\"\u0001U)\u000e\u0003-J!AU\u0016\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\tA\fG\u000f\u001b\t\u0003+rs!A\u0016.\u0011\u0005]CT\"\u0001-\u000b\u0005e\u001b\u0014A\u0002\u001fs_>$h(\u0003\u0002\\q\u00051\u0001K]3eK\u001aL!!\u00180\u0003\rM#(/\u001b8h\u0015\tY\u0006(\u0001\u0006fm&$WM\\2fIE\u00022!\u00193A\u001b\u0005\u0011'BA29\u0003\u001d\u0011XM\u001a7fGRL!!\u001a2\u0003\u0011\rc\u0017m]:UC\u001e\fa\u0001P5oSRtDc\u00015lYR\u0011\u0011N\u001b\t\u0004{\u0001\u0001\u0005\"B0\u0005\u0001\b\u0001\u0007\"\u0002(\u0005\u0001\u0004y\u0005\"B*\u0005\u0001\u0004!\u0016a\u00024pe6\fGo]\u000b\u0002_J\u0019\u0001ON<\u0007\tE\u0004\u0001a\u001c\u0002\ryI,g-\u001b8f[\u0016tGOP\u0005\u0003[NL!\u0001^;\u0003\u001bM+'/[1mSj\fG/[8o\u0015\t1\u0018'\u0001\u0004kg>tGg\u001d\t\u0003qfl\u0011!^\u0005\u0003uV\u0014qAR8s[\u0006$8\u000fC\u0004}a\n\u0007I\u0011A?\u0002\u0015\u0011\fG/\u001a$pe6\fG/F\u0001\u007f!\tAx0C\u0002\u0002\u0002U\u0014!\u0002R1uK\u001a{'/\\1u\u0011%\t)\u0001\u001db\u0001\n\u0003\n9!A\u0005usB,\u0007*\u001b8ugV\u0011\u0011\u0011\u0002\t\u0004q\u0006-\u0011bAA\u0007k\nIA+\u001f9f\u0011&tGo]\u0001\tM>\u0014X.\u0019;tA\u0005AQ.\u00198jM\u0016\u001cH/\u0006\u0002\u0002\u0016A!\u0011-a\u0006A\u0013\r\tIB\u0019\u0002\t\u001b\u0006t\u0017NZ3ti\u0006IQ.\u00198jM\u0016\u001cH\u000fI\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f[\u000b\u0003\u0003C\u0001B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0002gg*\u0019\u00111F\u0018\u0002\r!\fGm\\8q\u0013\u0011\ty#!\n\u0003\tA\u000bG\u000f[\u0001\u000e[\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\u0011\u0002\u0017\u0019LG.Z'b]\u0006<WM]\u000b\u0003\u0003o\u00012!PA\u001d\u0013\r\tYd\n\u0002\u0016\u0007\",7m\u001b9pS:$h)\u001b7f\u001b\u0006t\u0017mZ3s\u000311\u0017\u000e\\3NC:\fw-\u001a:!\u0003A\u0011\u0017\r^2i\r&dWm\u001d$jYR,'/\u0006\u0002\u0002DI1\u0011QIA%\u000332Q!\u001d\b\u0001\u0003\u0007\n\u0011CY1uG\"4\u0015\u000e\\3t\r&dG/\u001a:!!\u0011\tY%!\u0016\u000e\u0005\u00055#\u0002BA(\u0003#\nA\u0001\\1oO*\u0011\u00111K\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002X\u00055#AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002$\u0005m\u0013\u0002BA/\u0003K\u0011!\u0002U1uQ\u001aKG\u000e^3s\u00035\u0011\u0017\r^2i\u0013\u0012$v\u000eU1uQR!\u0011\u0011EA2\u0011\u001d\t)g\u0004a\u0001\u0003O\nqAY1uG\"LE\rE\u00028\u0003SJ1!a\u001b9\u0005\u0011auN\\4\u0002\u001bA\fG\u000f\u001b+p\u0005\u0006$8\r[%e)\u0011\t9'!\u001d\t\rM\u0003\u0002\u0019AA\u0011\u0003-I7OQ1uG\"4\u0015\u000e\\3\u0015\t\u0005]\u0014Q\u0010\t\u0004o\u0005e\u0014bAA>q\t9!i\\8mK\u0006t\u0007BB*\u0012\u0001\u0004\t\t#A\u0005tKJL\u0017\r\\5{KR1\u00111QAE\u0003\u001b\u00032aNAC\u0013\r\t9\t\u000f\u0002\u0005+:LG\u000f\u0003\u0004\u0002\fJ\u0001\r\u0001Q\u0001\t[\u0016$\u0018\rZ1uC\"9\u0011q\u0012\nA\u0002\u0005E\u0015aA8viB!\u00111SAM\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006E\u0013AA5p\u0013\u0011\tY*!&\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004\u0001\u0006\u0005\u0006bBAR'\u0001\u0007\u0011QU\u0001\u0003S:\u0004B!a%\u0002(&!\u0011\u0011VAK\u0005-Ie\u000e];u'R\u0014X-Y7\u0002\u0007\u0005$G\r\u0006\u0004\u0002x\u0005=\u0016\u0011\u0017\u0005\b\u0003K\"\u0002\u0019AA4\u0011\u0019\tY\t\u0006a\u0001\u0001\u0006\u0019q-\u001a;\u0015\t\u0005]\u0016Q\u0018\t\u0005o\u0005e\u0006)C\u0002\u0002<b\u0012aa\u00149uS>t\u0007bBA3+\u0001\u0007\u0011qM\u0001\u0017CB\u0004H.\u001f$o)>\u0014\u0015\r^2i\u0005f\u001cFO]3b[V!\u00111YAe)\u0011\t)-a8\u0015\t\u0005\u001d\u0017Q\u001b\t\u0004\u0003\u0006%GaBAf-\t\u0007\u0011Q\u001a\u0002\u0004%\u0016#\u0016cA#\u0002PB\u0019q'!5\n\u0007\u0005M\u0007HA\u0002B]fDq!a6\u0017\u0001\u0004\tI.\u0001\u0002g]B9q'a7\u0002&\u0006\u001d\u0017bAAoq\tIa)\u001e8di&|g.\r\u0005\b\u0003K2\u0002\u0019AA4\u0003M\tG\r\u001a(fo\n\u000bGo\u00195CsN#(/Z1n)\u0011\t)/a;\u0015\t\u0005]\u0014q\u001d\u0005\b\u0003/<\u0002\u0019AAu!\u001d9\u00141\\AI\u0003\u0007Cq!!\u001a\u0018\u0001\u0004\t9\u0007\u0006\u0004\u0002p\u0006m(\u0011\u0001\t\u0006o\u0005E\u0018Q_\u0005\u0004\u0003gD$!B!se\u0006L\bCB\u001c\u0002x\u0006\u001d\u0004)C\u0002\u0002zb\u0012a\u0001V;qY\u0016\u0014\u0004bBA\u007f1\u0001\u0007\u0011q`\u0001\bgR\f'\u000f^%e!\u00159\u0014\u0011XA4\u0011\u001d\u0011\u0019\u0001\u0007a\u0001\u0003\u007f\fQ!\u001a8e\u0013\u0012\f\u0001cZ3u\u0019\u0006$Xm\u001d;CCR\u001c\u0007.\u00133\u0015\u0005\u0005}\u0018!C4fi2\u000bG/Z:u)\t\u0011i\u0001E\u00038\u0003s\u000b)0\u0001\u000bhKR|%\u000fZ3sK\u0012\u0014\u0015\r^2i\r&dWm\u001d\u000b\u0003\u0005'\u0001RaNAy\u0005+\u0001B!a\t\u0003\u0018%!!\u0011DA\u0013\u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\u0012Y\u0006\u001cH\u000fU;sO\u0016$')\u0019;dQ&#WCAA4\u0003Ua\u0017m\u001d;QkJ<W\r\u001a\"bi\u000eD\u0017\nZ0%KF$B!a!\u0003$!I!QE\u000f\u0002\u0002\u0003\u0007\u0011qM\u0001\u0004q\u0012\n\u0014A\u00057bgR\u0004VO]4fI\n\u000bGo\u00195JI\u0002\nQ\u0001];sO\u0016$B!a!\u0003.!9!qF\u0010A\u0002\u0005\u001d\u0014\u0001\u0005;ie\u0016\u001c\bn\u001c7e\u0005\u0006$8\r[%e\u0003)\u0001XO]4f\u0003\u001a$XM\u001d\u000b\u0005\u0003\u0007\u0013)\u0004C\u0004\u00030\u0001\u0002\r!a\u001a\u0002\u001fY\fG.\u001b3bi\u00164VM]:j_:$bAa\u000f\u0003B\t\u0015\u0003cA\u001c\u0003>%\u0019!q\b\u001d\u0003\u0007%sG\u000f\u0003\u0004\u0003D\u0005\u0002\r\u0001V\u0001\u0005i\u0016DH\u000fC\u0004\u0003H\u0005\u0002\rAa\u000f\u0002'5\f\u0007pU;qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8\u0002\u001f!#eiU'fi\u0006$\u0017\r^1M_\u001e\u0004\"!P\u0012\u0014\u0005\r2DC\u0001B&\u000391XM]5gs\n\u000bGo\u00195JIN$\u0002\"a!\u0003V\t-$Q\u000e\u0005\b\u0005/*\u0003\u0019\u0001B-\u0003!\u0011\u0017\r^2i\u0013\u0012\u001c\bC\u0002B.\u0005K\n9G\u0004\u0003\u0003^\t\u0005dbA,\u0003`%\t\u0011(C\u0002\u0003da\nq\u0001]1dW\u0006<W-\u0003\u0003\u0003h\t%$aA*fc*\u0019!1\r\u001d\t\u000f\u0005uX\u00051\u0001\u0002\u0000\"9!1A\u0013A\u0002\u0005}\b")
public class HDFSMetadataLog<T>
implements MetadataLog<T>,
Logging {
    private final String path;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final Path metadataPath;
    private final CheckpointFileManager fileManager;
    private final PathFilter batchFilesFilter;
    private long lastPurgedBatchId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void verifyBatchIds(Seq<Object> seq, Option<Object> option, Option<Object> option2) {
        HDFSMetadataLog$.MODULE$.verifyBatchIds(seq, option, option2);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public Path metadataPath() {
        return this.metadataPath;
    }

    public CheckpointFileManager fileManager() {
        return this.fileManager;
    }

    public PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    public Path batchIdToPath(long batchId) {
        return new Path(this.metadataPath(), Long.toString(batchId));
    }

    public long pathToBatchId(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void serialize(T metadata, OutputStream out) {
        Serialization$.MODULE$.write(metadata, out, this.formats());
    }

    public T deserialize(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return (T)Serialization$.MODULE$.read((Reader)reader, this.formats(), this.manifest());
    }

    @Override
    public boolean add(long batchId, T metadata) {
        Predef$.MODULE$.require(metadata != null, (Function0 & Serializable & scala.Serializable)() -> "'null' metadata cannot written to a metadata log");
        return this.addNewBatchByStream(batchId, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)output -> {
            this.serialize(metadata, output);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Option<T> get(long batchId) {
        Option option;
        try {
            option = (Option)this.applyFnToBatchByStream(batchId, (Function1 & Serializable & scala.Serializable)input -> new Some(this.deserialize((InputStream)input)));
        }
        catch (FileNotFoundException fne) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> fne.getMessage());
            option = None$.MODULE$;
        }
        return option;
    }

    public <RET> RET applyFnToBatchByStream(long batchId, Function1<InputStream, RET> fn) {
        Object object;
        block6: {
            Path batchMetadataFile = this.batchIdToPath(batchId);
            if (this.fileManager().exists(batchMetadataFile)) {
                FSDataInputStream input = this.fileManager().open(batchMetadataFile);
                try {
                    try {
                        object = fn.apply((Object)input);
                        break block6;
                    }
                    catch (IllegalStateException ise) {
                        throw new IllegalStateException(new StringBuilder(26).append("Failed to read log file ").append(batchMetadataFile).append(". ").append(ise.getMessage()).toString(), ise);
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)input);
                }
            }
            throw QueryExecutionErrors$.MODULE$.batchMetadataFileNotFoundError(batchMetadataFile);
        }
        return (RET)object;
    }

    public boolean addNewBatchByStream(long batchId, Function1<OutputStream, BoxedUnit> fn) {
        return BoxesRunTime.unboxToBoolean((Object)this.get(batchId).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HDFSMetadataLog.$anonfun$addNewBatchByStream$1(x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            CheckpointFileManager.CancellableFSDataOutputStream output = this.fileManager().createAtomic(this.batchIdToPath(batchId), false);
            try {
                fn.apply((Object)output);
                output.close();
            }
            catch (FileAlreadyExistsException e) {
                throw QueryExecutionErrors$.MODULE$.multiStreamingQueriesUsingPathConcurrentlyError($this.path, e);
            }
            finally {
                output.cancel();
            }
            return true;
        }));
    }

    @Override
    public Tuple2<Object, T>[] get(Option<Object> startId, Option<Object> endId) {
        Predef$.MODULE$.assert(startId.isEmpty() || endId.isEmpty() || BoxesRunTime.unboxToLong((Object)startId.get()) <= BoxesRunTime.unboxToLong((Object)endId.get()));
        FileStatus[] files = this.fileManager().list(this.metadataPath(), this.batchFilesFilter());
        long[] batchIds = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)batchId -> !(!endId.isEmpty() && batchId > BoxesRunTime.unboxToLong((Object)endId.get()) || !startId.isEmpty() && batchId < BoxesRunTime.unboxToLong((Object)startId.get()))))).sorted((Ordering)Ordering.Long$.MODULE$);
        HDFSMetadataLog$.MODULE$.verifyBatchIds((Seq<Object>)Predef$.MODULE$.wrapLongArray(batchIds), startId, endId);
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(batchIds)).map((Function1 & Serializable & scala.Serializable)batchId -> HDFSMetadataLog.$anonfun$get$5(this, BoxesRunTime.unboxToLong((Object)batchId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HDFSMetadataLog.$anonfun$get$6(x$2))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long batchId = tuple2._1$mcJ$sp();
            Option metadataOption = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), metadataOption.get());
            return tuple22;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public Option<Object> getLatestBatchId() {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sorted(Ordering.Long$.MODULE$.reverse()))).headOption();
    }

    @Override
    public Option<Tuple2<Object, T>> getLatest() {
        return this.getLatestBatchId().map((Function1 & Serializable & scala.Serializable)batchId -> HDFSMetadataLog.$anonfun$getLatest$1(this, BoxesRunTime.unboxToLong((Object)batchId)));
    }

    public FileStatus[] getOrderedBatchFiles() {
        return (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).sortBy((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (Ordering)Ordering.Long$.MODULE$))).reverse();
    }

    private long lastPurgedBatchId() {
        return this.lastPurgedBatchId;
    }

    private void lastPurgedBatchId_$eq(long x$1) {
        this.lastPurgedBatchId = x$1;
    }

    @Override
    public void purge(long thresholdBatchId) {
        NumericRange.Exclusive possibleTargetBatchIds = new RichLong(Predef$.MODULE$.longWrapper(this.lastPurgedBatchId() + 1L)).until((Object)BoxesRunTime.boxToLong((long)thresholdBatchId));
        if (possibleTargetBatchIds.length() <= 3) {
            possibleTargetBatchIds.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)batchId -> {
                Path path = this.batchIdToPath(batchId);
                this.fileManager().delete(path);
                this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Removed metadata log file: ").append(path).toString());
            });
        } else {
            long[] batchIds = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(batchIds)).withFilter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)batchId -> batchId < thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)batchId -> {
                Path path = this.batchIdToPath(batchId);
                this.fileManager().delete(path);
                this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Removed metadata log file: ").append(path).toString());
            });
        }
        this.lastPurgedBatchId_$eq(thresholdBatchId - 1L);
    }

    public void purgeAfter(long thresholdBatchId) {
        long[] batchIds = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(batchIds)).withFilter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)batchId -> batchId > thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)batchId -> {
            Path path = this.batchIdToPath(batchId);
            this.fileManager().delete(path);
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Removed metadata log file: ").append(path).toString());
        });
    }

    public int validateVersion(String text, int maxSupportedVersion) {
        return MetadataVersionUtil$.MODULE$.validateVersion(text, maxSupportedVersion);
    }

    public static final /* synthetic */ boolean $anonfun$addNewBatchByStream$1(Object x$1) {
        return false;
    }

    public static final /* synthetic */ Tuple2 $anonfun$get$5(HDFSMetadataLog $this, long batchId) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), $this.get(batchId));
    }

    public static final /* synthetic */ boolean $anonfun$get$6(Tuple2 x$2) {
        return ((Option)x$2._2()).isDefined();
    }

    public static final /* synthetic */ Tuple2 $anonfun$getLatest$1(HDFSMetadataLog $this, long batchId) {
        Object content = $this.get(batchId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(34).append("failed to read log file for batch ").append(batchId).toString());
        });
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), content);
    }

    public HDFSMetadataLog(SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.path = path;
        Logging.$init$((Logging)this);
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        Class clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.manifest())).runtimeClass();
        Class<Seq> clazz2 = Seq.class;
        Predef$.MODULE$.require(clazz == null ? clazz2 != null : !clazz.equals(clazz2), (Function0 & Serializable & scala.Serializable)() -> "Should not create a log with type Seq, use Arrays instead - see SPARK-17372");
        this.metadataPath = new Path(path);
        this.fileManager = CheckpointFileManager$.MODULE$.create(this.metadataPath(), sparkSession.sessionState().newHadoopConf());
        if (!this.fileManager().exists(this.metadataPath())) {
            this.fileManager().mkdirs(this.metadataPath());
        }
        this.batchFilesFilter = new PathFilter(this){
            private final /* synthetic */ HDFSMetadataLog $outer;

            public boolean accept(Path path) {
                return this.$outer.isBatchFile(path);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.lastPurgedBatchId = -1L;
    }
}

