/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.AggFunction;
import software.amazon.awssdk.services.glue.model.EnclosedInStringPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregateOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregateOperation> {
    private static final SdkField<List<String>> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Column").getter(AggregateOperation.getter(AggregateOperation::column)).setter(AggregateOperation.setter(Builder::column)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AGG_FUNC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggFunc").getter(AggregateOperation.getter(AggregateOperation::aggFuncAsString)).setter(AggregateOperation.setter(Builder::aggFunc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggFunc").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, AGG_FUNC_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> column;
    private final String aggFunc;

    private AggregateOperation(BuilderImpl builder) {
        this.column = builder.column;
        this.aggFunc = builder.aggFunc;
    }

    public final boolean hasColumn() {
        return this.column != null && !(this.column instanceof SdkAutoConstructList);
    }

    public final List<String> column() {
        return this.column;
    }

    public final AggFunction aggFunc() {
        return AggFunction.fromValue(this.aggFunc);
    }

    public final String aggFuncAsString() {
        return this.aggFunc;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumn() ? this.column() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aggFuncAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateOperation)) {
            return false;
        }
        AggregateOperation other = (AggregateOperation)obj;
        return this.hasColumn() == other.hasColumn() && Objects.equals(this.column(), other.column()) && Objects.equals(this.aggFuncAsString(), other.aggFuncAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AggregateOperation").add("Column", this.hasColumn() ? this.column() : null).add("AggFunc", (Object)this.aggFuncAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "AggFunc": {
                return Optional.ofNullable(clazz.cast(this.aggFuncAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregateOperation, T> g) {
        return obj -> g.apply((AggregateOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> column = DefaultSdkAutoConstructList.getInstance();
        private String aggFunc;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateOperation model) {
            this.column(model.column);
            this.aggFunc(model.aggFunc);
        }

        public final Collection<String> getColumn() {
            if (this.column instanceof SdkAutoConstructList) {
                return null;
            }
            return this.column;
        }

        public final void setColumn(Collection<String> column) {
            this.column = EnclosedInStringPropertiesCopier.copy(column);
        }

        @Override
        public final Builder column(Collection<String> column) {
            this.column = EnclosedInStringPropertiesCopier.copy(column);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder column(String ... column) {
            this.column(Arrays.asList(column));
            return this;
        }

        public final String getAggFunc() {
            return this.aggFunc;
        }

        public final void setAggFunc(String aggFunc) {
            this.aggFunc = aggFunc;
        }

        @Override
        public final Builder aggFunc(String aggFunc) {
            this.aggFunc = aggFunc;
            return this;
        }

        @Override
        public final Builder aggFunc(AggFunction aggFunc) {
            this.aggFunc(aggFunc == null ? null : aggFunc.toString());
            return this;
        }

        public AggregateOperation build() {
            return new AggregateOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregateOperation> {
        public Builder column(Collection<String> var1);

        public Builder column(String ... var1);

        public Builder aggFunc(String var1);

        public Builder aggFunc(AggFunction var1);
    }
}

