/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.RegistryId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRegistryRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, DeleteRegistryRequest> {
    private static final SdkField<RegistryId> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RegistryId").getter(DeleteRegistryRequest.getter(DeleteRegistryRequest::registryId)).setter(DeleteRegistryRequest.setter(Builder::registryId)).constructor(RegistryId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD));
    private final RegistryId registryId;

    private DeleteRegistryRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
    }

    public final RegistryId registryId() {
        return this.registryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRegistryRequest)) {
            return false;
        }
        DeleteRegistryRequest other = (DeleteRegistryRequest)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRegistryRequest").add("RegistryId", (Object)this.registryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRegistryRequest, T> g) {
        return obj -> g.apply((DeleteRegistryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private RegistryId registryId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRegistryRequest model) {
            super(model);
            this.registryId(model.registryId);
        }

        public final RegistryId.Builder getRegistryId() {
            return this.registryId != null ? this.registryId.toBuilder() : null;
        }

        public final void setRegistryId(RegistryId.BuilderImpl registryId) {
            this.registryId = registryId != null ? registryId.build() : null;
        }

        @Override
        public final Builder registryId(RegistryId registryId) {
            this.registryId = registryId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRegistryRequest build() {
            return new DeleteRegistryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRegistryRequest> {
        public Builder registryId(RegistryId var1);

        default public Builder registryId(Consumer<RegistryId.Builder> registryId) {
            return this.registryId((RegistryId)((RegistryId.Builder)RegistryId.builder().applyMutation(registryId)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

