/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import org.apache.amoro.api.config.Configurations;
import org.apache.amoro.client.AmsServerInfo;
import org.apache.amoro.properties.AmsHAProperties;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.shade.zookeeper3.org.apache.curator.RetryPolicy;
import org.apache.amoro.shade.zookeeper3.org.apache.curator.framework.CuratorFramework;
import org.apache.amoro.shade.zookeeper3.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.amoro.shade.zookeeper3.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.amoro.shade.zookeeper3.org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.amoro.shade.zookeeper3.org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.amoro.shade.zookeeper3.org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.CreateMode;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.amoro.utils.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighAvailabilityContainer
implements LeaderLatchListener {
    public static final Logger LOG = LoggerFactory.getLogger(HighAvailabilityContainer.class);
    private final LeaderLatch leaderLatch;
    private final CuratorFramework zkClient;
    private final String tableServiceMasterPath;
    private final String optimizingServiceMasterPath;
    private final AmsServerInfo tableServiceServerInfo;
    private final AmsServerInfo optimizingServiceServerInfo;
    private volatile CountDownLatch followerLath;

    public HighAvailabilityContainer(Configurations serviceConfig) throws Exception {
        if (serviceConfig.getBoolean(AmoroManagementConf.HA_ENABLE)) {
            String zkServerAddress = serviceConfig.getString(AmoroManagementConf.HA_ZOOKEEPER_ADDRESS);
            String haClusterName = serviceConfig.getString(AmoroManagementConf.HA_CLUSTER_NAME);
            this.tableServiceMasterPath = AmsHAProperties.getTableServiceMasterPath((String)haClusterName);
            this.optimizingServiceMasterPath = AmsHAProperties.getOptimizingServiceMasterPath((String)haClusterName);
            ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3, 5000);
            this.zkClient = CuratorFrameworkFactory.builder().connectString(zkServerAddress).sessionTimeoutMs(5000).connectionTimeoutMs(5000).retryPolicy((RetryPolicy)retryPolicy).build();
            this.zkClient.start();
            this.createPathIfNeeded(this.tableServiceMasterPath);
            this.createPathIfNeeded(this.optimizingServiceMasterPath);
            String leaderPath = AmsHAProperties.getLeaderPath((String)haClusterName);
            this.createPathIfNeeded(leaderPath);
            this.leaderLatch = new LeaderLatch(this.zkClient, leaderPath);
            this.leaderLatch.addListener((LeaderLatchListener)this);
            this.leaderLatch.start();
            this.tableServiceServerInfo = this.buildServerInfo(serviceConfig.getString(AmoroManagementConf.SERVER_EXPOSE_HOST), serviceConfig.getInteger(AmoroManagementConf.TABLE_SERVICE_THRIFT_BIND_PORT));
            this.optimizingServiceServerInfo = this.buildServerInfo(serviceConfig.getString(AmoroManagementConf.SERVER_EXPOSE_HOST), serviceConfig.getInteger(AmoroManagementConf.OPTIMIZING_SERVICE_THRIFT_BIND_PORT));
        } else {
            this.leaderLatch = null;
            this.zkClient = null;
            this.tableServiceMasterPath = null;
            this.optimizingServiceMasterPath = null;
            this.tableServiceServerInfo = null;
            this.optimizingServiceServerInfo = null;
            this.followerLath = new CountDownLatch(1);
        }
    }

    public void waitLeaderShip() throws Exception {
        LOG.info("Waiting to become the leader of AMS");
        if (this.leaderLatch != null) {
            this.leaderLatch.await();
            if (this.leaderLatch.hasLeadership()) {
                this.zkClient.setData().forPath(this.tableServiceMasterPath, JacksonUtil.toJSONString((Object)this.tableServiceServerInfo).getBytes(StandardCharsets.UTF_8));
                this.zkClient.setData().forPath(this.optimizingServiceMasterPath, JacksonUtil.toJSONString((Object)this.optimizingServiceServerInfo).getBytes(StandardCharsets.UTF_8));
            }
        }
        LOG.info("Became the leader of AMS");
    }

    public void waitFollowerShip() throws Exception {
        LOG.info("Waiting to become the follower of AMS");
        if (this.followerLath != null) {
            this.followerLath.await();
        }
        LOG.info("Became the follower of AMS");
    }

    public void close() {
        if (this.leaderLatch != null) {
            try {
                this.zkClient.close();
                this.leaderLatch.close();
            }
            catch (IOException e) {
                LOG.error("Close high availability services failed", (Throwable)e);
            }
        }
    }

    public void isLeader() {
        LOG.info("Table service server {} and optimizing service server {} got leadership", (Object)this.tableServiceServerInfo.toString(), (Object)this.optimizingServiceServerInfo.toString());
        this.followerLath = new CountDownLatch(1);
    }

    public void notLeader() {
        LOG.info("Table service server {} and optimizing service server {} lost leadership", (Object)this.tableServiceServerInfo.toString(), (Object)this.optimizingServiceServerInfo.toString());
        this.followerLath.countDown();
    }

    private AmsServerInfo buildServerInfo(String host, int port) {
        AmsServerInfo amsServerInfo = new AmsServerInfo();
        amsServerInfo.setHost(host);
        amsServerInfo.setThriftBindPort(Integer.valueOf(port));
        return amsServerInfo;
    }

    private void createPathIfNeeded(String path) throws Exception {
        try {
            ((ACLBackgroundPathAndBytesable)this.zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(path);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }
}

