/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.catalog;

import java.util.List;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.TableIDWithFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.server.exception.IllegalMetadataException;
import org.apache.amoro.server.persistence.PersistentBase;
import org.apache.amoro.server.persistence.mapper.CatalogMetaMapper;

public abstract class ServerCatalog
extends PersistentBase {
    private volatile CatalogMeta metadata;

    protected ServerCatalog(CatalogMeta metadata) {
        this.metadata = metadata;
    }

    public String name() {
        return this.metadata.getCatalogName();
    }

    public CatalogMeta getMetadata() {
        return this.metadata;
    }

    public void updateMetadata(CatalogMeta metadata) {
        this.doAs(CatalogMetaMapper.class, mapper -> mapper.updateCatalog(metadata));
        this.metadata = metadata;
    }

    public abstract boolean databaseExists(String var1);

    public abstract boolean tableExists(String var1, String var2);

    public abstract List<String> listDatabases();

    public abstract List<TableIDWithFormat> listTables();

    public abstract List<TableIDWithFormat> listTables(String var1);

    public abstract AmoroTable<?> loadTable(String var1, String var2);

    public void dispose() {
        this.doAsTransaction(() -> this.doAsExisted(CatalogMetaMapper.class, mapper -> mapper.deleteCatalog(this.name()), () -> new IllegalMetadataException("Catalog " + this.name() + " has more than one database or table")));
    }
}

