/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.amoro.server.exception.AmoroRuntimeException;
import org.apache.amoro.server.exception.PersistenceException;
import org.apache.amoro.server.persistence.NestedSqlSession;
import org.apache.amoro.server.persistence.SqlSessionFactoryProvider;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.ibatis.session.TransactionIsolationLevel;

public abstract class PersistentBase {
    protected PersistentBase() {
    }

    @VisibleForTesting
    protected NestedSqlSession beginSession() {
        return NestedSqlSession.openSession(() -> SqlSessionFactoryProvider.getInstance().get().openSession(TransactionIsolationLevel.READ_COMMITTED));
    }

    protected final <T> void doAs(Class<T> mapperClz, Consumer<T> consumer) {
        try (NestedSqlSession session = this.beginSession();){
            try {
                T mapper = PersistentBase.getMapper(session, mapperClz);
                consumer.accept(mapper);
                session.commit();
            }
            catch (Throwable t) {
                session.rollback();
                throw AmoroRuntimeException.wrap(t, PersistenceException::new);
            }
        }
    }

    protected final void doAsTransaction(Runnable ... operations) {
        try (NestedSqlSession session = this.beginSession();){
            try {
                Arrays.stream(operations).forEach(Runnable::run);
                session.commit();
            }
            catch (Throwable t) {
                session.rollback();
                throw AmoroRuntimeException.wrap(t, PersistenceException::new);
            }
        }
    }

    protected final <T, R> R getAs(Class<T> mapperClz, Function<T, R> func) {
        Throwable throwable = null;
        try (NestedSqlSession session = this.beginSession();){
            T mapper = PersistentBase.getMapper(session, mapperClz);
            R r = func.apply(mapper);
            return r;
        }
        catch (Throwable t) {
            try {
                throw AmoroRuntimeException.wrap(t, PersistenceException::new);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected final <T> void doAsExisted(Class<T> mapperClz, Function<T, Integer> func, Supplier<? extends AmoroRuntimeException> errorSupplier) {
        try (NestedSqlSession session = this.beginSession();){
            try {
                int result = func.apply(PersistentBase.getMapper(session, mapperClz));
                if (result == 0) {
                    throw errorSupplier.get();
                }
                session.commit();
            }
            catch (Throwable t) {
                session.rollback();
                throw AmoroRuntimeException.wrap(t, PersistenceException::new);
            }
        }
    }

    protected static <T> T getMapper(NestedSqlSession sqlSession, Class<T> type) {
        Preconditions.checkNotNull((Object)sqlSession);
        return (T)sqlSession.getSqlSession().getMapper(type);
    }
}

