/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.NoSuchTableException;
import org.apache.amoro.TableFormat;
import org.apache.amoro.TableIDWithFormat;
import org.apache.amoro.api.BlockableOperation;
import org.apache.amoro.api.Blocker;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.api.TableIdentifier;
import org.apache.amoro.api.config.Configurations;
import org.apache.amoro.api.config.TableConfiguration;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.catalog.CatalogBuilder;
import org.apache.amoro.server.catalog.ExternalCatalog;
import org.apache.amoro.server.catalog.InternalCatalog;
import org.apache.amoro.server.catalog.ServerCatalog;
import org.apache.amoro.server.exception.AlreadyExistsException;
import org.apache.amoro.server.exception.IllegalMetadataException;
import org.apache.amoro.server.exception.ObjectNotExistsException;
import org.apache.amoro.server.manager.MetricManager;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.persistence.StatedPersistentBase;
import org.apache.amoro.server.persistence.mapper.CatalogMetaMapper;
import org.apache.amoro.server.persistence.mapper.TableMetaMapper;
import org.apache.amoro.server.table.RuntimeHandlerChain;
import org.apache.amoro.server.table.TableMetadata;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.server.table.blocker.TableBlocker;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.shade.guava32.com.google.common.base.Objects;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.shade.guava32.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableService
extends StatedPersistentBase
implements TableService {
    public static final Logger LOG = LoggerFactory.getLogger(DefaultTableService.class);
    private final long externalCatalogRefreshingInterval;
    private final long blockerTimeout;
    private final Map<String, InternalCatalog> internalCatalogMap = new ConcurrentHashMap<String, InternalCatalog>();
    private final Map<String, ExternalCatalog> externalCatalogMap = new ConcurrentHashMap<String, ExternalCatalog>();
    private final Map<ServerTableIdentifier, TableRuntime> tableRuntimeMap = new ConcurrentHashMap<ServerTableIdentifier, TableRuntime>();
    private final ScheduledExecutorService tableExplorerScheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("table-explorer-scheduler-%d").setDaemon(true).build());
    private final CompletableFuture<Boolean> initialized = new CompletableFuture();
    private final Configurations serverConfiguration;
    private RuntimeHandlerChain headHandler;
    private ExecutorService tableExplorerExecutors;

    public DefaultTableService(Configurations configuration) {
        this.externalCatalogRefreshingInterval = configuration.getLong(AmoroManagementConf.REFRESH_EXTERNAL_CATALOGS_INTERVAL);
        this.blockerTimeout = configuration.getLong(AmoroManagementConf.BLOCKER_TIMEOUT);
        this.serverConfiguration = configuration;
    }

    @Override
    public List<CatalogMeta> listCatalogMetas() {
        this.checkStarted();
        List<CatalogMeta> catalogs = this.internalCatalogMap.values().stream().map(ServerCatalog::getMetadata).collect(Collectors.toList());
        catalogs.addAll(this.externalCatalogMap.values().stream().map(ServerCatalog::getMetadata).collect(Collectors.toList()));
        return catalogs;
    }

    @Override
    public CatalogMeta getCatalogMeta(String catalogName) {
        this.checkStarted();
        ServerCatalog catalog = this.getServerCatalog(catalogName);
        return catalog.getMetadata();
    }

    @Override
    public boolean catalogExist(String catalogName) {
        this.checkStarted();
        return this.internalCatalogMap.containsKey(catalogName) || this.externalCatalogMap.containsKey(catalogName);
    }

    @Override
    public ServerCatalog getServerCatalog(String catalogName) {
        ServerCatalog catalog = Optional.ofNullable((ServerCatalog)this.internalCatalogMap.get(catalogName)).orElse(this.externalCatalogMap.get(catalogName));
        return Optional.ofNullable(catalog).orElseThrow(() -> new ObjectNotExistsException("Catalog " + catalogName));
    }

    @Override
    public InternalCatalog getInternalCatalog(String catalogName) {
        return Optional.ofNullable(this.internalCatalogMap.get(catalogName)).orElseThrow(() -> new ObjectNotExistsException("Catalog " + catalogName));
    }

    @Override
    public void createCatalog(CatalogMeta catalogMeta) {
        this.checkStarted();
        if (this.catalogExist(catalogMeta.getCatalogName())) {
            throw new AlreadyExistsException("Catalog " + catalogMeta.getCatalogName());
        }
        this.doAsTransaction(() -> this.doAs(CatalogMetaMapper.class, mapper -> mapper.insertCatalog(catalogMeta)), () -> this.initServerCatalog(catalogMeta));
    }

    private void initServerCatalog(CatalogMeta catalogMeta) {
        ServerCatalog catalog = CatalogBuilder.buildServerCatalog(catalogMeta, this.serverConfiguration);
        if (catalog instanceof InternalCatalog) {
            this.internalCatalogMap.put(catalogMeta.getCatalogName(), (InternalCatalog)catalog);
        } else {
            this.externalCatalogMap.put(catalogMeta.getCatalogName(), (ExternalCatalog)catalog);
        }
    }

    @Override
    public void dropCatalog(String catalogName) {
        this.checkStarted();
        ServerCatalog serverCatalog = this.getServerCatalog(catalogName);
        if (serverCatalog == null) {
            throw new ObjectNotExistsException("Catalog " + catalogName);
        }
        serverCatalog.dispose();
        this.internalCatalogMap.remove(catalogName);
        this.externalCatalogMap.remove(catalogName);
    }

    @Override
    public void updateCatalog(CatalogMeta catalogMeta) {
        this.checkStarted();
        ServerCatalog catalog = this.getServerCatalog(catalogMeta.getCatalogName());
        this.validateCatalogUpdate(catalog.getMetadata(), catalogMeta);
        this.doAs(CatalogMetaMapper.class, mapper -> mapper.updateCatalog(catalogMeta));
        catalog.updateMetadata(catalogMeta);
    }

    @Override
    public void dropTableMetadata(TableIdentifier tableIdentifier, boolean deleteData) {
        String table;
        String database;
        this.checkStarted();
        if (StringUtils.isBlank((String)tableIdentifier.getTableName())) {
            throw new IllegalMetadataException("table name is blank");
        }
        if (StringUtils.isBlank((String)tableIdentifier.getCatalog())) {
            throw new IllegalMetadataException("catalog is blank");
        }
        if (StringUtils.isBlank((String)tableIdentifier.getDatabase())) {
            throw new IllegalMetadataException("database is blank");
        }
        InternalCatalog internalCatalog = this.getInternalCatalog(tableIdentifier.getCatalog());
        if (!internalCatalog.tableExists(database = tableIdentifier.getDatabase(), table = tableIdentifier.getTableName())) {
            throw new ObjectNotExistsException(tableIdentifier);
        }
        ServerTableIdentifier serverTableIdentifier = internalCatalog.dropTable(database, table);
        Optional.ofNullable(this.tableRuntimeMap.remove(serverTableIdentifier)).ifPresent(tableRuntime -> {
            if (this.headHandler != null) {
                this.headHandler.fireTableRemoved((TableRuntime)tableRuntime);
            }
            tableRuntime.dispose();
        });
    }

    @Override
    public void createTable(String catalogName, TableMetadata tableMetadata) {
        this.checkStarted();
        InternalCatalog catalog = this.getInternalCatalog(catalogName);
        String database = tableMetadata.getTableIdentifier().getDatabase();
        String table = tableMetadata.getTableIdentifier().getTableName();
        if (catalog.tableExists(database, table)) {
            throw new AlreadyExistsException(tableMetadata.getTableIdentifier().getIdentifier());
        }
        TableMetadata metadata = catalog.createTable(tableMetadata);
        this.triggerTableAdded(catalog, metadata.getTableIdentifier());
    }

    @Override
    public List<ServerTableIdentifier> listManagedTables() {
        this.checkStarted();
        return this.getAs(TableMetaMapper.class, TableMetaMapper::selectAllTableIdentifiers);
    }

    @Override
    public AmoroTable<?> loadTable(ServerTableIdentifier tableIdentifier) {
        this.checkStarted();
        return this.getServerCatalog(tableIdentifier.getCatalog()).loadTable(tableIdentifier.getDatabase(), tableIdentifier.getTableName());
    }

    @Override
    public Blocker block(TableIdentifier tableIdentifier, List<BlockableOperation> operations, Map<String, String> properties) {
        this.checkStarted();
        return this.getAndCheckExist(this.getOrSyncServerTableIdentifier(tableIdentifier)).block(operations, properties, this.blockerTimeout).buildBlocker();
    }

    @Override
    public void releaseBlocker(TableIdentifier tableIdentifier, String blockerId) {
        this.checkStarted();
        TableRuntime tableRuntime = this.getRuntime(this.getServerTableIdentifier(tableIdentifier));
        if (tableRuntime != null) {
            tableRuntime.release(blockerId);
        }
    }

    @Override
    public long renewBlocker(TableIdentifier tableIdentifier, String blockerId) {
        this.checkStarted();
        TableRuntime tableRuntime = this.getAndCheckExist(this.getServerTableIdentifier(tableIdentifier));
        return tableRuntime.renew(blockerId, this.blockerTimeout);
    }

    @Override
    public List<Blocker> getBlockers(TableIdentifier tableIdentifier) {
        this.checkStarted();
        return this.getAndCheckExist(this.getOrSyncServerTableIdentifier(tableIdentifier)).getBlockers().stream().map(TableBlocker::buildBlocker).collect(Collectors.toList());
    }

    @Override
    public void addHandlerChain(RuntimeHandlerChain handler) {
        this.checkNotStarted();
        if (this.headHandler == null) {
            this.headHandler = handler;
        } else {
            this.headHandler.appendNext(handler);
        }
    }

    @Override
    public void handleTableChanged(TableRuntime tableRuntime, OptimizingStatus originalStatus) {
        if (this.headHandler != null) {
            this.headHandler.fireStatusChanged(tableRuntime, originalStatus);
        }
    }

    @Override
    public void handleTableChanged(TableRuntime tableRuntime, TableConfiguration originalConfig) {
        if (this.headHandler != null) {
            this.headHandler.fireConfigChanged(tableRuntime, originalConfig);
        }
    }

    @Override
    public void initialize() {
        this.checkNotStarted();
        List catalogMetas = this.getAs(CatalogMetaMapper.class, CatalogMetaMapper::getCatalogs);
        catalogMetas.forEach(this::initServerCatalog);
        List tableRuntimeMetaList = this.getAs(TableMetaMapper.class, TableMetaMapper::selectTableRuntimeMetas);
        tableRuntimeMetaList.forEach(tableRuntimeMeta -> {
            TableRuntime tableRuntime = tableRuntimeMeta.constructTableRuntime(this);
            this.tableRuntimeMap.put(tableRuntime.getTableIdentifier(), tableRuntime);
            tableRuntime.registerMetric(MetricManager.getInstance().getGlobalRegistry());
        });
        if (this.headHandler != null) {
            this.headHandler.initialize(tableRuntimeMetaList);
        }
        if (this.tableExplorerExecutors == null) {
            int threadCount = this.serverConfiguration.getInteger(AmoroManagementConf.REFRESH_EXTERNAL_CATALOGS_THREAD_COUNT);
            int queueSize = this.serverConfiguration.getInteger(AmoroManagementConf.REFRESH_EXTERNAL_CATALOGS_QUEUE_SIZE);
            this.tableExplorerExecutors = new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadFactoryBuilder().setNameFormat("table-explorer-executor-%d").setDaemon(true).build());
        }
        this.tableExplorerScheduler.scheduleAtFixedRate(this::exploreExternalCatalog, 0L, this.externalCatalogRefreshingInterval, TimeUnit.MILLISECONDS);
        this.initialized.complete(true);
    }

    private TableRuntime getAndCheckExist(ServerTableIdentifier tableIdentifier) {
        Preconditions.checkArgument((tableIdentifier != null ? 1 : 0) != 0, (Object)"tableIdentifier cannot be null");
        TableRuntime tableRuntime = this.getRuntime(tableIdentifier);
        if (tableRuntime == null) {
            throw new ObjectNotExistsException(tableIdentifier);
        }
        return tableRuntime;
    }

    @Override
    public ServerTableIdentifier getServerTableIdentifier(TableIdentifier id) {
        return this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableIdentifier(id.getCatalog(), id.getDatabase(), id.getTableName()));
    }

    private ServerTableIdentifier getOrSyncServerTableIdentifier(TableIdentifier id) {
        ServerTableIdentifier serverTableIdentifier = this.getServerTableIdentifier(id);
        if (serverTableIdentifier != null) {
            return serverTableIdentifier;
        }
        ServerCatalog serverCatalog = this.getServerCatalog(id.getCatalog());
        if (serverCatalog instanceof InternalCatalog) {
            return null;
        }
        try {
            AmoroTable<?> table = serverCatalog.loadTable(id.database, id.getTableName());
            TableIdentity identity = new TableIdentity(id.getDatabase(), id.getTableName(), table.format());
            this.syncTable((ExternalCatalog)serverCatalog, identity);
            return this.getServerTableIdentifier(id);
        }
        catch (NoSuchTableException e) {
            return null;
        }
    }

    @Override
    public TableRuntime getRuntime(ServerTableIdentifier tableIdentifier) {
        this.checkStarted();
        return this.tableRuntimeMap.get(tableIdentifier);
    }

    @Override
    public boolean contains(ServerTableIdentifier tableIdentifier) {
        this.checkStarted();
        return this.tableRuntimeMap.containsKey(tableIdentifier);
    }

    public void dispose() {
        this.tableExplorerScheduler.shutdown();
        if (this.tableExplorerExecutors != null) {
            this.tableExplorerExecutors.shutdown();
        }
        if (this.headHandler != null) {
            this.headHandler.dispose();
        }
    }

    @VisibleForTesting
    void exploreExternalCatalog() {
        long start = System.currentTimeMillis();
        LOG.info("Syncing external catalogs: {}", (Object)String.join((CharSequence)",", this.externalCatalogMap.keySet()));
        for (ExternalCatalog externalCatalog : this.externalCatalogMap.values()) {
            try {
                ArrayList tableIdentifiersFutures = Lists.newArrayList();
                externalCatalog.listDatabases().forEach(database -> {
                    try {
                        tableIdentifiersFutures.add(CompletableFuture.supplyAsync(() -> {
                            try {
                                return externalCatalog.listTables((String)database).stream().map(TableIdentity::new).collect(Collectors.toSet());
                            }
                            catch (Exception e) {
                                LOG.error("TableExplorer list tables in database {} error", database, (Object)e);
                                return new HashSet();
                            }
                        }, this.tableExplorerExecutors));
                    }
                    catch (RejectedExecutionException e) {
                        LOG.error("The queue of table explorer is full, please increase the queue size or thread count.");
                    }
                });
                Set tableIdentifiers = tableIdentifiersFutures.stream().map(CompletableFuture::join).reduce((a, b) -> {
                    a.addAll(b);
                    return a;
                }).orElse(Sets.newHashSet());
                LOG.info("Loaded {} tables from external catalog {}.", (Object)tableIdentifiers.size(), (Object)externalCatalog.name());
                Map<TableIdentity, ServerTableIdentifier> serverTableIdentifiers = this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableIdentifiersByCatalog(externalCatalog.name())).stream().collect(Collectors.toMap(TableIdentity::new, tableIdentifier -> tableIdentifier));
                LOG.info("Loaded {} tables from Amoro server catalog {}.", (Object)serverTableIdentifiers.size(), (Object)externalCatalog.name());
                ArrayList taskFutures = Lists.newArrayList();
                Sets.difference((Set)tableIdentifiers, serverTableIdentifiers.keySet()).forEach(tableIdentity -> {
                    try {
                        taskFutures.add(CompletableFuture.runAsync(() -> {
                            try {
                                this.syncTable(externalCatalog, (TableIdentity)tableIdentity);
                            }
                            catch (Exception e) {
                                LOG.error("TableExplorer sync table {} error", (Object)tableIdentity.toString(), (Object)e);
                            }
                        }, this.tableExplorerExecutors));
                    }
                    catch (RejectedExecutionException e) {
                        LOG.error("The queue of table explorer is full, please increase the queue size or thread count.");
                    }
                });
                Sets.difference(serverTableIdentifiers.keySet(), (Set)tableIdentifiers).forEach(tableIdentity -> {
                    try {
                        taskFutures.add(CompletableFuture.runAsync(() -> {
                            try {
                                this.disposeTable((ServerTableIdentifier)serverTableIdentifiers.get(tableIdentity));
                            }
                            catch (Exception e) {
                                LOG.error("TableExplorer dispose table {} error", (Object)tableIdentity.toString(), (Object)e);
                            }
                        }, this.tableExplorerExecutors));
                    }
                    catch (RejectedExecutionException e) {
                        LOG.error("The queue of table explorer is full, please increase the queue size or thread count.");
                    }
                });
                taskFutures.forEach(CompletableFuture::join);
            }
            catch (Throwable e) {
                LOG.error("TableExplorer error", e);
            }
        }
        Set catalogNames = this.listCatalogMetas().stream().map(CatalogMeta::getCatalogName).collect(Collectors.toSet());
        for (TableRuntime tableRuntime : this.tableRuntimeMap.values()) {
            if (catalogNames.contains(tableRuntime.getTableIdentifier().getCatalog())) continue;
            this.disposeTable(tableRuntime.getTableIdentifier());
        }
        long l = System.currentTimeMillis();
        LOG.info("Syncing external catalogs took {} ms.", (Object)(l - start));
    }

    private void validateCatalogUpdate(CatalogMeta oldMeta, CatalogMeta newMeta) {
        if (!oldMeta.getCatalogType().equals(newMeta.getCatalogType())) {
            throw new IllegalMetadataException("Cannot update catalog type");
        }
    }

    private void checkStarted() {
        try {
            this.initialized.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkNotStarted() {
        if (this.initialized.isDone()) {
            throw new IllegalStateException("Table service has started.");
        }
    }

    private void syncTable(ExternalCatalog externalCatalog, TableIdentity tableIdentity) {
        AtomicBoolean tableRuntimeAdded = new AtomicBoolean(false);
        try {
            this.doAsTransaction(() -> externalCatalog.syncTable(tableIdentity.getDatabase(), tableIdentity.getTableName(), tableIdentity.getFormat()), () -> {
                ServerTableIdentifier tableIdentifier = externalCatalog.getServerTableIdentifier(tableIdentity.getDatabase(), tableIdentity.getTableName());
                tableRuntimeAdded.set(this.triggerTableAdded(externalCatalog, tableIdentifier));
            });
        }
        catch (Throwable t) {
            if (tableRuntimeAdded.get()) {
                this.revertTableRuntimeAdded(externalCatalog, tableIdentity);
            }
            throw t;
        }
    }

    private boolean triggerTableAdded(ServerCatalog catalog, ServerTableIdentifier serverTableIdentifier) {
        AmoroTable<?> table = catalog.loadTable(serverTableIdentifier.getDatabase(), serverTableIdentifier.getTableName());
        if (TableFormat.ICEBERG == table.format() && TablePropertyUtil.isMixedTableStore((Map)table.properties())) {
            return false;
        }
        TableRuntime tableRuntime = new TableRuntime(serverTableIdentifier, this, table.properties());
        this.tableRuntimeMap.put(serverTableIdentifier, tableRuntime);
        tableRuntime.registerMetric(MetricManager.getInstance().getGlobalRegistry());
        if (this.headHandler != null) {
            this.headHandler.fireTableAdded(table, tableRuntime);
        }
        return true;
    }

    private void revertTableRuntimeAdded(ExternalCatalog externalCatalog, TableIdentity tableIdentity) {
        ServerTableIdentifier tableIdentifier = externalCatalog.getServerTableIdentifier(tableIdentity.getDatabase(), tableIdentity.getTableName());
        if (tableIdentifier != null) {
            this.tableRuntimeMap.remove(tableIdentifier);
        }
    }

    private void disposeTable(ServerTableIdentifier tableIdentifier) {
        this.doAs(TableMetaMapper.class, mapper -> mapper.deleteTableIdByName(tableIdentifier.getCatalog(), tableIdentifier.getDatabase(), tableIdentifier.getTableName()));
        Optional.ofNullable(this.tableRuntimeMap.remove(tableIdentifier)).ifPresent(tableRuntime -> {
            if (this.headHandler != null) {
                this.headHandler.fireTableRemoved((TableRuntime)tableRuntime);
            }
            tableRuntime.dispose();
        });
    }

    private static class TableIdentity {
        private final String database;
        private final String tableName;
        private final TableFormat format;

        protected TableIdentity(TableIDWithFormat idWithFormat) {
            this.database = idWithFormat.getIdentifier().getDatabase();
            this.tableName = idWithFormat.getIdentifier().getTableName();
            this.format = idWithFormat.getTableFormat();
        }

        protected TableIdentity(ServerTableIdentifier serverTableIdentifier) {
            this.database = serverTableIdentifier.getDatabase();
            this.tableName = serverTableIdentifier.getTableName();
            this.format = serverTableIdentifier.getFormat();
        }

        protected TableIdentity(String database, String tableName, TableFormat format) {
            this.database = database;
            this.tableName = tableName;
            this.format = format;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getTableName() {
            return this.tableName;
        }

        public TableFormat getFormat() {
            return this.format;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableIdentity that = (TableIdentity)o;
            return Objects.equal((Object)this.database, (Object)that.database) && Objects.equal((Object)this.tableName, (Object)that.tableName);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.database, this.tableName});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("database", (Object)this.database).add("tableName", (Object)this.tableName).toString();
        }
    }
}

