/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.blocker;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.api.BlockableOperation;
import org.apache.amoro.api.Blocker;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;

public class TableBlocker {
    private ServerTableIdentifier tableIdentifier;
    private long blockerId;
    private List<String> operations;
    private long createTime;
    private long expirationTime;
    private Map<String, String> properties;

    public ServerTableIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public void setTableIdentifier(ServerTableIdentifier tableIdentifier) {
        this.tableIdentifier = tableIdentifier;
    }

    public long getBlockerId() {
        return this.blockerId;
    }

    public void setBlockerId(long blockerId) {
        this.blockerId = blockerId;
    }

    public List<String> getOperations() {
        return this.operations;
    }

    public void setOperations(List<String> operations) {
        this.operations = operations;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Blocker buildBlocker() {
        Map<Object, Object> properties = this.properties == null ? Maps.newHashMap() : this.properties;
        properties.put("create.time", this.createTime + "");
        properties.put("expiration.time", this.expirationTime + "");
        List operations = this.getOperations().stream().map(BlockableOperation::valueOf).collect(Collectors.toList());
        return new Blocker(this.blockerId + "", operations, properties);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableIdentifier", (Object)this.tableIdentifier).add("blockerId", this.blockerId).add("operations", this.operations).add("createTime", this.createTime).add("expirationTime", this.expirationTime).add("properties", this.properties).toString();
    }
}

