/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.executor;

import org.apache.amoro.server.persistence.PersistentBase;
import org.apache.amoro.server.persistence.mapper.TableBlockerMapper;
import org.apache.amoro.server.table.TableManager;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.executor.BaseTableExecutor;

public class BlockerExpiringExecutor
extends BaseTableExecutor {
    private final Persistency persistency = new Persistency();
    private static final long INTERVAL = 3600000L;

    public BlockerExpiringExecutor(TableManager tableManager) {
        super(tableManager, 1);
    }

    @Override
    protected long getNextExecutingTime(TableRuntime tableRuntime) {
        return 3600000L;
    }

    @Override
    protected boolean enabled(TableRuntime tableRuntime) {
        return true;
    }

    @Override
    protected void execute(TableRuntime tableRuntime) {
        try {
            this.persistency.doExpiring(tableRuntime);
        }
        catch (Throwable t) {
            this.logger.error("table {} expire blocker failed.", (Object)tableRuntime.getTableIdentifier(), (Object)t);
        }
    }

    private static class Persistency
    extends PersistentBase {
        private Persistency() {
        }

        public void doExpiring(TableRuntime tableRuntime) {
            this.doAs(TableBlockerMapper.class, mapper -> mapper.deleteExpiredBlockers(tableRuntime.getTableIdentifier(), System.currentTimeMillis()));
        }
    }
}

