/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.executor;

import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.hive.table.SupportHive;
import org.apache.amoro.hive.utils.HiveMetaSynchronizer;
import org.apache.amoro.hive.utils.TableTypeUtil;
import org.apache.amoro.server.table.TableManager;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.executor.BaseTableExecutor;
import org.apache.amoro.table.MixedTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCommitSyncExecutor
extends BaseTableExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(HiveCommitSyncExecutor.class);
    private static final long INTERVAL = 600000L;

    public HiveCommitSyncExecutor(TableManager tableRuntimes, int poolSize) {
        super(tableRuntimes, poolSize);
    }

    @Override
    protected long getNextExecutingTime(TableRuntime tableRuntime) {
        return 600000L;
    }

    @Override
    protected boolean enabled(TableRuntime tableRuntime) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(TableRuntime tableRuntime) {
        long startTime = System.currentTimeMillis();
        ServerTableIdentifier tableIdentifier = tableRuntime.getTableIdentifier();
        try {
            MixedTable mixedTable = (MixedTable)this.loadTable(tableRuntime).originalTable();
            if (!TableTypeUtil.isHive((MixedTable)mixedTable)) {
                LOG.debug("{} is not a support hive table", (Object)tableIdentifier);
                return;
            }
            LOG.info("{} start hive sync", (Object)tableIdentifier);
            HiveCommitSyncExecutor.syncIcebergToHive(mixedTable);
        }
        catch (Exception e) {
            LOG.error("{} hive sync failed", (Object)tableIdentifier, (Object)e);
        }
        finally {
            LOG.info("{} hive sync finished, cost {}ms", (Object)tableIdentifier, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    public static void syncIcebergToHive(MixedTable mixedTable) {
        HiveMetaSynchronizer.syncMixedTableDataToHive((SupportHive)((SupportHive)mixedTable));
    }
}

