/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.executor;

import java.util.Optional;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.table.TableManager;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.executor.BaseTableExecutor;

public class OptimizingCommitExecutor
extends BaseTableExecutor {
    private static final long INTERVAL = 60000L;

    public OptimizingCommitExecutor(TableManager tableRuntimes, int poolSize) {
        super(tableRuntimes, poolSize);
    }

    @Override
    protected long getNextExecutingTime(TableRuntime tableRuntime) {
        return 60000L;
    }

    @Override
    protected boolean enabled(TableRuntime tableRuntime) {
        return tableRuntime.getOptimizingStatus() == OptimizingStatus.COMMITTING;
    }

    @Override
    protected void execute(TableRuntime tableRuntime) {
        Optional.ofNullable(tableRuntime.getOptimizingProcess()).orElseThrow(() -> new IllegalStateException("OptimizingProcess is null while committing:" + tableRuntime)).commit();
    }

    @Override
    public void handleStatusChanged(TableRuntime tableRuntime, OptimizingStatus originalStatus) {
        this.scheduleIfNecessary(tableRuntime, this.getStartDelay());
    }

    @Override
    public void handleTableAdded(AmoroTable<?> table, TableRuntime tableRuntime) {
    }

    @Override
    protected long getStartDelay() {
        return 0L;
    }
}

