/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.terminal.kyuubi;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.amoro.api.config.ConfigOption;
import org.apache.amoro.api.config.ConfigOptions;
import org.apache.amoro.api.config.Configurations;
import org.apache.amoro.server.terminal.SparkContextUtil;
import org.apache.amoro.server.terminal.TerminalSession;
import org.apache.amoro.server.terminal.TerminalSessionFactory;
import org.apache.amoro.server.terminal.kyuubi.KyuubiSession;
import org.apache.amoro.shade.guava32.com.google.common.base.Joiner;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.table.TableMetaStore;
import org.apache.kyuubi.jdbc.KyuubiHiveDriver;
import org.apache.kyuubi.jdbc.hive.JdbcConnectionParams;
import org.apache.kyuubi.jdbc.hive.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KyuubiTerminalSessionFactory
implements TerminalSessionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KyuubiTerminalSessionFactory.class);
    public static ConfigOption<Boolean> KERBEROS_ENABLE = ConfigOptions.key((String)"kerberos.enabled").booleanType().defaultValue((Object)false);
    public static ConfigOption<Boolean> KERBEROS_PROXY_ENABLE = ConfigOptions.key((String)"kerberos.proxy.enabled").booleanType().defaultValue((Object)true).withDescription("proxy principal to kyuubi server instead of auth by client");
    public static ConfigOption<String> KERBEROS_DEFAULT_PRINCIPAL = ConfigOptions.key((String)"kerberos.default.principal").stringType().noDefaultValue().withDescription("principal to use when connection kerberos info is lack");
    public static ConfigOption<String> KERBEROS_DEFAULT_KEYTAB = ConfigOptions.key((String)"kerberos.default.keytab").stringType().noDefaultValue().withDescription("keytab file location to use when connection kerberos info is lack");
    public static ConfigOption<String> KYUUBI_URL = ConfigOptions.key((String)"jdbc.url").stringType().noDefaultValue();
    public static ConfigOption<String> KYUUBI_USERNAME = ConfigOptions.key((String)"jdbc.username").stringType().noDefaultValue();
    public static ConfigOption<String> KYUUBI_PASSWORD = ConfigOptions.key((String)"jdbc.password").stringType().noDefaultValue();
    private String jdbcUrl;
    private boolean kyuubiKerberosEnable;
    private boolean proxyKerberosEnable;
    private String username;
    private String password;
    private JdbcConnectionParams params;
    final KyuubiHiveDriver driver = new KyuubiHiveDriver();

    @Override
    public void initialize(Configurations properties) {
        this.jdbcUrl = (String)properties.getOptional(KYUUBI_URL).orElseThrow(() -> new IllegalStateException("lack require properties: jdbc.url. when kyuubi as terminal backend, this is require"));
        this.kyuubiKerberosEnable = (Boolean)properties.get(KERBEROS_ENABLE);
        this.proxyKerberosEnable = properties.getBoolean(KERBEROS_PROXY_ENABLE);
        this.username = (String)properties.get(KYUUBI_USERNAME);
        this.password = (String)properties.get(KYUUBI_PASSWORD);
        try {
            this.params = Utils.extractURLComponents((String)this.jdbcUrl, (Properties)new Properties());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TerminalSession create(TableMetaStore metaStore, Configurations configuration) {
        ArrayList logs = Lists.newArrayList();
        JdbcConnectionParams connectionParams = new JdbcConnectionParams(this.params);
        if (metaStore.isKerberosAuthMethod()) {
            this.checkAndFillKerberosInfo(connectionParams, metaStore);
        }
        Map<String, String> sparkConf = SparkContextUtil.getSparkConf(configuration);
        sparkConf.forEach((k, v) -> connectionParams.getHiveVars().put(k, v));
        String kyuubiJdbcUrl = this.getConnectionUrl(connectionParams);
        this.logMessage(logs, "try to create a kyuubi connection via url: " + kyuubiJdbcUrl);
        this.logMessage(logs, "");
        Map sessionConf = configuration.toMap();
        sessionConf.put("jdbc.url", kyuubiJdbcUrl);
        Properties properties = new Properties();
        if (!metaStore.isKerberosAuthMethod() && Objects.nonNull(metaStore.getHadoopUsername())) {
            properties.put("user", metaStore.getHadoopUsername());
            sessionConf.put("user", metaStore.getHadoopUsername());
        }
        Connection connection = (Connection)metaStore.doAs(() -> this.driver.connect(kyuubiJdbcUrl, properties));
        return new KyuubiSession(connection, logs, sessionConf);
    }

    private String getConnectionUrl(JdbcConnectionParams params) {
        StringBuilder kyuubiConnectionUrl = new StringBuilder("jdbc:hive2://" + params.getSuppliedURLAuthority() + "/;");
        if (!params.getSessionVars().isEmpty()) {
            kyuubiConnectionUrl.append(this.mapAsParams(params.getSessionVars()));
        }
        if (!params.getHiveConfs().isEmpty()) {
            kyuubiConnectionUrl.append("#").append(this.mapAsParams(params.getHiveConfs()));
        }
        if (!params.getHiveVars().isEmpty()) {
            kyuubiConnectionUrl.append("?").append(this.mapAsParams(params.getHiveVars()));
        }
        return kyuubiConnectionUrl.toString();
    }

    private String mapAsParams(Map<String, String> vars) {
        List kvList = vars.entrySet().stream().map(kv -> (String)kv.getKey() + "=" + (String)kv.getValue()).collect(Collectors.toList());
        return Joiner.on((String)";").join(kvList);
    }

    private void logMessage(List<String> logs, String message) {
        logs.add(message);
        LOG.info(message);
    }

    private void checkAndFillKerberosInfo(JdbcConnectionParams connectionParams, TableMetaStore metaStore) {
        if (connectionParams.getSessionVars().containsKey("principal")) {
            throw new RuntimeException("jdbc url should not contain principal when kyuubi kerberos enable");
        }
        connectionParams.getSessionVars().put("kerberosAuthType", "fromSubject");
        connectionParams.getSessionVars().put("principal", metaStore.getKrbPrincipal());
    }
}

