/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.compat;

import java.io.IOException;
import org.apache.amoro.shade.zookeeper3.org.apache.jute.InputArchive;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.ConnectRequest;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.ConnectResponse;

public final class ProtocolManager {
    private volatile Boolean isReadonlyAvailable = null;

    public boolean isReadonlyAvailable() {
        return this.isReadonlyAvailable != null && this.isReadonlyAvailable != false;
    }

    public ConnectRequest deserializeConnectRequest(InputArchive inputArchive) throws IOException {
        if (this.isReadonlyAvailable != null) {
            if (this.isReadonlyAvailable.booleanValue()) {
                return this.deserializeConnectRequestWithReadonly(inputArchive);
            }
            return this.deserializeConnectRequestWithoutReadonly(inputArchive);
        }
        ConnectRequest request = this.deserializeConnectRequestWithoutReadonly(inputArchive);
        try {
            request.setReadOnly(inputArchive.readBool("readOnly"));
            this.isReadonlyAvailable = true;
        }
        catch (Exception e) {
            request.setReadOnly(false);
            this.isReadonlyAvailable = false;
        }
        return request;
    }

    private ConnectRequest deserializeConnectRequestWithReadonly(InputArchive inputArchive) throws IOException {
        ConnectRequest request = new ConnectRequest();
        request.deserialize(inputArchive, "connect");
        return request;
    }

    private ConnectRequest deserializeConnectRequestWithoutReadonly(InputArchive inputArchive) throws IOException {
        ConnectRequest request = new ConnectRequest();
        inputArchive.startRecord("connect");
        request.setProtocolVersion(inputArchive.readInt("protocolVersion"));
        request.setLastZxidSeen(inputArchive.readLong("lastZxidSeen"));
        request.setTimeOut(inputArchive.readInt("timeOut"));
        request.setSessionId(inputArchive.readLong("sessionId"));
        request.setPasswd(inputArchive.readBuffer("passwd"));
        inputArchive.endRecord("connect");
        return request;
    }

    public ConnectResponse deserializeConnectResponse(InputArchive inputArchive) throws IOException {
        if (this.isReadonlyAvailable != null) {
            if (this.isReadonlyAvailable.booleanValue()) {
                return this.deserializeConnectResponseWithReadonly(inputArchive);
            }
            return this.deserializeConnectResponseWithoutReadonly(inputArchive);
        }
        ConnectResponse response = this.deserializeConnectResponseWithoutReadonly(inputArchive);
        try {
            response.setReadOnly(inputArchive.readBool("readOnly"));
            this.isReadonlyAvailable = true;
        }
        catch (Exception e) {
            response.setReadOnly(false);
            this.isReadonlyAvailable = false;
        }
        return response;
    }

    private ConnectResponse deserializeConnectResponseWithReadonly(InputArchive inputArchive) throws IOException {
        ConnectResponse response = new ConnectResponse();
        response.deserialize(inputArchive, "connect");
        return response;
    }

    private ConnectResponse deserializeConnectResponseWithoutReadonly(InputArchive inputArchive) throws IOException {
        ConnectResponse response = new ConnectResponse();
        inputArchive.startRecord("connect");
        response.setProtocolVersion(inputArchive.readInt("protocolVersion"));
        response.setTimeOut(inputArchive.readInt("timeOut"));
        response.setSessionId(inputArchive.readLong("sessionId"));
        response.setPasswd(inputArchive.readBuffer("passwd"));
        inputArchive.endRecord("connect");
        return response;
    }
}

