/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.io.network.partition.DataSetMetaInfo;
import org.apache.flink.runtime.io.network.partition.ResourceManagerPartitionTracker;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.TaskExecutorClusterPartitionReleaser;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.taskexecutor.partition.ClusterPartitionReport;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerPartitionTrackerImpl
implements ResourceManagerPartitionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceManagerPartitionTrackerImpl.class);
    private final Map<ResourceID, Set<IntermediateDataSetID>> taskExecutorToDataSets = new HashMap<ResourceID, Set<IntermediateDataSetID>>();
    private final Map<IntermediateDataSetID, Map<ResourceID, Set<ResultPartitionID>>> dataSetToTaskExecutors = new HashMap<IntermediateDataSetID, Map<ResourceID, Set<ResultPartitionID>>>();
    private final Map<IntermediateDataSetID, DataSetMetaInfo> dataSetMetaInfo = new HashMap<IntermediateDataSetID, DataSetMetaInfo>();
    private final Map<IntermediateDataSetID, CompletableFuture<Void>> partitionReleaseCompletionFutures = new HashMap<IntermediateDataSetID, CompletableFuture<Void>>();
    private final TaskExecutorClusterPartitionReleaser taskExecutorClusterPartitionReleaser;

    public ResourceManagerPartitionTrackerImpl(TaskExecutorClusterPartitionReleaser taskExecutorClusterPartitionReleaser) {
        this.taskExecutorClusterPartitionReleaser = taskExecutorClusterPartitionReleaser;
    }

    @Override
    public void processTaskExecutorClusterPartitionReport(ResourceID taskExecutorId, ClusterPartitionReport clusterPartitionReport) {
        Preconditions.checkNotNull((Object)taskExecutorId);
        Preconditions.checkNotNull((Object)clusterPartitionReport);
        LOG.debug("Processing cluster partition report from task executor {}: {}.", (Object)taskExecutorId, (Object)clusterPartitionReport);
        this.internalProcessClusterPartitionReport(taskExecutorId, clusterPartitionReport);
    }

    @Override
    public void processTaskExecutorShutdown(ResourceID taskExecutorId) {
        Preconditions.checkNotNull((Object)taskExecutorId);
        LOG.debug("Processing shutdown of task executor {}.", (Object)taskExecutorId);
        this.internalProcessClusterPartitionReport(taskExecutorId, new ClusterPartitionReport(Collections.emptyList()));
    }

    @Override
    public CompletableFuture<Void> releaseClusterPartitions(IntermediateDataSetID dataSetId) {
        Preconditions.checkNotNull((Object)dataSetId);
        if (!this.dataSetMetaInfo.containsKey(dataSetId)) {
            LOG.debug("Attempted released of unknown data set {}.", (Object)dataSetId);
            return CompletableFuture.completedFuture(null);
        }
        LOG.debug("Releasing cluster partitions for data set {}.", (Object)dataSetId);
        CompletableFuture partitionReleaseCompletionFuture = this.partitionReleaseCompletionFutures.computeIfAbsent(dataSetId, ignored -> new CompletableFuture());
        this.internalReleasePartitions(Collections.singleton(dataSetId));
        return partitionReleaseCompletionFuture;
    }

    @Override
    public List<ShuffleDescriptor> getClusterPartitionShuffleDescriptors(IntermediateDataSetID dataSetID) {
        DataSetMetaInfo dataSetMetaInfo = this.dataSetMetaInfo.get(dataSetID);
        if (dataSetMetaInfo == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ShuffleDescriptor>(dataSetMetaInfo.getShuffleDescriptors().values());
    }

    private void internalProcessClusterPartitionReport(ResourceID taskExecutorId, ClusterPartitionReport clusterPartitionReport) {
        Set<IntermediateDataSetID> dataSetsWithLostPartitions = clusterPartitionReport.getEntries().isEmpty() ? this.processEmptyReport(taskExecutorId) : this.setHostedDataSetsAndCheckCorruption(taskExecutorId, clusterPartitionReport.getEntries());
        this.updateDataSetMetaData(clusterPartitionReport);
        this.checkForFullyLostDatasets(dataSetsWithLostPartitions);
        this.internalReleasePartitions(dataSetsWithLostPartitions);
    }

    private void internalReleasePartitions(Set<IntermediateDataSetID> dataSetsToRelease) {
        Map<ResourceID, Set<IntermediateDataSetID>> releaseCalls = this.prepareReleaseCalls(dataSetsToRelease);
        releaseCalls.forEach(this.taskExecutorClusterPartitionReleaser::releaseClusterPartitions);
    }

    private Set<IntermediateDataSetID> processEmptyReport(ResourceID taskExecutorId) {
        Set<IntermediateDataSetID> previouslyHostedDatasets = this.taskExecutorToDataSets.remove(taskExecutorId);
        if (previouslyHostedDatasets == null) {
            previouslyHostedDatasets = Collections.emptySet();
        } else {
            previouslyHostedDatasets.forEach(dataSetId -> ResourceManagerPartitionTrackerImpl.removeInnerKey(dataSetId, taskExecutorId, this.dataSetToTaskExecutors));
        }
        return previouslyHostedDatasets;
    }

    private Set<IntermediateDataSetID> setHostedDataSetsAndCheckCorruption(ResourceID taskExecutorId, Collection<ClusterPartitionReport.ClusterPartitionReportEntry> reportEntries) {
        Set currentlyHostedDatasets = reportEntries.stream().map(ClusterPartitionReport.ClusterPartitionReportEntry::getDataSetId).collect(Collectors.toSet());
        Set previouslyHostedDataSets = this.taskExecutorToDataSets.put(taskExecutorId, currentlyHostedDatasets);
        Set potentiallyCorruptedDataSets = Optional.ofNullable(previouslyHostedDataSets).orElse(new HashSet(0));
        reportEntries.forEach(hostedPartition -> {
            boolean noPartitionLost;
            Map taskExecutorHosts = this.dataSetToTaskExecutors.computeIfAbsent(hostedPartition.getDataSetId(), ignored -> new HashMap());
            Set<ResultPartitionID> previouslyHostedPartitions = taskExecutorHosts.put(taskExecutorId, hostedPartition.getHostedPartitions());
            boolean bl = noPartitionLost = previouslyHostedPartitions == null || hostedPartition.getHostedPartitions().containsAll(previouslyHostedPartitions);
            if (noPartitionLost) {
                potentiallyCorruptedDataSets.remove(hostedPartition.getDataSetId());
            }
        });
        return potentiallyCorruptedDataSets;
    }

    private void updateDataSetMetaData(ClusterPartitionReport clusterPartitionReport) {
        clusterPartitionReport.getEntries().forEach(entry -> this.dataSetMetaInfo.compute(entry.getDataSetId(), (dataSetID, dataSetMetaInfo) -> {
            if (dataSetMetaInfo == null) {
                return DataSetMetaInfo.withoutNumRegisteredPartitions(entry.getNumTotalPartitions()).addShuffleDescriptors(entry.getShuffleDescriptors());
            }
            Preconditions.checkState((dataSetMetaInfo.getNumTotalPartitions() == entry.getNumTotalPartitions() ? 1 : 0) != 0);
            return dataSetMetaInfo.addShuffleDescriptors(entry.getShuffleDescriptors());
        }));
    }

    private void checkForFullyLostDatasets(Set<IntermediateDataSetID> dataSetsWithLostPartitions) {
        dataSetsWithLostPartitions.forEach(dataSetId -> {
            if (this.getHostingTaskExecutors((IntermediateDataSetID)dataSetId).isEmpty()) {
                LOG.debug("There are no longer partitions being tracked for dataset {}.", dataSetId);
                this.dataSetMetaInfo.remove(dataSetId);
                Optional.ofNullable(this.partitionReleaseCompletionFutures.remove(dataSetId)).map(future -> future.complete(null));
            }
        });
    }

    private Map<ResourceID, Set<IntermediateDataSetID>> prepareReleaseCalls(Set<IntermediateDataSetID> dataSetsToRelease) {
        HashMap<ResourceID, Set<IntermediateDataSetID>> releaseCalls = new HashMap<ResourceID, Set<IntermediateDataSetID>>();
        dataSetsToRelease.forEach(dataSetToRelease -> {
            Set<ResourceID> hostingTaskExecutors = this.getHostingTaskExecutors((IntermediateDataSetID)dataSetToRelease);
            hostingTaskExecutors.forEach(hostingTaskExecutor -> ResourceManagerPartitionTrackerImpl.insert(hostingTaskExecutor, dataSetToRelease, releaseCalls));
        });
        return releaseCalls;
    }

    private Set<ResourceID> getHostingTaskExecutors(IntermediateDataSetID dataSetId) {
        Preconditions.checkNotNull((Object)dataSetId);
        Map<ResourceID, Set<ResultPartitionID>> trackedPartitions = this.dataSetToTaskExecutors.get(dataSetId);
        if (trackedPartitions == null) {
            return Collections.emptySet();
        }
        return trackedPartitions.keySet();
    }

    @Override
    public Map<IntermediateDataSetID, DataSetMetaInfo> listDataSets() {
        return this.dataSetMetaInfo.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Map<ResourceID, Set<ResultPartitionID>> taskExecutorToPartitions = this.dataSetToTaskExecutors.get(entry.getKey());
            Preconditions.checkState((taskExecutorToPartitions != null ? 1 : 0) != 0, (String)"Have metadata entry for dataset %s, but no partition is tracked.", (Object[])new Object[]{entry.getKey()});
            int numTrackedPartitions = 0;
            for (Set<ResultPartitionID> hostedPartitions : taskExecutorToPartitions.values()) {
                numTrackedPartitions += hostedPartitions.size();
            }
            return DataSetMetaInfo.withNumRegisteredPartitions(numTrackedPartitions, ((DataSetMetaInfo)entry.getValue()).getNumTotalPartitions());
        }));
    }

    @VisibleForTesting
    boolean areAllMapsEmpty() {
        return this.taskExecutorToDataSets.isEmpty() && this.dataSetToTaskExecutors.isEmpty() && this.dataSetMetaInfo.isEmpty() && this.partitionReleaseCompletionFutures.isEmpty();
    }

    private static <K, V> void insert(K key1, V value, Map<K, Set<V>> collection) {
        collection.compute(key1, (key, values) -> {
            if (values == null) {
                values = new HashSet<Object>();
            }
            values.add(value);
            return values;
        });
    }

    private static <K1, K2, V> void removeInnerKey(K1 key1, K2 value, Map<K1, Map<K2, V>> collection) {
        collection.computeIfPresent(key1, (key, values) -> {
            values.remove(value);
            if (values.isEmpty()) {
                return null;
            }
            return values;
        });
    }
}

