/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.Serializable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.util.Preconditions;

public class SlotStatus
implements Serializable {
    private static final long serialVersionUID = 5099191707339664493L;
    private final SlotID slotID;
    private final ResourceProfile resourceProfile;
    private final AllocationID allocationID;
    private final JobID jobID;

    public SlotStatus(SlotID slotID, ResourceProfile resourceProfile) {
        this(slotID, resourceProfile, null, null);
    }

    public SlotStatus(SlotID slotID, ResourceProfile resourceProfile, JobID jobID, AllocationID allocationID) {
        this.slotID = (SlotID)Preconditions.checkNotNull((Object)slotID, (String)"slotID cannot be null");
        this.resourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)resourceProfile, (String)"profile cannot be null");
        this.allocationID = allocationID;
        this.jobID = jobID;
    }

    public SlotID getSlotID() {
        return this.slotID;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public AllocationID getAllocationID() {
        return this.allocationID;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotStatus that = (SlotStatus)o;
        if (!this.slotID.equals(that.slotID)) {
            return false;
        }
        if (!this.resourceProfile.equals(that.resourceProfile)) {
            return false;
        }
        if (this.allocationID != null ? !this.allocationID.equals((Object)that.allocationID) : that.allocationID != null) {
            return false;
        }
        return this.jobID != null ? this.jobID.equals((Object)that.jobID) : that.jobID == null;
    }

    public int hashCode() {
        int result = this.slotID.hashCode();
        result = 31 * result + this.resourceProfile.hashCode();
        result = 31 * result + (this.allocationID != null ? this.allocationID.hashCode() : 0);
        result = 31 * result + (this.jobID != null ? this.jobID.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SlotStatus{slotID=" + this.slotID + ", allocationID=" + (Object)((Object)this.allocationID) + ", jobID=" + this.jobID + ", resourceProfile=" + this.resourceProfile + '}';
    }
}

