/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.Schema;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.AdaptHiveParquetSchemaUtil;
import org.apache.iceberg.parquet.AdaptHiveParquetUtil;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;

class AdaptHiveParquetWriter<T>
implements FileAppender<T>,
Closeable {
    private static final DynConstructors.Ctor<PageWriteStore> pageStoreCtorParquet = DynConstructors.builder(PageWriteStore.class).hiddenImpl("org.apache.parquet.hadoop.ColumnChunkPageWriteStore", new Class[]{CodecFactory.BytesCompressor.class, MessageType.class, ByteBufferAllocator.class, Integer.TYPE}).build();
    private static final DynMethods.UnboundMethod flushToWriter = DynMethods.builder((String)"flushToFileWriter").hiddenImpl("org.apache.parquet.hadoop.ColumnChunkPageWriteStore", new Class[]{ParquetFileWriter.class}).build();
    private final long targetRowGroupSize;
    private final Map<String, String> metadata;
    private final ParquetProperties props;
    private final CodecFactory.BytesCompressor compressor;
    private final MessageType parquetSchema;
    private final ParquetValueWriter<T> model;
    private final ParquetFileWriter writer;
    private final MetricsConfig metricsConfig;
    private final int columnIndexTruncateLength;
    private DynMethods.BoundMethod flushPageStoreToWriter;
    private ColumnWriteStore writeStore;
    private long nextRowGroupSize = 0L;
    private long recordCount = 0L;
    private long nextCheckRecordCount = 10L;
    private boolean closed;
    private final Schema schema;
    private static final String COLUMN_INDEX_TRUNCATE_LENGTH = "parquet.columnindex.truncate.length";
    private static final int DEFAULT_COLUMN_INDEX_TRUNCATE_LENGTH = 64;

    AdaptHiveParquetWriter(Configuration conf, OutputFile output, Schema schema, long rowGroupSize, Map<String, String> metadata, Function<MessageType, ParquetValueWriter<?>> createWriterFunc, CompressionCodecName codec, ParquetProperties properties, MetricsConfig metricsConfig, ParquetFileWriter.Mode writeMode) {
        this.targetRowGroupSize = rowGroupSize;
        this.props = properties;
        this.metadata = ImmutableMap.copyOf(metadata);
        this.compressor = new CodecFactory(conf, this.props.getPageSizeThreshold()).getCompressor(codec);
        this.parquetSchema = AdaptHiveParquetSchemaUtil.convert(schema, "table");
        this.schema = schema;
        this.model = createWriterFunc.apply(this.parquetSchema);
        this.metricsConfig = metricsConfig;
        this.columnIndexTruncateLength = conf.getInt(COLUMN_INDEX_TRUNCATE_LENGTH, 64);
        try {
            this.writer = new ParquetFileWriter(ParquetIO.file((OutputFile)output, (Configuration)conf), this.parquetSchema, writeMode, rowGroupSize, 0);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to create Parquet file", new Object[0]);
        }
        try {
            this.writer.start();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to start Parquet file writer", new Object[0]);
        }
        this.startRowGroup();
    }

    public void add(T value) {
        ++this.recordCount;
        this.model.write(0, value);
        this.writeStore.endRecord();
        this.checkSize();
    }

    public Metrics metrics() {
        return AdaptHiveParquetUtil.footerMetrics(this.writer.getFooter(), this.model.metrics(), this.metricsConfig, this.schema);
    }

    public long length() {
        try {
            if (this.closed) {
                return this.writer.getPos();
            }
            return this.writer.getPos() + (this.writeStore.isColumnFlushNeeded() ? this.writeStore.getBufferedSize() : 0L);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to get file length", new Object[0]);
        }
    }

    public List<Long> splitOffsets() {
        return ParquetUtil.getSplitOffsets((ParquetMetadata)this.writer.getFooter());
    }

    private void checkSize() {
        if (this.recordCount >= this.nextCheckRecordCount) {
            double avgRecordSize;
            long bufferedSize = this.writeStore.getBufferedSize();
            if ((double)bufferedSize > (double)this.nextRowGroupSize - 2.0 * (avgRecordSize = (double)bufferedSize / (double)this.recordCount)) {
                this.flushRowGroup(false);
            } else {
                long remainingSpace = this.nextRowGroupSize - bufferedSize;
                long remainingRecords = (long)((double)remainingSpace / avgRecordSize);
                this.nextCheckRecordCount = this.recordCount + Math.min(Math.max(remainingRecords / 2L, 100L), 10000L);
            }
        }
    }

    private void flushRowGroup(boolean finished) {
        try {
            if (this.recordCount > 0L) {
                this.writer.startBlock(this.recordCount);
                this.writeStore.flush();
                this.flushPageStoreToWriter.invoke(new Object[]{this.writer});
                this.writer.endBlock();
                if (!finished) {
                    this.startRowGroup();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to flush row group", new Object[0]);
        }
    }

    private void startRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Writer is closed");
        try {
            this.nextRowGroupSize = Math.min(this.writer.getNextRowGroupSize(), this.targetRowGroupSize);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        this.nextCheckRecordCount = Math.min(Math.max(this.recordCount / 2L, 100L), 10000L);
        this.recordCount = 0L;
        PageWriteStore pageStore = (PageWriteStore)pageStoreCtorParquet.newInstance(new Object[]{this.compressor, this.parquetSchema, this.props.getAllocator(), this.columnIndexTruncateLength});
        this.flushPageStoreToWriter = flushToWriter.bind((Object)pageStore);
        this.writeStore = this.props.newColumnWriteStore(this.parquetSchema, pageStore);
        this.model.setColumnStore(this.writeStore);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.flushRowGroup(true);
            this.writeStore.close();
            if (this.writer != null) {
                this.writer.end(this.metadata);
            }
            if (this.compressor != null) {
                this.compressor.release();
            }
        }
    }
}

