/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.Pair;

public class ScanTaskSetManager {
    private static final ScanTaskSetManager INSTANCE = new ScanTaskSetManager();
    private final Map<Pair<String, String>, List<? extends ScanTask>> tasksMap = Maps.newConcurrentMap();

    private ScanTaskSetManager() {
    }

    public static ScanTaskSetManager get() {
        return INSTANCE;
    }

    public <T extends ScanTask> void stageTasks(Table table, String setId, List<T> tasks) {
        Preconditions.checkArgument((tasks != null && tasks.size() > 0 ? 1 : 0) != 0, (Object)"Cannot stage null or empty tasks");
        Pair<String, String> id = this.toId(table, setId);
        this.tasksMap.put(id, tasks);
    }

    public <T extends ScanTask> List<T> fetchTasks(Table table, String setId) {
        Pair<String, String> id = this.toId(table, setId);
        return this.tasksMap.get(id);
    }

    public <T extends ScanTask> List<T> removeTasks(Table table, String setId) {
        Pair<String, String> id = this.toId(table, setId);
        return this.tasksMap.remove(id);
    }

    public Set<String> fetchSetIds(Table table) {
        return this.tasksMap.keySet().stream().filter(e -> ((String)e.first()).equals(this.tableUUID(table))).map(Pair::second).collect(Collectors.toSet());
    }

    private String tableUUID(Table table) {
        TableOperations ops = ((HasTableOperations)table).operations();
        return ops.current().uuid();
    }

    private Pair<String, String> toId(Table table, String setId) {
        return Pair.of((Object)this.tableUUID(table), (Object)setId);
    }
}

