/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Map;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.transforms.SortOrderVisitor;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.NullOrdering;
import org.apache.spark.sql.connector.expressions.SortOrder;

class SortOrderToSpark
implements SortOrderVisitor<SortOrder> {
    private final Map<Integer, String> quotedNameById;

    SortOrderToSpark(Schema schema) {
        this.quotedNameById = SparkSchemaUtil.indexQuotedNameById(schema);
    }

    public SortOrder field(String sourceName, int id, SortDirection direction, NullOrder nullOrder) {
        return Expressions.sort((Expression)Expressions.column((String)this.quotedName(id)), (org.apache.spark.sql.connector.expressions.SortDirection)this.toSpark(direction), (NullOrdering)this.toSpark(nullOrder));
    }

    public SortOrder bucket(String sourceName, int id, int width, SortDirection direction, NullOrder nullOrder) {
        return Expressions.sort((Expression)Expressions.bucket((int)width, (String[])new String[]{this.quotedName(id)}), (org.apache.spark.sql.connector.expressions.SortDirection)this.toSpark(direction), (NullOrdering)this.toSpark(nullOrder));
    }

    public SortOrder truncate(String sourceName, int id, int width, SortDirection direction, NullOrder nullOrder) {
        return Expressions.sort((Expression)Expressions.apply((String)"truncate", (Expression[])new Expression[]{Expressions.column((String)this.quotedName(id)), Expressions.literal((Object)width)}), (org.apache.spark.sql.connector.expressions.SortDirection)this.toSpark(direction), (NullOrdering)this.toSpark(nullOrder));
    }

    public SortOrder year(String sourceName, int id, SortDirection direction, NullOrder nullOrder) {
        return Expressions.sort((Expression)Expressions.years((String)this.quotedName(id)), (org.apache.spark.sql.connector.expressions.SortDirection)this.toSpark(direction), (NullOrdering)this.toSpark(nullOrder));
    }

    public SortOrder month(String sourceName, int id, SortDirection direction, NullOrder nullOrder) {
        return Expressions.sort((Expression)Expressions.months((String)this.quotedName(id)), (org.apache.spark.sql.connector.expressions.SortDirection)this.toSpark(direction), (NullOrdering)this.toSpark(nullOrder));
    }

    public SortOrder day(String sourceName, int id, SortDirection direction, NullOrder nullOrder) {
        return Expressions.sort((Expression)Expressions.days((String)this.quotedName(id)), (org.apache.spark.sql.connector.expressions.SortDirection)this.toSpark(direction), (NullOrdering)this.toSpark(nullOrder));
    }

    public SortOrder hour(String sourceName, int id, SortDirection direction, NullOrder nullOrder) {
        return Expressions.sort((Expression)Expressions.hours((String)this.quotedName(id)), (org.apache.spark.sql.connector.expressions.SortDirection)this.toSpark(direction), (NullOrdering)this.toSpark(nullOrder));
    }

    private String quotedName(int id) {
        return this.quotedNameById.get(id);
    }

    private org.apache.spark.sql.connector.expressions.SortDirection toSpark(SortDirection direction) {
        if (direction == SortDirection.ASC) {
            return org.apache.spark.sql.connector.expressions.SortDirection.ASCENDING;
        }
        return org.apache.spark.sql.connector.expressions.SortDirection.DESCENDING;
    }

    private NullOrdering toSpark(NullOrder nullOrder) {
        return nullOrder == NullOrder.NULLS_FIRST ? NullOrdering.NULLS_FIRST : NullOrdering.NULLS_LAST;
    }
}

