/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;

public class SparkValueConverter {
    private SparkValueConverter() {
    }

    public static Record convert(Schema schema, Row row) {
        return SparkValueConverter.convert(schema.asStruct(), row);
    }

    public static Object convert(Type type, Object object) {
        if (object == null) {
            return null;
        }
        switch (type.typeId()) {
            case STRUCT: {
                return SparkValueConverter.convert(type.asStructType(), (Row)object);
            }
            case LIST: {
                ArrayList convertedList = Lists.newArrayList();
                List list = (List)object;
                for (Object element : list) {
                    convertedList.add(SparkValueConverter.convert(type.asListType().elementType(), element));
                }
                return convertedList;
            }
            case MAP: {
                LinkedHashMap convertedMap = Maps.newLinkedHashMap();
                Map map = (Map)object;
                for (Map.Entry entry : map.entrySet()) {
                    convertedMap.put(SparkValueConverter.convert(type.asMapType().keyType(), entry.getKey()), SparkValueConverter.convert(type.asMapType().valueType(), entry.getValue()));
                }
                return convertedMap;
            }
            case DATE: {
                return DateTimeUtils.anyToDays((Object)object);
            }
            case TIMESTAMP: {
                return DateTimeUtils.anyToMicros((Object)object);
            }
            case BINARY: {
                return ByteBuffer.wrap((byte[])object);
            }
            case INTEGER: {
                return ((Number)object).intValue();
            }
            case BOOLEAN: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case STRING: 
            case FIXED: {
                return object;
            }
        }
        throw new UnsupportedOperationException("Not a supported type: " + type);
    }

    private static Record convert(Types.StructType struct, Row row) {
        if (row == null) {
            return null;
        }
        GenericRecord record = GenericRecord.create((Types.StructType)struct);
        List fields = struct.fields();
        block5: for (int i = 0; i < fields.size(); ++i) {
            Types.NestedField field = (Types.NestedField)fields.get(i);
            Type fieldType = field.type();
            switch (fieldType.typeId()) {
                case STRUCT: {
                    record.set(i, (Object)SparkValueConverter.convert(fieldType.asStructType(), row.getStruct(i)));
                    continue block5;
                }
                case LIST: {
                    record.set(i, SparkValueConverter.convert((Type)fieldType.asListType(), row.getList(i)));
                    continue block5;
                }
                case MAP: {
                    record.set(i, SparkValueConverter.convert((Type)fieldType.asMapType(), row.getJavaMap(i)));
                    continue block5;
                }
                default: {
                    record.set(i, SparkValueConverter.convert(fieldType, row.get(i)));
                }
            }
        }
        return record;
    }

    public static Object convertToSpark(Type type, Object object) {
        if (object == null) {
            return null;
        }
        switch (type.typeId()) {
            case STRUCT: 
            case LIST: 
            case MAP: {
                return new UnsupportedOperationException("Complex types currently not supported");
            }
            case DATE: {
                return DateTimeUtils.daysToLocalDate((int)((Integer)object));
            }
            case TIMESTAMP: {
                Types.TimestampType ts = (Types.TimestampType)type.asPrimitiveType();
                if (ts.shouldAdjustToUTC()) {
                    return DateTimeUtils.microsToInstant((long)((Long)object));
                }
                return DateTimeUtils.microsToLocalDateTime((long)((Long)object));
            }
            case BINARY: {
                return ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)object));
            }
            case INTEGER: 
            case BOOLEAN: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case STRING: 
            case FIXED: {
                return object;
            }
        }
        throw new UnsupportedOperationException("Not a supported type: " + type);
    }
}

