/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.List;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.spark.actions.SparkSizeBasedDataRewriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

class SparkBinPackDataRewriter
extends SparkSizeBasedDataRewriter {
    SparkBinPackDataRewriter(SparkSession spark, Table table) {
        super(spark, table);
    }

    public String description() {
        return "BIN-PACK";
    }

    @Override
    protected void doRewrite(String groupId, List<FileScanTask> group) {
        Dataset scanDF = this.spark().read().format("iceberg").option("scan-task-set-id", groupId).option("split-size", this.splitSize(this.inputSize(group))).option("file-open-cost", "0").load(groupId);
        scanDF.write().format("iceberg").option("rewritten-file-scan-task-set-id", groupId).option("target-file-size-bytes", this.writeMaxFileSize()).option("distribution-mode", this.distributionMode(group).modeName()).mode("append").save(groupId);
    }

    private DistributionMode distributionMode(List<FileScanTask> group) {
        boolean requiresRepartition = !group.get(0).spec().equals((Object)this.table().spec());
        return requiresRepartition ? DistributionMode.RANGE : DistributionMode.NONE;
    }
}

