/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;

class ProcedureInput {
    private static final DataType STRING_ARRAY = DataTypes.createArrayType((DataType)DataTypes.StringType);
    private static final DataType STRING_MAP = DataTypes.createMapType((DataType)DataTypes.StringType, (DataType)DataTypes.StringType);
    private final SparkSession spark;
    private final TableCatalog catalog;
    private final Map<String, Integer> paramOrdinals;
    private final InternalRow args;

    ProcedureInput(SparkSession spark, TableCatalog catalog, ProcedureParameter[] params, InternalRow args) {
        this.spark = spark;
        this.catalog = catalog;
        this.paramOrdinals = this.computeParamOrdinals(params);
        this.args = args;
    }

    public boolean isProvided(ProcedureParameter param) {
        int ordinal = this.ordinal(param);
        return !this.args.isNullAt(ordinal);
    }

    public Boolean asBoolean(ProcedureParameter param, Boolean defaultValue) {
        this.validateParamType(param, DataTypes.BooleanType);
        int ordinal = this.ordinal(param);
        return this.args.isNullAt(ordinal) ? defaultValue : Boolean.valueOf(this.args.getBoolean(ordinal));
    }

    public long asLong(ProcedureParameter param) {
        Long value = this.asLong(param, null);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Parameter '%s' is not set", (Object)param.name());
        return value;
    }

    public Long asLong(ProcedureParameter param, Long defaultValue) {
        this.validateParamType(param, DataTypes.LongType);
        int ordinal = this.ordinal(param);
        return this.args.isNullAt(ordinal) ? defaultValue : Long.valueOf(this.args.getLong(ordinal));
    }

    public String asString(ProcedureParameter param) {
        String value = this.asString(param, null);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Parameter '%s' is not set", (Object)param.name());
        return value;
    }

    public String asString(ProcedureParameter param, String defaultValue) {
        this.validateParamType(param, DataTypes.StringType);
        int ordinal = this.ordinal(param);
        return this.args.isNullAt(ordinal) ? defaultValue : this.args.getString(ordinal);
    }

    public String[] asStringArray(ProcedureParameter param) {
        String[] value = this.asStringArray(param, null);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Parameter '%s' is not set", (Object)param.name());
        return value;
    }

    public String[] asStringArray(ProcedureParameter param, String[] defaultValue) {
        this.validateParamType(param, STRING_ARRAY);
        return this.array(param, (array, ordinal) -> array.getUTF8String(ordinal.intValue()).toString(), String.class, defaultValue);
    }

    private <T> T[] array(ProcedureParameter param, BiFunction<ArrayData, Integer, T> convertElement, Class<T> elementClass, T[] defaultValue) {
        int ordinal = this.ordinal(param);
        if (this.args.isNullAt(ordinal)) {
            return defaultValue;
        }
        ArrayData arrayData = this.args.getArray(ordinal);
        Object[] convertedArray = (Object[])Array.newInstance(elementClass, arrayData.numElements());
        for (int index = 0; index < arrayData.numElements(); ++index) {
            convertedArray[index] = convertElement.apply(arrayData, index);
        }
        return convertedArray;
    }

    public Map<String, String> asStringMap(ProcedureParameter param, Map<String, String> defaultValue) {
        this.validateParamType(param, STRING_MAP);
        return this.map(param, (keys, ordinal) -> keys.getUTF8String(ordinal.intValue()).toString(), (values, ordinal) -> values.getUTF8String(ordinal.intValue()).toString(), defaultValue);
    }

    private <K, V> Map<K, V> map(ProcedureParameter param, BiFunction<ArrayData, Integer, K> convertKey, BiFunction<ArrayData, Integer, V> convertValue, Map<K, V> defaultValue) {
        int ordinal = this.ordinal(param);
        if (this.args.isNullAt(ordinal)) {
            return defaultValue;
        }
        MapData mapData = this.args.getMap(ordinal);
        HashMap convertedMap = Maps.newHashMap();
        for (int index = 0; index < mapData.numElements(); ++index) {
            K convertedKey = convertKey.apply(mapData.keyArray(), index);
            V convertedValue = convertValue.apply(mapData.valueArray(), index);
            convertedMap.put(convertedKey, convertedValue);
        }
        return convertedMap;
    }

    public Identifier ident(ProcedureParameter param) {
        Spark3Util.CatalogAndIdentifier catalogAndIdent = this.catalogAndIdent(param, (CatalogPlugin)this.catalog);
        Preconditions.checkArgument((boolean)catalogAndIdent.catalog().equals(this.catalog), (String)"Cannot run procedure in catalog '%s': '%s' is a table in catalog '%s'", (Object)this.catalog.name(), (Object)catalogAndIdent.identifier(), (Object)catalogAndIdent.catalog().name());
        return catalogAndIdent.identifier();
    }

    public Identifier ident(ProcedureParameter param, CatalogPlugin defaultCatalog) {
        Spark3Util.CatalogAndIdentifier catalogAndIdent = this.catalogAndIdent(param, defaultCatalog);
        return catalogAndIdent.identifier();
    }

    private Spark3Util.CatalogAndIdentifier catalogAndIdent(ProcedureParameter param, CatalogPlugin defaultCatalog) {
        String identAsString = this.asString(param);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)identAsString), (String)"Cannot handle an empty identifier for parameter '%s'", (Object)param.name());
        String desc = String.format("identifier for parameter '%s'", param.name());
        return Spark3Util.catalogAndIdentifier(desc, this.spark, identAsString, defaultCatalog);
    }

    private int ordinal(ProcedureParameter param) {
        return this.paramOrdinals.get(param.name());
    }

    private Map<String, Integer> computeParamOrdinals(ProcedureParameter[] params) {
        HashMap ordinals = Maps.newHashMap();
        for (int index = 0; index < params.length; ++index) {
            String paramName = params[index].name();
            Preconditions.checkArgument((!ordinals.containsKey(paramName) ? 1 : 0) != 0, (String)"Detected multiple parameters named as '%s'", (Object)paramName);
            ordinals.put(paramName, index);
        }
        return ordinals;
    }

    private void validateParamType(ProcedureParameter param, DataType expectedDataType) {
        Preconditions.checkArgument((boolean)expectedDataType.sameType(param.dataType()), (String)"Parameter '%s' must be of type %s", (Object)param.name(), (Object)expectedDataType.catalogString());
    }
}

