/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.spark.source.BaseReader;
import org.apache.iceberg.spark.source.RowDataReader;
import org.apache.spark.rdd.InputFileBlockHolder;
import org.apache.spark.sql.catalyst.InternalRow;

public class EqualityDeleteRowReader
extends RowDataReader {
    public EqualityDeleteRowReader(CombinedScanTask task, Table table, Schema tableSchema, Schema expectedSchema, boolean caseSensitive) {
        super(table, (ScanTaskGroup<FileScanTask>)task, tableSchema, expectedSchema, caseSensitive);
    }

    @Override
    protected CloseableIterator<InternalRow> open(FileScanTask task) {
        BaseReader.SparkDeleteFilter matches = new BaseReader.SparkDeleteFilter(((DataFile)task.file()).path().toString(), task.deletes(), this.counter());
        Schema requiredSchema = matches.requiredSchema();
        Map<Integer, ?> idToConstant = this.constantsMap((ContentScanTask<?>)task, this.expectedSchema());
        DataFile file = (DataFile)task.file();
        InputFileBlockHolder.set((String)file.path().toString(), (long)task.start(), (long)task.length());
        return matches.findEqualityDeleteRows(this.open(task, requiredSchema, idToConstant)).iterator();
    }
}

