/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.FileReaderFactory;
import org.apache.paimon.mergetree.MergeSorter;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.utils.FieldsComparator;

public class MergeTreeReaders {
    private MergeTreeReaders() {
    }

    public static <T> RecordReader<T> readerForMergeTree(List<List<SortedRun>> sections, FileReaderFactory<KeyValue> readerFactory, Comparator<InternalRow> userKeyComparator, @Nullable FieldsComparator userDefinedSeqComparator, MergeFunctionWrapper<T> mergeFunctionWrapper, MergeSorter mergeSorter) throws IOException {
        ArrayList readers = new ArrayList();
        for (List<SortedRun> section : sections) {
            readers.add(() -> MergeTreeReaders.readerForSection(section, readerFactory, userKeyComparator, userDefinedSeqComparator, mergeFunctionWrapper, mergeSorter));
        }
        return ConcatRecordReader.create(readers);
    }

    public static <T> RecordReader<T> readerForSection(List<SortedRun> section, FileReaderFactory<KeyValue> readerFactory, Comparator<InternalRow> userKeyComparator, @Nullable FieldsComparator userDefinedSeqComparator, MergeFunctionWrapper<T> mergeFunctionWrapper, MergeSorter mergeSorter) throws IOException {
        ArrayList<ConcatRecordReader.ReaderSupplier<KeyValue>> readers = new ArrayList<ConcatRecordReader.ReaderSupplier<KeyValue>>();
        for (SortedRun run : section) {
            readers.add(() -> MergeTreeReaders.readerForRun(run, readerFactory));
        }
        return mergeSorter.mergeSort(readers, userKeyComparator, userDefinedSeqComparator, mergeFunctionWrapper);
    }

    private static RecordReader<KeyValue> readerForRun(SortedRun run, FileReaderFactory<KeyValue> readerFactory) throws IOException {
        ArrayList readers = new ArrayList();
        for (DataFileMeta file : run.files()) {
            readers.add(() -> readerFactory.createRecordReader(file));
        }
        return ConcatRecordReader.create(readers);
    }
}

