/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.options;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.paimon.utils.Preconditions;

class StructuredOptionsSplitter {
    static List<String> splitEscaped(String string, char delimiter) {
        List<Token> tokens = StructuredOptionsSplitter.tokenize(Preconditions.checkNotNull(string), delimiter);
        return StructuredOptionsSplitter.processTokens(tokens);
    }

    static String escapeWithSingleQuote(String string, String ... charsToEscape) {
        boolean escape;
        boolean bl = escape = Arrays.stream(charsToEscape).anyMatch(string::contains) || string.contains("\"") || string.contains("'");
        if (escape) {
            return "'" + string.replaceAll("'", "''") + "'";
        }
        return string;
    }

    private static List<String> processTokens(List<Token> tokens) {
        ArrayList<String> splits = new ArrayList<String>();
        block5: for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            switch (token.getTokenType()) {
                case DOUBLE_QUOTED: 
                case SINGLE_QUOTED: {
                    if (i + 1 < tokens.size() && tokens.get(i + 1).getTokenType() != TokenType.DELIMITER) {
                        int illegalPosition = tokens.get(i + 1).getPosition() - 1;
                        throw new IllegalArgumentException("Could not split string. Illegal quoting at position: " + illegalPosition);
                    }
                    splits.add(token.getString());
                    continue block5;
                }
                case UNQUOTED: {
                    splits.add(token.getString());
                    continue block5;
                }
                case DELIMITER: {
                    if (i + 1 >= tokens.size() || tokens.get(i + 1).getTokenType() != TokenType.DELIMITER) continue block5;
                    splits.add("");
                }
            }
        }
        return splits;
    }

    private static List<Token> tokenize(String string, char delimiter) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        StringBuilder builder = new StringBuilder();
        int cursor = 0;
        while (cursor < string.length()) {
            char c = string.charAt(cursor);
            int nextChar = cursor + 1;
            if (c == '\'') {
                nextChar = StructuredOptionsSplitter.consumeInQuotes(string, '\'', cursor, builder);
                tokens.add(new Token(TokenType.SINGLE_QUOTED, builder.toString(), cursor));
            } else if (c == '\"') {
                nextChar = StructuredOptionsSplitter.consumeInQuotes(string, '\"', cursor, builder);
                tokens.add(new Token(TokenType.DOUBLE_QUOTED, builder.toString(), cursor));
            } else if (c == delimiter) {
                tokens.add(new Token(TokenType.DELIMITER, String.valueOf(c), cursor));
            } else if (!Character.isWhitespace(c)) {
                nextChar = StructuredOptionsSplitter.consumeUnquoted(string, delimiter, cursor, builder);
                tokens.add(new Token(TokenType.UNQUOTED, builder.toString().trim(), cursor));
            }
            builder.setLength(0);
            cursor = nextChar;
        }
        return tokens;
    }

    private static int consumeInQuotes(String string, char quote, int cursor, StringBuilder builder) {
        for (int i = cursor + 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == quote) {
                if (i + 1 < string.length() && string.charAt(i + 1) == quote) {
                    builder.append(c);
                    ++i;
                    continue;
                }
                return i + 1;
            }
            builder.append(c);
        }
        throw new IllegalArgumentException("Could not split string. Quoting was not closed properly.");
    }

    private static int consumeUnquoted(String string, char delimiter, int cursor, StringBuilder builder) {
        int i;
        for (i = cursor; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == delimiter) {
                return i;
            }
            builder.append(c);
        }
        return i;
    }

    private StructuredOptionsSplitter() {
    }

    private static class Token {
        private final TokenType tokenType;
        private final String string;
        private final int position;

        private Token(TokenType tokenType, String string, int position) {
            this.tokenType = tokenType;
            this.string = string;
            this.position = position;
        }

        public TokenType getTokenType() {
            return this.tokenType;
        }

        public String getString() {
            return this.string;
        }

        public int getPosition() {
            return this.position;
        }
    }

    private static enum TokenType {
        DOUBLE_QUOTED,
        SINGLE_QUOTED,
        UNQUOTED,
        DELIMITER;

    }
}

