/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.privilege;

import org.apache.paimon.annotation.Public;

@Public
public enum PrivilegeType {
    SELECT(PrivilegeTarget.TABLE),
    INSERT(PrivilegeTarget.TABLE),
    ALTER_TABLE(PrivilegeTarget.TABLE),
    DROP_TABLE(PrivilegeTarget.TABLE),
    CREATE_TABLE(PrivilegeTarget.DATABASE),
    DROP_DATABASE(PrivilegeTarget.DATABASE),
    CREATE_DATABASE(PrivilegeTarget.CATALOG),
    ADMIN(PrivilegeTarget.CATALOG);

    private final PrivilegeTarget target;

    private PrivilegeType(PrivilegeTarget target) {
        this.target = target;
    }

    public boolean canGrantOnCatalog() {
        return PrivilegeTarget.CATALOG.equals((Object)this.target) || this.canGrantOnDatabase();
    }

    public boolean canGrantOnDatabase() {
        return PrivilegeTarget.DATABASE.equals((Object)this.target) || this.canGrantOnTable();
    }

    public boolean canGrantOnTable() {
        return PrivilegeTarget.TABLE.equals((Object)this.target);
    }

    private static enum PrivilegeTarget {
        CATALOG,
        DATABASE,
        TABLE;

    }
}

