/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.time.Duration;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.utils.TimeUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class CreateTagProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.required("tag", DataTypes.StringType), ProcedureParameter.optional("snapshot", DataTypes.LongType), ProcedureParameter.optional("time_retained", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    protected CreateTagProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        String tag = args.getString(1);
        Long snapshot = args.isNullAt(2) ? null : Long.valueOf(args.getLong(2));
        Duration timeRetained = args.isNullAt(3) ? null : TimeUtils.parseDuration(args.getString(3));
        return this.modifyPaimonTable(tableIdent, table -> {
            if (snapshot == null) {
                table.createTag(tag, timeRetained);
            } else {
                table.createTag(tag, snapshot, timeRetained);
            }
            InternalRow outputRow = this.newInternalRow(true);
            return new InternalRow[]{outputRow};
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<CreateTagProcedure>(){

            @Override
            public CreateTagProcedure doBuild() {
                return new CreateTagProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "CreateTagProcedure";
    }
}

