/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.io.Serializable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.utils.SerializableFunction;

public interface ChannelComputer<T>
extends Serializable {
    public void setup(int var1);

    public int channel(T var1);

    public static int select(BinaryRow partition, int bucket, int numChannels) {
        int startChannel = Math.abs(partition.hashCode()) % numChannels;
        return (startChannel + bucket) % numChannels;
    }

    public static int select(int bucket, int numChannels) {
        return bucket % numChannels;
    }

    public static <T, R> ChannelComputer<R> transform(final ChannelComputer<T> input, final SerializableFunction<R, T> converter) {
        return new ChannelComputer<R>(){

            @Override
            public void setup(int numChannels) {
                input.setup(numChannels);
            }

            @Override
            public int channel(R record) {
                return input.channel(converter.apply(record));
            }
        };
    }
}

