/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import org.apache.paimon.shade.it.unimi.dsi.fastutil.ints.Int2ShortOpenHashMap;
import org.apache.paimon.shade.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.apache.paimon.shade.it.unimi.dsi.fastutil.shorts.ShortArrayList;

public class Int2ShortHashMap {
    private final Int2ShortOpenHashMap map;

    public Int2ShortHashMap() {
        this.map = new Int2ShortOpenHashMap();
    }

    public Int2ShortHashMap(int capacity) {
        this.map = new Int2ShortOpenHashMap(capacity);
    }

    public void put(int key, short value) {
        this.map.put(key, value);
    }

    public boolean containsKey(int key) {
        return this.map.containsKey(key);
    }

    public short get(int key) {
        return this.map.get(key);
    }

    public int size() {
        return this.map.size();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final IntArrayList keyList = new IntArrayList();
        private final ShortArrayList valueList = new ShortArrayList();

        public void put(int key, short value) {
            this.keyList.add(key);
            this.valueList.add(value);
        }

        public Int2ShortHashMap build() {
            Int2ShortHashMap map = new Int2ShortHashMap(this.keyList.size());
            for (int i = 0; i < this.keyList.size(); ++i) {
                map.put(this.keyList.getInt(i), this.valueList.getShort(i));
            }
            return map;
        }
    }
}

