/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.CommonUnifiedCatalog;
import org.apache.amoro.FormatCatalogFactory;
import org.apache.amoro.NoSuchTableException;
import org.apache.amoro.TableFormat;
import org.apache.amoro.TableIDWithFormat;
import org.apache.amoro.UnifiedCatalog;
import org.apache.amoro.UnifiedCatalogLoader;
import org.apache.amoro.client.AmsThriftUrl;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.spark.SparkTableFormat;
import org.apache.amoro.spark.SupportAuthentication;
import org.apache.amoro.table.TableMetaStore;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchProcedureException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.iceberg.catalog.Procedure;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureCatalog;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkUnifiedCatalogBase
implements TableCatalog,
SupportsNamespaces,
ProcedureCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(SparkUnifiedCatalogBase.class);
    public static final String CATALOG_REGISTER_NAME = "register-name";
    private static final Map<TableFormat, String> defaultTableCatalogImplMap = ImmutableMap.of((Object)TableFormat.ICEBERG, (Object)"org.apache.iceberg.spark.SparkCatalog", (Object)TableFormat.MIXED_HIVE, (Object)"org.apache.amoro.spark.MixedFormatSparkCatalog", (Object)TableFormat.MIXED_ICEBERG, (Object)"org.apache.amoro.spark.MixedFormatSparkCatalog", (Object)TableFormat.PAIMON, (Object)"org.apache.paimon.spark.SparkCatalog");
    private UnifiedCatalog unifiedCatalog;
    private String name;
    private final Map<TableFormat, SparkTableFormat> tableFormats = Maps.newConcurrentMap();
    private final Map<TableFormat, TableCatalog> tableCatalogs = Maps.newConcurrentMap();

    public void initialize(String name, CaseInsensitiveStringMap options) {
        this.name = name;
        HashMap properties = Maps.newHashMap((Map)options);
        String uri = options.get((Object)"uri");
        properties.remove("uri");
        if (StringUtils.isNotEmpty((CharSequence)uri)) {
            AmsThriftUrl catalogUri = AmsThriftUrl.parse((String)uri, (String)"TableMetastore");
            String registerCatalogName = catalogUri.catalogName();
            if (StringUtils.isBlank((CharSequence)registerCatalogName)) {
                registerCatalogName = name;
                if (CatalogManager.SESSION_CATALOG_NAME().equalsIgnoreCase(registerCatalogName)) {
                    LOG.warn("Catalog name is not exists in catalog uri, using spark catalog as register catalog name, but current name " + registerCatalogName + " is spark session catalog name.");
                }
            }
            this.unifiedCatalog = UnifiedCatalogLoader.loadUnifiedCatalog((String)catalogUri.serverUrl(), (String)registerCatalogName, (Map)properties);
        } else {
            String metastoreType = (String)properties.get("type");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)metastoreType), (Object)"Lack required property: type when initializing unified spark catalog");
            Configuration localConfiguration = SparkUtil.hadoopConfCatalogOverrides((SparkSession)SparkSession.active(), (String)name);
            TableMetaStore tableMetaStore = TableMetaStore.builder().withConfiguration(localConfiguration).build();
            this.unifiedCatalog = new CommonUnifiedCatalog(name, metastoreType, (Map)properties, tableMetaStore);
        }
        ServiceLoader<SparkTableFormat> sparkTableFormats = ServiceLoader.load(SparkTableFormat.class);
        for (SparkTableFormat format : sparkTableFormats) {
            this.tableFormats.put(format.format(), format);
        }
    }

    public String name() {
        return this.name;
    }

    private String namespaceToDatabase(String[] namespace) {
        Preconditions.checkArgument((namespace.length == 1 ? 1 : 0) != 0, (Object)"only support namespace with 1 level.");
        return namespace[0];
    }

    /*
     * Exception decompiling
     */
    public String[][] listNamespaces() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String[][] listNamespaces(String[] namespace) {
        return new String[0][];
    }

    public boolean namespaceExists(String[] namespace) {
        return this.unifiedCatalog.databaseExists(this.namespaceToDatabase(namespace));
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws NoSuchNamespaceException {
        if (this.namespaceExists(namespace)) {
            return ImmutableMap.of();
        }
        throw new NoSuchNamespaceException(namespace);
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) {
        String database = this.namespaceToDatabase(namespace);
        if (metadata != null && !metadata.isEmpty()) {
            LOG.warn("doesn't support properties for database, all properties will be discard.");
        }
        this.unifiedCatalog.createDatabase(database);
    }

    public void alterNamespace(String[] namespace, NamespaceChange ... changes) {
        throw new UnsupportedOperationException("Cannot apply namespace change");
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) throws NoSuchNamespaceException {
        String database = this.namespaceToDatabase(namespace);
        if (!this.unifiedCatalog.databaseExists(database)) {
            throw new NoSuchNamespaceException(namespace);
        }
        List tables = this.unifiedCatalog.listTables(database);
        if (!tables.isEmpty() && !cascade) {
            throw new IllegalStateException("Namespace '" + database + "' is non empty.");
        }
        for (TableIDWithFormat id : tables) {
            this.unifiedCatalog.dropTable(database, id.getIdentifier().getTableName(), true);
        }
        this.unifiedCatalog.dropDatabase(database);
        return !this.unifiedCatalog.databaseExists(database);
    }

    public boolean dropNamespace(String[] namespace) throws NoSuchNamespaceException {
        return this.dropNamespace(namespace, false);
    }

    public Identifier[] listTables(String[] namespace) throws NoSuchNamespaceException {
        String database = this.namespaceToDatabase(namespace);
        List tables = this.unifiedCatalog.listTables(database);
        return (Identifier[])tables.stream().map(id -> Identifier.of((String[])new String[]{id.database()}, (String)id.table())).toArray(Identifier[]::new);
    }

    public Table loadTable(Identifier ident) throws org.apache.spark.sql.catalyst.analysis.NoSuchTableException {
        try {
            Identifier originIdent = this.originIdentifierOfSubTable(ident);
            if (originIdent == null) {
                originIdent = ident;
            }
            String database = this.namespaceToDatabase(originIdent.namespace());
            AmoroTable table = this.unifiedCatalog.loadTable(database, originIdent.name());
            return this.tableCatalog(table.format()).loadTable(ident);
        }
        catch (NoSuchTableException e) {
            throw new org.apache.spark.sql.catalyst.analysis.NoSuchTableException(ident);
        }
    }

    private Identifier originIdentifierOfSubTable(Identifier identifier) {
        String[] namespace = identifier.namespace();
        if (identifier.namespace().length == 2) {
            for (SparkTableFormat sparkTableFormat : this.tableFormats.values()) {
                if (!sparkTableFormat.isSubTableName(identifier.name())) continue;
                String[] ns = Arrays.copyOf(namespace, namespace.length - 1);
                String name = namespace[ns.length];
                return Identifier.of((String[])ns, (String)name);
            }
        }
        return null;
    }

    public void invalidateTable(Identifier ident) {
        try {
            AmoroTable table = this.unifiedCatalog.loadTable(this.namespaceToDatabase(ident.namespace()), ident.name());
            this.tableCatalog(table.format()).invalidateTable(ident);
        }
        catch (NoSuchTableException noSuchTableException) {
            // empty catch block
        }
    }

    public boolean tableExists(Identifier ident) {
        return this.unifiedCatalog.tableExists(this.namespaceToDatabase(ident.namespace()), ident.name());
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        String provider = properties.get("provider");
        if (StringUtils.isBlank((CharSequence)provider)) {
            throw new IllegalArgumentException("table provider is required.");
        }
        TableFormat format = TableFormat.valueOf((String)provider.toUpperCase());
        TableCatalog catalog = this.tableCatalog(format);
        return catalog.createTable(ident, schema, partitions, properties);
    }

    public Table alterTable(Identifier ident, TableChange ... changes) throws org.apache.spark.sql.catalyst.analysis.NoSuchTableException {
        try {
            AmoroTable table = this.unifiedCatalog.loadTable(this.namespaceToDatabase(ident.namespace()), ident.name());
            return this.tableCatalog(table.format()).alterTable(ident, changes);
        }
        catch (NoSuchTableException e) {
            throw new org.apache.spark.sql.catalyst.analysis.NoSuchTableException(ident);
        }
    }

    public boolean dropTable(Identifier ident) {
        String database = this.namespaceToDatabase(ident.namespace());
        return this.unifiedCatalog.dropTable(database, ident.name(), false);
    }

    public boolean purgeTable(Identifier ident) throws UnsupportedOperationException {
        String database = this.namespaceToDatabase(ident.namespace());
        return this.unifiedCatalog.dropTable(database, ident.name(), true);
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) throws org.apache.spark.sql.catalyst.analysis.NoSuchTableException, TableAlreadyExistsException {
        String database = this.namespaceToDatabase(oldIdent.namespace());
        String tableName = oldIdent.name();
        AmoroTable table = this.unifiedCatalog.loadTable(database, tableName);
        TableFormat format = table.format();
        TableCatalog catalog = this.tableCatalog(format);
        catalog.renameTable(oldIdent, newIdent);
    }

    public Procedure loadProcedure(Identifier ident) throws NoSuchProcedureException {
        TableCatalog tableCatalog = this.tableCatalog(TableFormat.ICEBERG);
        ProcedureCatalog procedureCatalog = (ProcedureCatalog)tableCatalog;
        return procedureCatalog.loadProcedure(ident);
    }

    protected TableCatalog tableCatalog(TableFormat format) {
        return this.tableCatalogs.computeIfAbsent(format, this::initializeTableCatalog);
    }

    private TableCatalog initializeTableCatalog(TableFormat format) {
        String catalogOptions = format.name().toLowerCase().replace("_", "-") + ".spark-catalog-impl";
        String impl = (String)this.unifiedCatalog.properties().get(catalogOptions);
        if (StringUtils.isBlank((CharSequence)impl)) {
            impl = defaultTableCatalogImplMap.get(format);
        }
        if (StringUtils.isBlank((CharSequence)impl)) {
            throw new IllegalStateException("Failed to initialize spark TableCatalog for format:" + format.name());
        }
        ServiceLoader<FormatCatalogFactory> loader = ServiceLoader.load(FormatCatalogFactory.class);
        FormatCatalogFactory formatCatalogFactory = null;
        for (FormatCatalogFactory factory : loader) {
            if (factory.format() != format) continue;
            formatCatalogFactory = factory;
            break;
        }
        if (formatCatalogFactory == null) {
            throw new IllegalStateException("Can't find format factory for: " + format.name());
        }
        try {
            Class<?> catalogClass = Utils.getContextOrSparkClassLoader().loadClass(impl);
            if (!TableCatalog.class.isAssignableFrom(catalogClass)) {
                throw new IllegalStateException("Plugin class[" + catalogClass.getName() + "] for format: " + format.name() + " does not  implement TableCatalog");
            }
            TableCatalog tableCatalog = (TableCatalog)catalogClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map tableCatalogInitializeProperties = formatCatalogFactory.convertCatalogProperties(this.unifiedCatalog.name(), this.unifiedCatalog.metastoreType(), this.unifiedCatalog.properties());
            if (tableCatalog instanceof SupportAuthentication) {
                ((SupportAuthentication)tableCatalog).setAuthenticationContext(this.unifiedCatalog.authenticationContext());
                tableCatalogInitializeProperties.put(CATALOG_REGISTER_NAME, this.unifiedCatalog.name());
            }
            tableCatalog.initialize(this.name, new CaseInsensitiveStringMap(tableCatalogInitializeProperties));
            return tableCatalog;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot find catalog plugin class for format: " + format, e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to invoke public no-arg constructor for format: " + format.name() + " : " + impl, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to find public no-arg constructor for format: " + format.name() + " : " + impl, e);
        }
    }

    private static /* synthetic */ String[][] lambda$listNamespaces$1(int x$0) {
        return new String[x$0][];
    }
}

