/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkConfParser;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;

public class SparkWriteConf {
    private final Table table;
    private final String branch;
    private final RuntimeConfig sessionConf;
    private final Map<String, String> writeOptions;
    private final SparkConfParser confParser;

    public SparkWriteConf(SparkSession spark, Table table, Map<String, String> writeOptions) {
        this(spark, table, null, writeOptions);
    }

    public SparkWriteConf(SparkSession spark, Table table, String branch, Map<String, String> writeOptions) {
        this.table = table;
        this.branch = branch;
        this.sessionConf = spark.conf();
        this.writeOptions = writeOptions;
        this.confParser = new SparkConfParser(spark, table, writeOptions);
    }

    public boolean checkNullability() {
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("check-nullability")).sessionConf("spark.sql.iceberg.check-nullability")).defaultValue(true).parse();
    }

    public boolean checkOrdering() {
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("check-ordering")).sessionConf("spark.sql.iceberg.check-ordering")).defaultValue(true).parse();
    }

    public boolean handleTimestampWithoutZone() {
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("handle-timestamp-without-timezone")).sessionConf("spark.sql.iceberg.handle-timestamp-without-timezone")).defaultValue(false).parse();
    }

    public String overwriteMode() {
        String overwriteMode = this.writeOptions.get("overwrite-mode");
        return overwriteMode != null ? overwriteMode.toLowerCase(Locale.ROOT) : null;
    }

    public boolean wapEnabled() {
        return ((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().tableProperty("write.wap.enabled")).defaultValue("false").parse();
    }

    public String wapId() {
        return this.sessionConf.get("spark.wap.id", null);
    }

    public boolean mergeSchema() {
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("merge-schema")).option("mergeSchema")).defaultValue(false).parse();
    }

    public int outputSpecId() {
        int outputSpecId = ((SparkConfParser.IntConfParser)this.confParser.intConf().option("output-spec-id")).defaultValue(this.table.spec().specId()).parse();
        Preconditions.checkArgument((boolean)this.table.specs().containsKey(outputSpecId), (String)"Output spec id %s is not a valid spec id for table", (int)outputSpecId);
        return outputSpecId;
    }

    public FileFormat dataFileFormat() {
        String valueAsString = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("write-format")).tableProperty("write.format.default")).defaultValue("parquet").parse();
        return FileFormat.fromString((String)valueAsString);
    }

    public long targetDataFileSize() {
        return ((SparkConfParser.LongConfParser)((SparkConfParser.LongConfParser)this.confParser.longConf().option("target-file-size-bytes")).tableProperty("write.target-file-size-bytes")).defaultValue(0x20000000L).parse();
    }

    public boolean fanoutWriterEnabled() {
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("fanout-enabled")).tableProperty("write.spark.fanout.enabled")).defaultValue(false).parse();
    }

    public FileFormat deleteFileFormat() {
        String valueAsString = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("delete-format")).tableProperty("write.delete.format.default")).parseOptional();
        return valueAsString != null ? FileFormat.fromString((String)valueAsString) : this.dataFileFormat();
    }

    public long targetDeleteFileSize() {
        return ((SparkConfParser.LongConfParser)((SparkConfParser.LongConfParser)this.confParser.longConf().option("target-delete-file-size-bytes")).tableProperty("write.delete.target-file-size-bytes")).defaultValue(0x4000000L).parse();
    }

    public Map<String, String> extraSnapshotMetadata() {
        HashMap extraSnapshotMetadata = Maps.newHashMap();
        this.writeOptions.forEach((key, value) -> {
            if (key.startsWith("snapshot-property.")) {
                extraSnapshotMetadata.put(key.substring("snapshot-property.".length()), value);
            }
        });
        return extraSnapshotMetadata;
    }

    public String rewrittenFileSetId() {
        return ((SparkConfParser.StringConfParser)this.confParser.stringConf().option("rewritten-file-scan-task-set-id")).parseOptional();
    }

    public DistributionMode distributionMode() {
        String modeName = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("distribution-mode")).sessionConf("spark.sql.iceberg.distribution-mode")).tableProperty("write.distribution-mode")).parseOptional();
        if (modeName != null) {
            DistributionMode mode = DistributionMode.fromName((String)modeName);
            return this.adjustWriteDistributionMode(mode);
        }
        return this.defaultWriteDistributionMode();
    }

    private DistributionMode adjustWriteDistributionMode(DistributionMode mode) {
        if (mode == DistributionMode.RANGE && this.table.spec().isUnpartitioned() && this.table.sortOrder().isUnsorted()) {
            return DistributionMode.NONE;
        }
        if (mode == DistributionMode.HASH && this.table.spec().isUnpartitioned()) {
            return DistributionMode.NONE;
        }
        return mode;
    }

    private DistributionMode defaultWriteDistributionMode() {
        if (this.table.sortOrder().isSorted()) {
            return DistributionMode.RANGE;
        }
        if (this.table.spec().isPartitioned()) {
            return DistributionMode.HASH;
        }
        return DistributionMode.NONE;
    }

    public DistributionMode deleteDistributionMode() {
        String deleteModeName = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("distribution-mode")).sessionConf("spark.sql.iceberg.distribution-mode")).tableProperty("write.delete.distribution-mode")).defaultValue("hash").parse();
        return DistributionMode.fromName((String)deleteModeName);
    }

    public DistributionMode updateDistributionMode() {
        String updateModeName = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("distribution-mode")).sessionConf("spark.sql.iceberg.distribution-mode")).tableProperty("write.update.distribution-mode")).defaultValue("hash").parse();
        return DistributionMode.fromName((String)updateModeName);
    }

    public DistributionMode copyOnWriteMergeDistributionMode() {
        String mergeModeName = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("distribution-mode")).sessionConf("spark.sql.iceberg.distribution-mode")).tableProperty("write.merge.distribution-mode")).parseOptional();
        if (mergeModeName != null) {
            DistributionMode mergeMode = DistributionMode.fromName((String)mergeModeName);
            return this.adjustWriteDistributionMode(mergeMode);
        }
        if (this.table.spec().isPartitioned()) {
            return DistributionMode.HASH;
        }
        return this.distributionMode();
    }

    public DistributionMode positionDeltaMergeDistributionMode() {
        String mergeModeName = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("distribution-mode")).sessionConf("spark.sql.iceberg.distribution-mode")).tableProperty("write.merge.distribution-mode")).defaultValue("hash").parse();
        return DistributionMode.fromName((String)mergeModeName);
    }

    public boolean useTableDistributionAndOrdering() {
        return ((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("use-table-distribution-and-ordering")).defaultValue(true).parse();
    }

    public Long validateFromSnapshotId() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("validate-from-snapshot-id")).parseOptional();
    }

    public IsolationLevel isolationLevel() {
        String isolationLevelName = ((SparkConfParser.StringConfParser)this.confParser.stringConf().option("isolation-level")).parseOptional();
        return isolationLevelName != null ? IsolationLevel.fromName((String)isolationLevelName) : null;
    }

    public boolean caseSensitive() {
        return ((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().sessionConf(SQLConf.CASE_SENSITIVE().key())).defaultValue(SQLConf.CASE_SENSITIVE().defaultValueString()).parse();
    }

    public String branch() {
        if (this.wapEnabled()) {
            String wapId = this.wapId();
            String wapBranch = ((SparkConfParser.StringConfParser)this.confParser.stringConf().sessionConf("spark.wap.branch")).parseOptional();
            ValidationException.check((wapId == null || wapBranch == null ? 1 : 0) != 0, (String)"Cannot set both WAP ID and branch, but got ID [%s] and branch [%s]", (Object[])new Object[]{wapId, wapBranch});
            if (wapBranch != null) {
                ValidationException.check((this.branch == null ? 1 : 0) != 0, (String)"Cannot write to both branch and WAP branch, but got branch [%s] and WAP branch [%s]", (Object[])new Object[]{this.branch, wapBranch});
                return wapBranch;
            }
        }
        return this.branch;
    }
}

