/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.functions;

import org.apache.iceberg.IcebergBuild;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class IcebergVersionFunction
implements UnboundFunction {
    public BoundFunction bind(StructType inputType) {
        if (inputType.fields().length > 0) {
            throw new UnsupportedOperationException(String.format("Cannot bind: %s does not accept arguments", this.name()));
        }
        return new IcebergVersionFunctionImpl();
    }

    public String description() {
        return this.name() + " - Returns the runtime Iceberg version";
    }

    public String name() {
        return "iceberg_version";
    }

    static class IcebergVersionFunctionImpl
    implements ScalarFunction<UTF8String> {
        private static final UTF8String VERSION = UTF8String.fromString((String)IcebergBuild.version());

        IcebergVersionFunctionImpl() {
        }

        public static UTF8String invoke() {
            return VERSION;
        }

        public DataType[] inputTypes() {
            return new DataType[0];
        }

        public DataType resultType() {
            return DataTypes.StringType;
        }

        public boolean isResultNullable() {
            return false;
        }

        public String canonicalName() {
            return "iceberg." + this.name();
        }

        public String name() {
            return "iceberg_version";
        }

        public UTF8String produceResult(InternalRow input) {
            return IcebergVersionFunctionImpl.invoke();
        }
    }
}

