/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.component.reverser;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.amoro.server.dashboard.component.reverser.IcebergTypeToSparkType;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.table.descriptor.TableMetaExtract;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.types.DataType;

public class IcebergTableMetaExtract
implements TableMetaExtract<Table> {
    public List<TableMetaExtract.InternalTableMeta> extractTable(Table table) {
        List metadataLogEntries = ((HasTableOperations)table).operations().current().previousFiles();
        List metadataList = metadataLogEntries.stream().map(entry -> TableMetadataParser.read((FileIO)table.io(), (String)entry.file())).collect(Collectors.toList());
        metadataList.add(((HasTableOperations)table).operations().current());
        return metadataList.stream().map(metadata -> new TableMetaExtract.InternalTableMeta(metadata.lastUpdatedMillis(), this.transform(metadata.schema()), metadata.properties())).collect(Collectors.toList());
    }

    private List<TableMetaExtract.InternalSchema> transform(Schema schema) {
        return this.transform(null, new ArrayList<String>(), (Type)schema.asStruct());
    }

    private List<TableMetaExtract.InternalSchema> transform(Integer parent, List<String> parentName, Type type) {
        ArrayList<TableMetaExtract.InternalSchema> result = new ArrayList<TableMetaExtract.InternalSchema>();
        if (type.isStructType()) {
            for (Types.NestedField field : type.asStructType().fields()) {
                ArrayList name = Lists.newArrayList(parentName);
                name.add(field.name());
                Type fieldType = field.type();
                result.add(new TableMetaExtract.InternalSchema(field.fieldId(), parent, this.formatName(name), this.dateTypeToSparkString(fieldType), field.doc(), field.isRequired()));
                result.addAll(this.transform(field.fieldId(), name, field.type()));
            }
        } else if (type.isListType()) {
            ArrayList name = Lists.newArrayList(parentName);
            name.add("element");
            Type elementType = type.asListType().elementType();
            result.add(new TableMetaExtract.InternalSchema(type.asListType().elementId(), parent, this.formatName(name), this.dateTypeToSparkString(elementType), "", false));
            result.addAll(this.transform(type.asListType().elementId(), name, type.asListType().elementType()));
        } else if (type.isMapType()) {
            ArrayList keyName = Lists.newArrayList(parentName);
            keyName.add("key");
            Type keyType = type.asMapType().keyType();
            int keyId = type.asMapType().keyId();
            result.add(new TableMetaExtract.InternalSchema(keyId, parent, this.formatName(keyName), this.dateTypeToSparkString(keyType), "", false));
            result.addAll(this.transform(keyId, keyName, keyType));
            ArrayList valueName = Lists.newArrayList(parentName);
            valueName.add("value");
            Type valueType = type.asMapType().valueType();
            int valueId = type.asMapType().valueId();
            result.add(new TableMetaExtract.InternalSchema(valueId, parent, this.formatName(valueName), this.dateTypeToSparkString(valueType), "", false));
            result.addAll(this.transform(valueId, valueName, valueType));
        }
        return result;
    }

    private String formatName(List<String> names) {
        return String.join((CharSequence)".", names);
    }

    private String dateTypeToSparkString(Type type) {
        return ((DataType)TypeUtil.visit((Type)type, (TypeUtil.SchemaVisitor)new IcebergTypeToSparkType())).catalogString();
    }
}

